/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeParser;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeReader;
import org.geotools.geometry.jts.coordinatesequence.CoordinateSequences;

public class PolygonParser
extends ShapeParser {
    public PolygonParser(GeometryFactory geometryFactory) {
        super(geometryFactory);
    }

    @Override
    public Geometry parseShape(ShapeReader reader) {
        reader.skip(32);
        int numRings = reader.readInt();
        int numPoints = reader.readInt();
        int[] offsets = this.readOffsets(reader, numRings, numPoints);
        boolean shellsCCW = false;
        LinearRing shell = null;
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < numRings; ++i) {
            int readScale = offsets[i + 1] - offsets[i];
            CoordinateSequence csRing = this.readCoordinates(reader, readScale);
            if (csRing.size() <= 3) continue;
            LinearRing ring = this.geometryFactory.createLinearRing(csRing);
            if (shell == null) {
                shell = ring;
                shellsCCW = CoordinateSequences.isCCW(csRing);
                continue;
            }
            if (CoordinateSequences.isCCW(csRing) != shellsCCW) {
                holes.add(ring);
                continue;
            }
            if (shell != null) {
                Polygon polygon = this.geometryFactory.createPolygon(shell, GeometryFactory.toLinearRingArray(holes));
                polygons.add(polygon);
            }
            shell = ring;
            holes.clear();
        }
        if (shell != null) {
            Polygon polygon = this.geometryFactory.createPolygon(shell, GeometryFactory.toLinearRingArray(holes));
            polygons.add(polygon);
        }
        if (polygons.size() == 1) {
            return (Geometry)polygons.get(0);
        }
        return this.geometryFactory.createMultiPolygon(polygons.toArray(new Polygon[0]));
    }
}

