/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.Serializable;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeReader;

public abstract class ShapeParser
implements Serializable {
    protected final GeometryFactory geometryFactory;

    protected ShapeParser(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public abstract Geometry parseShape(ShapeReader var1);

    protected CoordinateSequence readCoordinates(ShapeReader reader, int numPoints) {
        CoordinateSequence coordinateSequence = this.geometryFactory.getCoordinateSequenceFactory().create(numPoints, 2);
        for (int i = 0; i < numPoints; ++i) {
            coordinateSequence.setOrdinate(i, 0, reader.readDouble());
            coordinateSequence.setOrdinate(i, 1, reader.readDouble());
        }
        return coordinateSequence;
    }

    protected int[] readOffsets(ShapeReader reader, int numParts, int maxOffset) {
        int[] offsets = new int[numParts + 1];
        for (int i = 0; i < numParts; ++i) {
            offsets[i] = reader.readInt();
        }
        offsets[numParts] = maxOffset;
        return offsets;
    }
}

