/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp;

import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.Serializable;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.MultiPointParser;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.PointParser;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.PolyLineParser;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.PolygonParser;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeParser;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.TypeUnknownException;

public enum ShapeType implements Serializable
{
    UNDEFINED(0),
    POINT(1),
    POLYLINE(3),
    POLYGON(5),
    MULTIPOINT(8);

    private final int id;

    private ShapeType(int id) {
        this.id = id;
    }

    public static ShapeType getType(int id) {
        ShapeType type;
        switch (id) {
            case 1: {
                type = POINT;
                break;
            }
            case 3: {
                type = POLYLINE;
                break;
            }
            case 5: {
                type = POLYGON;
                break;
            }
            case 8: {
                type = MULTIPOINT;
                break;
            }
            default: {
                type = UNDEFINED;
            }
        }
        return type;
    }

    public ShapeParser getParser(GeometryFactory geometryFactory) {
        switch (this) {
            case POINT: {
                return new PointParser(geometryFactory);
            }
            case POLYLINE: {
                return new PolyLineParser(geometryFactory);
            }
            case POLYGON: {
                return new PolygonParser(geometryFactory);
            }
            case MULTIPOINT: {
                return new MultiPointParser(geometryFactory);
            }
        }
        throw new TypeUnknownException(this.id);
    }

    public int getId() {
        return this.id;
    }
}

