/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.geometryObjects;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.quadtree.Node;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jts.index.strtree.AbstractNode;
import com.vividsolutions.jts.index.strtree.Boundable;
import com.vividsolutions.jts.index.strtree.ItemBoundable;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.datasyslab.geospark.geometryObjects.GeometrySerde;

public class SpatialIndexSerde
extends Serializer {
    private static final Logger log = Logger.getLogger(SpatialIndexSerde.class);
    private GeometrySerde geometrySerde;

    public SpatialIndexSerde() {
        this.geometrySerde = new GeometrySerde();
    }

    public SpatialIndexSerde(GeometrySerde geometrySerde) {
        this.geometrySerde = geometrySerde;
    }

    public void write(Kryo kryo, Output output, Object o) {
        if (o instanceof Quadtree) {
            this.writeType(output, Type.QUADTREE);
            Quadtree tree = (Quadtree)o;
            if (tree.isEmpty()) {
                output.writeByte(0);
            } else {
                output.writeByte(1);
                List items = tree.getRoot().getItems();
                output.writeInt(items.size());
                for (Object item : items) {
                    this.geometrySerde.write(kryo, output, item);
                }
                Node[] subNodes = tree.getRoot().getSubnode();
                for (int i = 0; i < 4; ++i) {
                    this.writeQuadTreeNode(kryo, output, subNodes[i]);
                }
            }
        } else if (o instanceof STRtree) {
            this.writeType(output, Type.RTREE);
            STRtree tree = (STRtree)o;
            output.writeInt(tree.getNodeCapacity());
            if (tree.isEmpty()) {
                output.writeByte(0);
            } else {
                output.writeByte(1);
                output.writeByte(tree.isBuilt() ? 1 : 0);
                if (!tree.isBuilt()) {
                    ArrayList itemBoundables = tree.getItemBoundables();
                    output.writeInt(itemBoundables.size());
                    for (Object obj : itemBoundables) {
                        if (!(obj instanceof ItemBoundable)) {
                            throw new UnsupportedOperationException(" itemBoundables should only contain ItemBoundable objects ");
                        }
                        ItemBoundable itemBoundable = (ItemBoundable)obj;
                        this.writeItemBoundable(kryo, output, itemBoundable);
                    }
                } else {
                    this.writeSTRTreeNode(kryo, output, tree.getRoot());
                }
            }
        } else {
            throw new UnsupportedOperationException(" index type not supported ");
        }
    }

    public Object read(Kryo kryo, Input input, Class aClass) {
        byte typeID = input.readByte();
        Type indexType = Type.fromId(typeID);
        switch (indexType) {
            case QUADTREE: {
                int i;
                boolean notEmpty;
                Quadtree index = new Quadtree();
                boolean bl = notEmpty = (input.readByte() & 1) == 1;
                if (!notEmpty) {
                    return index;
                }
                int itemSize = input.readInt();
                ArrayList<Object> items = new ArrayList<Object>();
                for (i = 0; i < itemSize; ++i) {
                    items.add(this.geometrySerde.read(kryo, input, Geometry.class));
                }
                index.getRoot().setItems(items);
                for (i = 0; i < 4; ++i) {
                    index.getRoot().getSubnode()[i] = this.readQuadTreeNode(kryo, input);
                }
                return index;
            }
            case RTREE: {
                boolean notEmpty;
                int nodeCapacity = input.readInt();
                boolean bl = notEmpty = (input.readByte() & 1) == 1;
                if (notEmpty) {
                    boolean built;
                    STRtree index = new STRtree(nodeCapacity);
                    boolean bl2 = built = (input.readByte() & 1) == 1;
                    if (built) {
                        index.setBuilt(true);
                        index.setItemBoundables(null);
                        index.setRoot(this.readSTRtreeNode(kryo, input));
                    } else {
                        ArrayList<ItemBoundable> itemBoundables = new ArrayList<ItemBoundable>();
                        int itemSize = input.readInt();
                        for (int i = 0; i < itemSize; ++i) {
                            itemBoundables.add(this.readItemBoundable(kryo, input));
                        }
                        index.setItemBoundables(itemBoundables);
                    }
                    return index;
                }
                return new STRtree(nodeCapacity);
            }
        }
        throw new UnsupportedOperationException("can't deserialize spatial index of type" + (Object)((Object)indexType));
    }

    private void writeQuadTreeNode(Kryo kryo, Output output, Node node) {
        if (node == null || node.isEmpty()) {
            output.writeByte(0);
        } else {
            output.writeByte(1);
            this.geometrySerde.write(kryo, output, node.getEnvelope());
            output.writeInt(node.getLevel());
            List items = node.getItems();
            output.writeInt(items.size());
            for (Object obj : items) {
                this.geometrySerde.write(kryo, output, obj);
            }
            Node[] subNodes = node.getSubnode();
            for (int i = 0; i < 4; ++i) {
                this.writeQuadTreeNode(kryo, output, subNodes[i]);
            }
        }
    }

    private Node readQuadTreeNode(Kryo kryo, Input input) {
        int i;
        boolean notEmpty;
        boolean bl = notEmpty = (input.readByte() & 1) == 1;
        if (!notEmpty) {
            return null;
        }
        Envelope envelope = (Envelope)this.geometrySerde.read(kryo, input, Envelope.class);
        int level = input.readInt();
        Node node = new Node(envelope, level);
        int itemSize = input.readInt();
        ArrayList<Object> items = new ArrayList<Object>();
        for (i = 0; i < itemSize; ++i) {
            items.add(this.geometrySerde.read(kryo, input, Geometry.class));
        }
        node.setItems(items);
        for (i = 0; i < 4; ++i) {
            node.getSubnode()[i] = this.readQuadTreeNode(kryo, input);
        }
        return node;
    }

    private void writeSTRTreeNode(Kryo kryo, Output output, AbstractNode node) {
        output.writeInt(node.getLevel());
        List children = node.getChildBoundables();
        int childrenSize = children.size();
        output.writeInt(childrenSize);
        if (childrenSize > 0) {
            if (children.get(0) instanceof AbstractNode) {
                output.writeByte(0);
                for (Object obj : children) {
                    AbstractNode child = (AbstractNode)obj;
                    this.writeSTRTreeNode(kryo, output, child);
                }
            } else if (children.get(0) instanceof ItemBoundable) {
                output.writeByte(1);
                for (Object obj : children) {
                    this.writeItemBoundable(kryo, output, (ItemBoundable)obj);
                }
            } else {
                throw new UnsupportedOperationException("wrong node type of STRtree");
            }
        }
    }

    private STRtree.STRtreeNode readSTRtreeNode(Kryo kryo, Input input) {
        int level = input.readInt();
        STRtree.STRtreeNode node = new STRtree.STRtreeNode(level);
        int childrenSize = input.readInt();
        boolean isLeaf = (input.readByte() & 1) == 1;
        ArrayList<Boundable> children = new ArrayList<Boundable>();
        if (isLeaf) {
            for (int i = 0; i < childrenSize; ++i) {
                children.add(this.readItemBoundable(kryo, input));
            }
        } else {
            for (int i = 0; i < childrenSize; ++i) {
                children.add(this.readSTRtreeNode(kryo, input));
            }
        }
        node.setChildBoundables(children);
        return node;
    }

    private void writeItemBoundable(Kryo kryo, Output output, ItemBoundable itemBoundable) {
        this.geometrySerde.write(kryo, output, itemBoundable.getBounds());
        this.geometrySerde.write(kryo, output, itemBoundable.getItem());
    }

    private ItemBoundable readItemBoundable(Kryo kryo, Input input) {
        return new ItemBoundable(this.geometrySerde.read(kryo, input, Envelope.class), this.geometrySerde.read(kryo, input, Geometry.class));
    }

    private void writeType(Output output, Type type) {
        output.writeByte((byte)type.id);
    }

    private static enum Type {
        QUADTREE(0),
        RTREE(1);

        private final int id;

        private Type(int id) {
            this.id = id;
        }

        public static Type fromId(int id) {
            for (Type type : Type.values()) {
                if (type.id != id) continue;
                return type;
            }
            return null;
        }
    }
}

