/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.joinJudgement;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.SpatialIndex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.spark.api.java.function.FlatMapFunction2;
import org.datasyslab.geospark.joinJudgement.DedupParams;
import org.datasyslab.geospark.joinJudgement.JudgementBase;

public class LeftIndexLookupJudgement<T extends Geometry, U extends Geometry>
extends JudgementBase
implements FlatMapFunction2<Iterator<SpatialIndex>, Iterator<U>, Pair<T, U>>,
Serializable {
    public LeftIndexLookupJudgement(boolean considerBoundaryIntersection, @Nullable DedupParams dedupParams) {
        super(considerBoundaryIntersection, dedupParams);
    }

    public Iterator<Pair<T, U>> call(Iterator<SpatialIndex> indexIterator, Iterator<U> streamShapes) throws Exception {
        ArrayList<Pair> result = new ArrayList<Pair>();
        if (!indexIterator.hasNext() || !streamShapes.hasNext()) {
            return result.iterator();
        }
        this.initPartition();
        SpatialIndex treeIndex = indexIterator.next();
        while (streamShapes.hasNext()) {
            Geometry streamShape = (Geometry)streamShapes.next();
            List candidates = treeIndex.query(streamShape.getEnvelopeInternal());
            for (Geometry candidate : candidates) {
                if (!this.match(candidate, streamShape)) continue;
                result.add(Pair.of((Object)candidate, (Object)streamShape));
            }
        }
        return result.iterator();
    }
}

