/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.monitoring;

import org.apache.spark.Success$;
import org.apache.spark.TaskEndReason;
import org.apache.spark.scheduler.AccumulableInfo;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u0017\t\u0001r)Z8Ta\u0006\u00148\u000eT5ti\u0016tWM\u001d\u0006\u0003\u0007\u0011\t!\"\\8oSR|'/\u001b8h\u0015\t)a!\u0001\u0005hK>\u001c\b/\u0019:l\u0015\t9\u0001\"\u0001\u0006eCR\f7/_:mC\nT\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\u000b\u000e\u00039Q!a\u0004\t\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\t\u0013\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019\u0002\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003+9\u0011Qb\u00159be.d\u0015n\u001d;f]\u0016\u0014\b\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\tQ\u0002!D\u0001\u0003\u0011\u001da\u0002A1A\u0005\nu\tAbY8v]R,'OT1nKN,\u0012A\b\t\u0004?\u00112S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013AC2pY2,7\r^5p]*\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&A\t\u00191+Z9\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013\u0001\u00027b]\u001eT\u0011aK\u0001\u0005U\u00064\u0018-\u0003\u0002.Q\t11\u000b\u001e:j]\u001eDaa\f\u0001!\u0002\u0013q\u0012!D2pk:$XM\u001d(b[\u0016\u001c\b\u0005C\u00042\u0001\t\u0007I\u0011\u0002\u001a\u0002\u0017Q\f7o[\"qkRKW.Z\u000b\u0002gA!AgN\u001dA\u001b\u0005)$B\u0001\u001c!\u0003\u001diW\u000f^1cY\u0016L!\u0001O\u001b\u0003\u00075\u000b\u0007\u000f\u0005\u0003;wujT\"\u0001\u0012\n\u0005q\u0012#A\u0002+va2,'\u0007\u0005\u0002(}%\u0011q\b\u000b\u0002\b\u0013:$XmZ3s!\tQ\u0014)\u0003\u0002CE\t!Aj\u001c8h\u0011\u0019!\u0005\u0001)A\u0005g\u0005aA/Y:l\u0007B,H+[7fA!)a\t\u0001C!\u000f\u0006IqN\u001c+bg.,e\u000e\u001a\u000b\u0003\u0011.\u0003\"AO%\n\u0005)\u0013#\u0001B+oSRDQ\u0001T#A\u00025\u000bq\u0001^1tW\u0016sG\r\u0005\u0002\u000e\u001d&\u0011qJ\u0004\u0002\u0015'B\f'o\u001b'jgR,g.\u001a:UCN\\WI\u001c3\t\u000bE\u0003A\u0011\t*\u0002!=t7\u000b^1hK\u000e{W\u000e\u001d7fi\u0016$GC\u0001%T\u0011\u0015!\u0006\u000b1\u0001V\u00039\u0019H/Y4f\u0007>l\u0007\u000f\\3uK\u0012\u0004\"!\u0004,\n\u0005]s!aG*qCJ\\G*[:uK:,'o\u0015;bO\u0016\u001cu.\u001c9mKR,G\r")
public class GeoSparkListener
extends SparkListener {
    private final Seq<String> counterNames = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"buildCount", "streamCount", "candidateCount", "resultCount"}));
    private final Map<Tuple2<Integer, Integer>, Object> org$datasyslab$geospark$monitoring$GeoSparkListener$$taskCpuTime = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

    private Seq<String> counterNames() {
        return this.counterNames;
    }

    public Map<Tuple2<Integer, Integer>, Object> org$datasyslab$geospark$monitoring$GeoSparkListener$$taskCpuTime() {
        return this.org$datasyslab$geospark$monitoring$GeoSparkListener$$taskCpuTime;
    }

    public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        TaskEndReason taskEndReason = taskEnd.reason();
        Success$ success$ = Success$.MODULE$;
        if (!(taskEndReason != null ? !taskEndReason.equals(success$) : success$ != null)) {
            long cpuTime = taskEnd.taskMetrics().executorCpuTime();
            int partitionId = Integer.parseInt(new StringOps(Predef$.MODULE$.augmentString(taskEnd.taskInfo().id())).split('.')[0]);
            this.org$datasyslab$geospark$monitoring$GeoSparkListener$$taskCpuTime().update((Object)new Tuple2((Object)Predef$.MODULE$.int2Integer(taskEnd.stageId()), (Object)Predef$.MODULE$.int2Integer(partitionId)), (Object)BoxesRunTime.boxToLong((long)cpuTime));
        }
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        HashMap accumulables = stageCompleted.stageInfo().accumulables();
        if (this.getCounterOption$1("buildCount", accumulables).isDefined()) {
            int stageId = stageCompleted.stageInfo().stageId();
            scala.collection.immutable.Map buildCounts = (scala.collection.immutable.Map)this.getCounter$1("buildCount", accumulables);
            scala.collection.immutable.Map streamCounts = (scala.collection.immutable.Map)this.getCounter$1("streamCount", accumulables);
            scala.collection.immutable.Map candidateCounts = (scala.collection.immutable.Map)this.getCounter$1("candidateCount", accumulables);
            scala.collection.immutable.Map resultCounts = (scala.collection.immutable.Map)this.getCounter$1("resultCount", accumulables);
            List stats = (List)((TraversableOnce)buildCounts.map((Function1)new Serializable(this, stageId, streamCounts, candidateCounts, resultCounts){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GeoSparkListener $outer;
                private final int stageId$1;
                private final scala.collection.immutable.Map streamCounts$1;
                private final scala.collection.immutable.Map candidateCounts$1;
                private final scala.collection.immutable.Map resultCounts$1;

                public final Tuple6<Object, Object, Object, Object, Object, Object> apply(Tuple2<Object, Object> x0$2) {
                    Tuple2<Object, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        int partitionId = tuple2._1$mcI$sp();
                        long buildCount = tuple2._2$mcJ$sp();
                        long streamCount = BoxesRunTime.unboxToLong((Object)this.streamCounts$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)partitionId), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return -1L;
                            }
                        }));
                        long candidateCount = BoxesRunTime.unboxToLong((Object)this.candidateCounts$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)partitionId), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return -1L;
                            }
                        }));
                        long resultCount = BoxesRunTime.unboxToLong((Object)this.resultCounts$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)partitionId), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return -1L;
                            }
                        }));
                        long cpuTime = BoxesRunTime.unboxToLong((Object)this.$outer.org$datasyslab$geospark$monitoring$GeoSparkListener$$taskCpuTime().getOrElse((Object)new Tuple2((Object)Predef$.MODULE$.int2Integer(this.stageId$1), (Object)Predef$.MODULE$.int2Integer(partitionId)), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return -1L;
                            }
                        }));
                        Tuple6 tuple6 = new Tuple6((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)BoxesRunTime.boxToLong((long)buildCount), (Object)BoxesRunTime.boxToLong((long)streamCount), (Object)BoxesRunTime.boxToLong((long)candidateCount), (Object)BoxesRunTime.boxToLong((long)resultCount), (Object)BoxesRunTime.boxToLong((long)cpuTime));
                        return tuple6;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.stageId$1 = stageId$1;
                    this.streamCounts$1 = streamCounts$1;
                    this.candidateCounts$1 = candidateCounts$1;
                    this.resultCounts$1 = resultCounts$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).toList().sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(Tuple6<Object, Object, Object, Object, Object, Object> x0$3) {
                    Tuple6<Object, Object, Object, Object, Object, Object> tuple6 = x0$3;
                    if (tuple6 != null) {
                        long cpuTime;
                        long l = cpuTime = BoxesRunTime.unboxToLong((Object)tuple6._6());
                        return l;
                    }
                    throw new MatchError(tuple6);
                }
            }, (Ordering)Ordering.Long$.MODULE$);
            Console$.MODULE$.out().println("Spatial join is complete. Execution statistics:");
            Console$.MODULE$.out().println("Partition\t CPU Time (s)\tBuild ##\tStream ##\tCandidates ##\tResults ##");
            stats.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple6<Object, Object, Object, Object, Object, Object> x0$4) {
                    Tuple6<Object, Object, Object, Object, Object, Object> tuple6 = x0$4;
                    if (tuple6 != null) {
                        int partitionId = BoxesRunTime.unboxToInt((Object)tuple6._1());
                        long buildCount = BoxesRunTime.unboxToLong((Object)tuple6._2());
                        long streamCount = BoxesRunTime.unboxToLong((Object)tuple6._3());
                        long candidateCount = BoxesRunTime.unboxToLong((Object)tuple6._4());
                        long resultCount = BoxesRunTime.unboxToLong((Object)tuple6._5());
                        long cpuTime = BoxesRunTime.unboxToLong((Object)tuple6._6());
                        int arg$macro$1 = partitionId;
                        long arg$macro$2 = cpuTime / 1000L;
                        long arg$macro$3 = buildCount;
                        long arg$macro$4 = streamCount;
                        long arg$macro$5 = candidateCount;
                        long arg$macro$6 = resultCount;
                        Console$.MODULE$.out().println(new StringBuilder().append((Object)new StringOps("% 10d\t% 10d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1), BoxesRunTime.boxToLong((long)arg$macro$2)}))).append((Object)new StringOps("% 10d\t% 10d\t% 10d\t% 10d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$3), BoxesRunTime.boxToLong((long)arg$macro$4), BoxesRunTime.boxToLong((long)arg$macro$5), BoxesRunTime.boxToLong((long)arg$macro$6)}))).toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple6);
                }
            });
        }
    }

    private final Option getCounterOption$1(String name, HashMap accumulables$1) {
        return accumulables$1.find((Function1)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final boolean apply(Tuple2<Object, AccumulableInfo> x0$1) {
                Tuple2<Object, AccumulableInfo> tuple2 = x0$1;
                if (tuple2 != null) {
                    AccumulableInfo v = (AccumulableInfo)tuple2._2();
                    Option option = v.name();
                    Some some = new Some((Object)new StringBuilder().append((Object)"geospark.spatialjoin.").append((Object)this.name$1).toString());
                    boolean bl = !(option != null ? !option.equals(some) : some != null);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.name$1 = name$1;
            }
        });
    }

    private final Object getCounter$1(String name, HashMap accumulables$1) {
        return ((AccumulableInfo)((Tuple2)this.getCounterOption$1(name, accumulables$1).get())._2()).value().get();
    }
}

