/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.rangeJudgement;

import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class JudgementBase<U extends Geometry>
implements Serializable {
    private static final Logger log = LogManager.getLogger(JudgementBase.class);
    private boolean considerBoundaryIntersection;
    U queryGeometry;
    protected boolean leftCoveredByRight = true;

    public JudgementBase(U queryWindow, boolean considerBoundaryIntersection, boolean leftCoveredByRight) {
        this.considerBoundaryIntersection = considerBoundaryIntersection;
        this.queryGeometry = queryWindow;
        this.leftCoveredByRight = leftCoveredByRight;
    }

    public boolean match(Geometry spatialObject, Geometry queryWindow) {
        return this.considerBoundaryIntersection ? queryWindow.intersects(spatialObject) : queryWindow.covers(spatialObject);
    }
}

