/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.showcase;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.storage.StorageLevel;
import org.datasyslab.geospark.enums.FileDataSplitter;
import org.datasyslab.geospark.enums.GridType;
import org.datasyslab.geospark.enums.IndexType;
import org.datasyslab.geospark.formatMapper.shapefileParser.ShapefileRDD;
import org.datasyslab.geospark.serde.GeoSparkKryoRegistrator;
import org.datasyslab.geospark.spatialOperator.JoinQuery;
import org.datasyslab.geospark.spatialOperator.KNNQuery;
import org.datasyslab.geospark.spatialOperator.RangeQuery;
import org.datasyslab.geospark.spatialRDD.CircleRDD;
import org.datasyslab.geospark.spatialRDD.PointRDD;
import org.datasyslab.geospark.spatialRDD.PolygonRDD;

public class Example
implements Serializable {
    public static JavaSparkContext sc;
    static GeometryFactory geometryFactory;
    static String PointRDDInputLocation;
    static Integer PointRDDOffset;
    static Integer PointRDDNumPartitions;
    static FileDataSplitter PointRDDSplitter;
    static IndexType PointRDDIndexType;
    static PointRDD objectRDD;
    static String PolygonRDDInputLocation;
    static Integer PolygonRDDStartOffset;
    static Integer PolygonRDDEndOffset;
    static Integer PolygonRDDNumPartitions;
    static FileDataSplitter PolygonRDDSplitter;
    static PolygonRDD queryWindowRDD;
    static GridType joinQueryPartitioningType;
    static int eachQueryLoopTimes;
    static Point kNNQueryPoint;
    static Envelope rangeQueryWindow;
    static String ShapeFileInputLocation;

    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("GeoSparkRunnableExample").setMaster("local[2]");
        conf.set("spark.serializer", KryoSerializer.class.getName());
        conf.set("spark.kryo.registrator", GeoSparkKryoRegistrator.class.getName());
        sc = new JavaSparkContext(conf);
        Logger.getLogger((String)"org").setLevel(Level.WARN);
        Logger.getLogger((String)"akka").setLevel(Level.WARN);
        String resourceFolder = System.getProperty("user.dir") + "/src/test/resources/";
        PointRDDInputLocation = resourceFolder + "arealm-small.csv";
        PointRDDSplitter = FileDataSplitter.CSV;
        PointRDDIndexType = IndexType.RTREE;
        PointRDDNumPartitions = 5;
        PointRDDOffset = 0;
        PolygonRDDInputLocation = resourceFolder + "primaryroads-polygon.csv";
        PolygonRDDSplitter = FileDataSplitter.CSV;
        PolygonRDDNumPartitions = 5;
        PolygonRDDStartOffset = 0;
        PolygonRDDEndOffset = 8;
        geometryFactory = new GeometryFactory();
        kNNQueryPoint = geometryFactory.createPoint(new Coordinate(-84.01, 34.01));
        rangeQueryWindow = new Envelope(-90.01, -80.01, 30.01, 40.01);
        joinQueryPartitioningType = GridType.QUADTREE;
        eachQueryLoopTimes = 5;
        ShapeFileInputLocation = resourceFolder + "shapefiles/polygon";
        try {
            Example.testSpatialRangeQuery();
            Example.testSpatialRangeQueryUsingIndex();
            Example.testSpatialKnnQuery();
            Example.testSpatialKnnQueryUsingIndex();
            Example.testSpatialJoinQuery();
            Example.testSpatialJoinQueryUsingIndex();
            Example.testDistanceJoinQuery();
            Example.testDistanceJoinQueryUsingIndex();
            Example.testCRSTransformationSpatialRangeQuery();
            Example.testCRSTransformationSpatialRangeQueryUsingIndex();
            Example.testLoadShapefileIntoPolygonRDD();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("GeoSpark DEMOs failed!");
            return;
        }
        sc.stop();
        System.out.println("All GeoSpark DEMOs passed!");
    }

    public static void testSpatialRangeQuery() throws Exception {
        objectRDD = new PointRDD(sc, PointRDDInputLocation, PointRDDOffset, PointRDDSplitter, true, StorageLevel.MEMORY_ONLY());
        Example.objectRDD.rawSpatialRDD.persist(StorageLevel.MEMORY_ONLY());
        for (int i = 0; i < eachQueryLoopTimes; ++i) {
            long resultSize = RangeQuery.SpatialRangeQuery(objectRDD, rangeQueryWindow, false, false).count();
            assert (resultSize > -1L);
        }
    }

    public static void testSpatialRangeQueryUsingIndex() throws Exception {
        objectRDD = new PointRDD(sc, PointRDDInputLocation, PointRDDOffset, PointRDDSplitter, true, StorageLevel.MEMORY_ONLY());
        objectRDD.buildIndex(PointRDDIndexType, false);
        Example.objectRDD.indexedRawRDD.persist(StorageLevel.MEMORY_ONLY());
        for (int i = 0; i < eachQueryLoopTimes; ++i) {
            long resultSize = RangeQuery.SpatialRangeQuery(objectRDD, rangeQueryWindow, false, true).count();
            assert (resultSize > -1L);
        }
    }

    public static void testSpatialKnnQuery() throws Exception {
        objectRDD = new PointRDD(sc, PointRDDInputLocation, PointRDDOffset, PointRDDSplitter, true, StorageLevel.MEMORY_ONLY());
        Example.objectRDD.rawSpatialRDD.persist(StorageLevel.MEMORY_ONLY());
        for (int i = 0; i < eachQueryLoopTimes; ++i) {
            List<Point> result = KNNQuery.SpatialKnnQuery(objectRDD, kNNQueryPoint, 1000, false);
            assert (result.size() > -1);
        }
    }

    public static void testSpatialKnnQueryUsingIndex() throws Exception {
        objectRDD = new PointRDD(sc, PointRDDInputLocation, PointRDDOffset, PointRDDSplitter, true, StorageLevel.MEMORY_ONLY());
        objectRDD.buildIndex(PointRDDIndexType, false);
        Example.objectRDD.indexedRawRDD.persist(StorageLevel.MEMORY_ONLY());
        for (int i = 0; i < eachQueryLoopTimes; ++i) {
            List<Point> result = KNNQuery.SpatialKnnQuery(objectRDD, kNNQueryPoint, 1000, true);
            assert (result.size() > -1);
        }
    }

    public static void testSpatialJoinQuery() throws Exception {
        queryWindowRDD = new PolygonRDD(sc, PolygonRDDInputLocation, PolygonRDDStartOffset, PolygonRDDEndOffset, PolygonRDDSplitter, true);
        objectRDD = new PointRDD(sc, PointRDDInputLocation, PointRDDOffset, PointRDDSplitter, true, StorageLevel.MEMORY_ONLY());
        objectRDD.spatialPartitioning(joinQueryPartitioningType);
        queryWindowRDD.spatialPartitioning(objectRDD.getPartitioner());
        Example.objectRDD.spatialPartitionedRDD.persist(StorageLevel.MEMORY_ONLY());
        Example.queryWindowRDD.spatialPartitionedRDD.persist(StorageLevel.MEMORY_ONLY());
        for (int i = 0; i < eachQueryLoopTimes; ++i) {
            long resultSize = JoinQuery.SpatialJoinQuery(objectRDD, queryWindowRDD, false, true).count();
            assert (resultSize > 0L);
        }
    }

    public static void testSpatialJoinQueryUsingIndex() throws Exception {
        queryWindowRDD = new PolygonRDD(sc, PolygonRDDInputLocation, PolygonRDDStartOffset, PolygonRDDEndOffset, PolygonRDDSplitter, true);
        objectRDD = new PointRDD(sc, PointRDDInputLocation, PointRDDOffset, PointRDDSplitter, true, StorageLevel.MEMORY_ONLY());
        objectRDD.spatialPartitioning(joinQueryPartitioningType);
        queryWindowRDD.spatialPartitioning(objectRDD.getPartitioner());
        objectRDD.buildIndex(PointRDDIndexType, true);
        Example.objectRDD.indexedRDD.persist(StorageLevel.MEMORY_ONLY());
        Example.queryWindowRDD.spatialPartitionedRDD.persist(StorageLevel.MEMORY_ONLY());
        for (int i = 0; i < eachQueryLoopTimes; ++i) {
            long resultSize = JoinQuery.SpatialJoinQuery(objectRDD, queryWindowRDD, true, false).count();
            assert (resultSize > 0L);
        }
    }

    public static void testDistanceJoinQuery() throws Exception {
        objectRDD = new PointRDD(sc, PointRDDInputLocation, PointRDDOffset, PointRDDSplitter, true, StorageLevel.MEMORY_ONLY());
        CircleRDD queryWindowRDD = new CircleRDD(objectRDD, 0.1);
        objectRDD.spatialPartitioning(GridType.QUADTREE);
        queryWindowRDD.spatialPartitioning(objectRDD.getPartitioner());
        Example.objectRDD.spatialPartitionedRDD.persist(StorageLevel.MEMORY_ONLY());
        queryWindowRDD.spatialPartitionedRDD.persist(StorageLevel.MEMORY_ONLY());
        for (int i = 0; i < eachQueryLoopTimes; ++i) {
            long resultSize = JoinQuery.DistanceJoinQuery(objectRDD, queryWindowRDD, false, true).count();
            assert (resultSize > 0L);
        }
    }

    public static void testDistanceJoinQueryUsingIndex() throws Exception {
        objectRDD = new PointRDD(sc, PointRDDInputLocation, PointRDDOffset, PointRDDSplitter, true, StorageLevel.MEMORY_ONLY());
        CircleRDD queryWindowRDD = new CircleRDD(objectRDD, 0.1);
        objectRDD.spatialPartitioning(GridType.QUADTREE);
        queryWindowRDD.spatialPartitioning(objectRDD.getPartitioner());
        objectRDD.buildIndex(IndexType.RTREE, true);
        Example.objectRDD.indexedRDD.persist(StorageLevel.MEMORY_ONLY());
        queryWindowRDD.spatialPartitionedRDD.persist(StorageLevel.MEMORY_ONLY());
        for (int i = 0; i < eachQueryLoopTimes; ++i) {
            long resultSize = JoinQuery.DistanceJoinQuery(objectRDD, queryWindowRDD, true, true).count();
            assert (resultSize > 0L);
        }
    }

    public static void testCRSTransformationSpatialRangeQuery() throws Exception {
        objectRDD = new PointRDD(sc, PointRDDInputLocation, PointRDDOffset, PointRDDSplitter, true, StorageLevel.MEMORY_ONLY(), "epsg:4326", "epsg:3005");
        Example.objectRDD.rawSpatialRDD.persist(StorageLevel.MEMORY_ONLY());
        for (int i = 0; i < eachQueryLoopTimes; ++i) {
            long resultSize = RangeQuery.SpatialRangeQuery(objectRDD, rangeQueryWindow, false, false).count();
            assert (resultSize > -1L);
        }
    }

    public static void testCRSTransformationSpatialRangeQueryUsingIndex() throws Exception {
        objectRDD = new PointRDD(sc, PointRDDInputLocation, PointRDDOffset, PointRDDSplitter, true, StorageLevel.MEMORY_ONLY(), "epsg:4326", "epsg:3005");
        objectRDD.buildIndex(PointRDDIndexType, false);
        Example.objectRDD.indexedRawRDD.persist(StorageLevel.MEMORY_ONLY());
        for (int i = 0; i < eachQueryLoopTimes; ++i) {
            long resultSize = RangeQuery.SpatialRangeQuery(objectRDD, rangeQueryWindow, false, true).count();
            assert (resultSize > -1L);
        }
    }

    public static void testLoadShapefileIntoPolygonRDD() throws Exception {
        ShapefileRDD shapefileRDD = new ShapefileRDD(sc, ShapeFileInputLocation);
        PolygonRDD spatialRDD = new PolygonRDD(shapefileRDD.getPolygonRDD());
        try {
            RangeQuery.SpatialRangeQuery(spatialRDD, new Envelope(-180.0, 180.0, -90.0, 90.0), false, false).count();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

