/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialPartitioning;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.triangulate.VoronoiDiagramBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class VoronoiPartitioning
implements Serializable {
    List<Envelope> grids = new ArrayList<Envelope>();

    public VoronoiPartitioning(List<Envelope> samples, int partitions) throws Exception {
        GeometryFactory fact = new GeometryFactory();
        ArrayList<Point> subSampleList = new ArrayList<Point>();
        for (int i = 0; i < samples.size(); i += samples.size() / partitions) {
            Envelope envelope = samples.get(i);
            Coordinate coordinate = new Coordinate((envelope.getMinX() + envelope.getMaxX()) / 2.0, (envelope.getMinY() + envelope.getMaxY()) / 2.0);
            subSampleList.add(fact.createPoint(coordinate));
        }
        MultiPoint mp = fact.createMultiPoint(subSampleList.toArray(new Point[subSampleList.size()]));
        VoronoiDiagramBuilder voronoiBuilder = new VoronoiDiagramBuilder();
        voronoiBuilder.setSites(mp);
        Geometry voronoiDiagram = voronoiBuilder.getDiagram(fact);
        for (int i = 0; i < voronoiDiagram.getNumGeometries(); ++i) {
            Polygon poly = (Polygon)voronoiDiagram.getGeometryN(i);
            this.grids.add(poly.getEnvelopeInternal());
        }
    }

    public List<Envelope> getGrids() {
        return this.grids;
    }
}

