/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialPartitioning.quadtree;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.datasyslab.geospark.enums.GridType;
import org.datasyslab.geospark.joinJudgement.DedupParams;
import org.datasyslab.geospark.spatialPartitioning.SpatialPartitioner;
import org.datasyslab.geospark.spatialPartitioning.quadtree.QuadRectangle;
import org.datasyslab.geospark.spatialPartitioning.quadtree.StandardQuadTree;
import org.datasyslab.geospark.utils.HalfOpenRectangle;
import scala.Tuple2;

public class QuadTreePartitioner
extends SpatialPartitioner {
    private StandardQuadTree<? extends Geometry> quadTree;

    public QuadTreePartitioner(StandardQuadTree<? extends Geometry> quadTree) {
        super(GridType.QUADTREE, QuadTreePartitioner.getLeafGrids(quadTree));
        this.quadTree = quadTree;
        this.quadTree.dropElements();
    }

    @Override
    public <T extends Geometry> Iterator<Tuple2<Integer, T>> placeObject(T spatialObject) throws Exception {
        Objects.requireNonNull(spatialObject, "spatialObject");
        Envelope envelope = spatialObject.getEnvelopeInternal();
        List<QuadRectangle> matchedPartitions = this.quadTree.findZones(new QuadRectangle(envelope));
        Point point = spatialObject instanceof Point ? (Point)spatialObject : null;
        HashSet<Tuple2> result = new HashSet<Tuple2>();
        for (QuadRectangle rectangle : matchedPartitions) {
            if (point != null && !new HalfOpenRectangle(rectangle.getEnvelope()).contains(point)) continue;
            result.add(new Tuple2((Object)rectangle.partitionId, spatialObject));
        }
        return result.iterator();
    }

    @Override
    @Nullable
    public DedupParams getDedupParams() {
        return new DedupParams(this.grids);
    }

    public int numPartitions() {
        return this.grids.size();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof QuadTreePartitioner)) {
            return false;
        }
        QuadTreePartitioner other = (QuadTreePartitioner)o;
        return other.quadTree.equals(this.quadTree);
    }

    private static List<Envelope> getLeafGrids(StandardQuadTree<? extends Geometry> quadTree) {
        Objects.requireNonNull(quadTree, "quadTree");
        List<QuadRectangle> zones = quadTree.getLeafZones();
        ArrayList<Envelope> grids = new ArrayList<Envelope>();
        for (QuadRectangle zone : zones) {
            grids.add(zone.getEnvelope());
        }
        return grids;
    }
}

