/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialRDD;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Point;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.storage.StorageLevel;
import org.datasyslab.geospark.enums.FileDataSplitter;
import org.datasyslab.geospark.formatMapper.FormatMapper;
import org.datasyslab.geospark.formatMapper.PointFormatMapper;
import org.datasyslab.geospark.spatialRDD.SpatialRDD;

public class PointRDD
extends SpatialRDD<Point> {
    public PointRDD() {
    }

    public PointRDD(JavaRDD<Point> rawSpatialRDD) {
        this.rawSpatialRDD = rawSpatialRDD;
    }

    public PointRDD(JavaRDD<Point> rawSpatialRDD, String sourceEpsgCRSCode, String targetEpsgCode) {
        this.rawSpatialRDD = rawSpatialRDD;
        this.CRSTransform(sourceEpsgCRSCode, targetEpsgCode);
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, Integer Offset, FileDataSplitter splitter, boolean carryInputData, Integer partitions) {
        this(sparkContext, InputLocation, Offset, splitter, carryInputData, partitions, null, null, null);
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, Integer Offset, FileDataSplitter splitter, boolean carryInputData) {
        this(sparkContext, InputLocation, Offset, splitter, carryInputData, null, null, null, null);
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter, boolean carryInputData, Integer partitions) {
        this(sparkContext, InputLocation, null, splitter, carryInputData, partitions, null, null, null);
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter, boolean carryInputData) {
        this(sparkContext, InputLocation, null, splitter, carryInputData, null, null, null, null);
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, Integer partitions, FlatMapFunction userSuppliedMapper) {
        this.setRawSpatialRDD(sparkContext.textFile(InputLocation, partitions.intValue()).mapPartitions(userSuppliedMapper));
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, FlatMapFunction userSuppliedMapper) {
        this.setRawSpatialRDD(sparkContext.textFile(InputLocation).mapPartitions(userSuppliedMapper));
    }

    public PointRDD(JavaRDD<Point> rawSpatialRDD, Envelope datasetBoundary, Integer approximateTotalCount) {
        this.rawSpatialRDD = rawSpatialRDD;
        this.boundaryEnvelope = datasetBoundary;
        this.approximateTotalCount = approximateTotalCount.intValue();
    }

    public PointRDD(JavaRDD<Point> rawSpatialRDD, String sourceEpsgCRSCode, String targetEpsgCode, Envelope datasetBoundary, Integer approximateTotalCount) {
        this.rawSpatialRDD = rawSpatialRDD;
        this.CRSTransform(sourceEpsgCRSCode, targetEpsgCode);
        this.boundaryEnvelope = datasetBoundary;
        this.approximateTotalCount = approximateTotalCount.intValue();
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, Integer Offset, FileDataSplitter splitter, boolean carryInputData, Integer partitions, Envelope datasetBoundary, Integer approximateTotalCount) {
        this(sparkContext, InputLocation, Offset, splitter, carryInputData, partitions, null, null, null);
        this.boundaryEnvelope = datasetBoundary;
        this.approximateTotalCount = approximateTotalCount.intValue();
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, Integer Offset, FileDataSplitter splitter, boolean carryInputData, Envelope datasetBoundary, Integer approximateTotalCount) {
        this(sparkContext, InputLocation, Offset, splitter, carryInputData, null, null, null, null);
        this.boundaryEnvelope = datasetBoundary;
        this.approximateTotalCount = approximateTotalCount.intValue();
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter, boolean carryInputData, Integer partitions, Envelope datasetBoundary, Integer approximateTotalCount) {
        this(sparkContext, InputLocation, null, splitter, carryInputData, partitions, null, null, null);
        this.boundaryEnvelope = datasetBoundary;
        this.approximateTotalCount = approximateTotalCount.intValue();
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter, boolean carryInputData, Envelope datasetBoundary, Integer approximateTotalCount) {
        this(sparkContext, InputLocation, null, splitter, carryInputData, null, null, null, null);
        this.boundaryEnvelope = datasetBoundary;
        this.approximateTotalCount = approximateTotalCount.intValue();
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, Integer partitions, FlatMapFunction userSuppliedMapper, Envelope datasetBoundary, Integer approximateTotalCount) {
        this.setRawSpatialRDD(sparkContext.textFile(InputLocation, partitions.intValue()).mapPartitions(userSuppliedMapper));
        this.boundaryEnvelope = datasetBoundary;
        this.approximateTotalCount = approximateTotalCount.intValue();
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, FlatMapFunction userSuppliedMapper, Envelope datasetBoundary, Integer approximateTotalCount) {
        this.setRawSpatialRDD(sparkContext.textFile(InputLocation).mapPartitions(userSuppliedMapper));
        this.boundaryEnvelope = datasetBoundary;
        this.approximateTotalCount = approximateTotalCount.intValue();
    }

    public PointRDD(JavaRDD<Point> rawSpatialRDD, StorageLevel newLevel) {
        this.rawSpatialRDD = rawSpatialRDD;
        this.analyze(newLevel);
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, Integer Offset, FileDataSplitter splitter, boolean carryInputData, Integer partitions, StorageLevel newLevel) {
        this(sparkContext, InputLocation, Offset, splitter, carryInputData, partitions, newLevel, null, null);
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, Integer Offset, FileDataSplitter splitter, boolean carryInputData, StorageLevel newLevel) {
        this(sparkContext, InputLocation, Offset, splitter, carryInputData, null, newLevel, null, null);
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter, boolean carryInputData, Integer partitions, StorageLevel newLevel) {
        this(sparkContext, InputLocation, null, splitter, carryInputData, partitions, newLevel, null, null);
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter, boolean carryInputData, StorageLevel newLevel) {
        this(sparkContext, InputLocation, null, splitter, carryInputData, null, newLevel, null, null);
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, Integer partitions, FlatMapFunction userSuppliedMapper, StorageLevel newLevel) {
        this.setRawSpatialRDD(sparkContext.textFile(InputLocation, partitions.intValue()).mapPartitions(userSuppliedMapper));
        this.analyze(newLevel);
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, FlatMapFunction userSuppliedMapper, StorageLevel newLevel) {
        this.setRawSpatialRDD(sparkContext.textFile(InputLocation).mapPartitions(userSuppliedMapper));
        this.analyze(newLevel);
    }

    public PointRDD(JavaRDD<Point> rawSpatialRDD, StorageLevel newLevel, String sourceEpsgCRSCode, String targetEpsgCode) {
        this.rawSpatialRDD = rawSpatialRDD;
        this.CRSTransform(sourceEpsgCRSCode, targetEpsgCode);
        this.analyze(newLevel);
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, Integer Offset, FileDataSplitter splitter, boolean carryInputData, Integer partitions, StorageLevel newLevel, String sourceEpsgCRSCode, String targetEpsgCode) {
        JavaRDD rawTextRDD;
        JavaRDD javaRDD = rawTextRDD = partitions != null ? sparkContext.textFile(InputLocation, partitions.intValue()) : sparkContext.textFile(InputLocation);
        if (Offset != null) {
            this.setRawSpatialRDD(rawTextRDD.mapPartitions((FlatMapFunction)new PointFormatMapper(Offset, splitter, carryInputData)));
        } else {
            this.setRawSpatialRDD(rawTextRDD.mapPartitions((FlatMapFunction)new PointFormatMapper(splitter, carryInputData)));
        }
        if (sourceEpsgCRSCode != null && targetEpsgCode != null) {
            this.CRSTransform(sourceEpsgCRSCode, targetEpsgCode);
        }
        if (newLevel != null) {
            this.analyze(newLevel);
        }
        if (splitter.equals(FileDataSplitter.GEOJSON)) {
            this.fieldNames = FormatMapper.readGeoJsonPropertyNames(rawTextRDD.take(1).get(0).toString());
        }
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, Integer Offset, FileDataSplitter splitter, boolean carryInputData, StorageLevel newLevel, String sourceEpsgCRSCode, String targetEpsgCode) {
        this(sparkContext, InputLocation, Offset, splitter, carryInputData, null, newLevel, sourceEpsgCRSCode, targetEpsgCode);
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter, boolean carryInputData, Integer partitions, StorageLevel newLevel, String sourceEpsgCRSCode, String targetEpsgCode) {
        this(sparkContext, InputLocation, null, splitter, carryInputData, partitions, newLevel, sourceEpsgCRSCode, targetEpsgCode);
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter, boolean carryInputData, StorageLevel newLevel, String sourceEpsgCRSCode, String targetEpsgCode) {
        this(sparkContext, InputLocation, null, splitter, carryInputData, null, newLevel, sourceEpsgCRSCode, targetEpsgCode);
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, Integer partitions, FlatMapFunction userSuppliedMapper, StorageLevel newLevel, String sourceEpsgCRSCode, String targetEpsgCode) {
        this(sparkContext, InputLocation, null, null, false, partitions, newLevel, sourceEpsgCRSCode, targetEpsgCode);
    }

    public PointRDD(JavaSparkContext sparkContext, String InputLocation, FlatMapFunction userSuppliedMapper, StorageLevel newLevel, String sourceEpsgCRSCode, String targetEpsgCode) {
        this(sparkContext, InputLocation, null, null, false, null, newLevel, sourceEpsgCRSCode, targetEpsgCode);
    }
}

