/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.utils;

import com.vividsolutions.jts.geom.Envelope;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.spark.SparkConf;
import org.datasyslab.geospark.enums.GridType;
import org.datasyslab.geospark.enums.IndexType;
import org.datasyslab.geospark.enums.JoinBuildSide;
import org.datasyslab.geospark.enums.JoinSparitionDominantSide;

public class GeoSparkConf
implements Serializable {
    private Boolean useIndex = false;
    private IndexType indexType = IndexType.QUADTREE;
    private JoinSparitionDominantSide joinSparitionDominantSide = JoinSparitionDominantSide.LEFT;
    private JoinBuildSide joinBuildSide = JoinBuildSide.LEFT;
    private Long joinApproximateTotalCount = -1L;
    private Envelope datasetBoundary = new Envelope(0.0, 0.0, 0.0, 0.0);
    private Integer fallbackPartitionNum = -1;
    private GridType joinGridType = GridType.QUADTREE;

    public GeoSparkConf(SparkConf sparkConf) {
        this.useIndex = sparkConf.getBoolean("geospark.global.index", true);
        this.indexType = IndexType.getIndexType(sparkConf.get("geospark.global.indextype", "rtree"));
        this.joinApproximateTotalCount = sparkConf.getLong("geospark.join.approxcount", -1L);
        String[] boundaryString = sparkConf.get("geospark.join.boundary", "0,0,0,0").split(",");
        this.datasetBoundary = new Envelope(Double.parseDouble(boundaryString[0]), Double.parseDouble(boundaryString[0]), Double.parseDouble(boundaryString[0]), Double.parseDouble(boundaryString[0]));
        this.joinGridType = GridType.getGridType(sparkConf.get("geospark.join.gridtype", "quadtree"));
        this.joinBuildSide = JoinBuildSide.getBuildSide(sparkConf.get("geospark.join.indexbuildside", "left"));
        this.joinSparitionDominantSide = JoinSparitionDominantSide.getJoinSparitionDominantSide(sparkConf.get("geospark.join.spatitionside", "left"));
        this.fallbackPartitionNum = sparkConf.getInt("geospark.join.numpartition", -1);
    }

    public Boolean getUseIndex() {
        return this.useIndex;
    }

    public void setUseIndex(Boolean useIndex) {
        this.useIndex = useIndex;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public void setIndexType(IndexType indexType) {
        this.indexType = indexType;
    }

    public Long getJoinApproximateTotalCount() {
        return this.joinApproximateTotalCount;
    }

    public void setJoinApproximateTotalCount(Long joinApproximateTotalCount) {
        this.joinApproximateTotalCount = joinApproximateTotalCount;
    }

    public Envelope getDatasetBoundary() {
        return this.datasetBoundary;
    }

    public void setDatasetBoundary(Envelope datasetBoundary) {
        this.datasetBoundary = datasetBoundary;
    }

    public JoinBuildSide getJoinBuildSide() {
        return this.joinBuildSide;
    }

    public void setJoinBuildSide(JoinBuildSide joinBuildSide) {
        this.joinBuildSide = joinBuildSide;
    }

    public GridType getJoinGridType() {
        return this.joinGridType;
    }

    public void setJoinGridType(GridType joinGridType) {
        this.joinGridType = joinGridType;
    }

    public JoinSparitionDominantSide getJoinSparitionDominantSide() {
        return this.joinSparitionDominantSide;
    }

    public void setJoinSparitionDominantSide(JoinSparitionDominantSide joinSparitionDominantSide) {
        this.joinSparitionDominantSide = joinSparitionDominantSide;
    }

    public Integer getFallbackPartitionNum() {
        return this.fallbackPartitionNum;
    }

    public void setFallbackPartitionNum(Integer fallbackPartitionNum) {
        this.fallbackPartitionNum = fallbackPartitionNum;
    }

    public String toString() {
        try {
            Field[] fields;
            String sb = "";
            Class<?> objClass = this.getClass();
            sb = sb + "GeoSpark Configuration:\n";
            for (Field field : fields = objClass.getDeclaredFields()) {
                String name = field.getName();
                Object value = field.get(this);
                sb = sb + name + ": " + value.toString() + "\n";
            }
            return sb;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

