/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.util.Arrays;
import java.util.Set;
import org.geotools.data.FeatureLockFactory;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryFinder;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollections;
import org.geotools.filter.FunctionFactory;
import org.geotools.resources.LazySet;
import org.geotools.styling.StyleFactory;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Function;

public final class CommonFactoryFinder
extends FactoryFinder {
    private static FactoryRegistry registry;

    private CommonFactoryFinder() {
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(CommonFactoryFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(StyleFactory.class, FilterFactory.class, FeatureLockFactory.class, FileDataStoreFactorySpi.class, Function.class, FunctionFactory.class, FeatureFactory.class, FeatureTypeFactory.class, FeatureCollections.class));
        }
        return registry;
    }

    public static StyleFactory getStyleFactory(Hints hints) throws FactoryRegistryException {
        hints = CommonFactoryFinder.mergeSystemHints(hints);
        return CommonFactoryFinder.lookup(StyleFactory.class, hints, Hints.STYLE_FACTORY);
    }

    public static StyleFactory getStyleFactory() throws FactoryRegistryException {
        return CommonFactoryFinder.getStyleFactory(null);
    }

    public static synchronized Set<StyleFactory> getStyleFactories(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints(hints);
        return new LazySet<StyleFactory>(CommonFactoryFinder.getServiceRegistry().getServiceProviders(StyleFactory.class, null, hints));
    }

    public static synchronized Set<Function> getFunctions(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints(hints);
        return new LazySet<Function>(CommonFactoryFinder.getServiceRegistry().getServiceProviders(Function.class, null, hints));
    }

    public static synchronized Set<FunctionFactory> getFunctionFactories(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints(hints);
        return new LazySet<FunctionFactory>(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FunctionFactory.class, null, hints));
    }

    public static FeatureLockFactory getFeatureLockFactory(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints(hints);
        return CommonFactoryFinder.lookup(FeatureLockFactory.class, hints, Hints.FEATURE_LOCK_FACTORY);
    }

    public static synchronized Set<FeatureLockFactory> getFeatureLockFactories(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints(hints);
        return new LazySet<FeatureLockFactory>(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FeatureLockFactory.class, null, hints));
    }

    public static synchronized Set<FileDataStoreFactorySpi> getFileDataStoreFactories(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints(hints);
        return new LazySet<FileDataStoreFactorySpi>(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FileDataStoreFactorySpi.class, null, hints));
    }

    public static FeatureFactory getFeatureFactory(Hints hints) {
        if ((hints = CommonFactoryFinder.mergeSystemHints(hints)).get(Hints.FEATURE_FACTORY) == null) {
            try {
                Class<?> lenient = Class.forName("org.geotools.feature.LenientFeatureFactoryImpl");
                hints.put(Hints.FEATURE_FACTORY, lenient);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return CommonFactoryFinder.lookup(FeatureFactory.class, hints, Hints.FEATURE_FACTORY);
    }

    public static FeatureTypeFactory getFeatureTypeFactory(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints(hints);
        return CommonFactoryFinder.lookup(FeatureTypeFactory.class, hints, Hints.FEATURE_TYPE_FACTORY);
    }

    public static FeatureCollections getFeatureCollections(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints(hints);
        return CommonFactoryFinder.lookup(FeatureCollections.class, hints, Hints.FEATURE_COLLECTIONS);
    }

    public static FeatureCollections getFeatureCollections() {
        return CommonFactoryFinder.getFeatureCollections(null);
    }

    public static synchronized Set<FeatureCollections> getFeatureCollectionsSet(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints(hints);
        return new LazySet<FeatureCollections>(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FeatureCollections.class, null, hints));
    }

    public static FilterFactory getFilterFactory(Hints hints) throws FactoryRegistryException {
        hints = CommonFactoryFinder.mergeSystemHints(hints);
        return CommonFactoryFinder.lookup(FilterFactory.class, hints, Hints.FILTER_FACTORY);
    }

    public static FilterFactory getFilterFactory() throws FactoryRegistryException {
        return CommonFactoryFinder.getFilterFactory(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T lookup(Class<T> category, Hints hints, Hints.Key key) {
        if (hints == null || key == null) {
            return null;
        }
        Object hint = hints.get(key);
        if (hint != null && category.isInstance(hint)) {
            return category.cast(hint);
        }
        Class<CommonFactoryFinder> clazz = CommonFactoryFinder.class;
        synchronized (CommonFactoryFinder.class) {
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return CommonFactoryFinder.getServiceRegistry().getServiceProvider(category, null, hints, key);
        }
    }

    public static synchronized Set<FilterFactory> getFilterFactories(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints(hints);
        return new LazySet<FilterFactory>(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FilterFactory.class, null, hints));
    }

    public static FilterFactory2 getFilterFactory2(Hints hints) throws FactoryRegistryException {
        Object h = (hints = CommonFactoryFinder.mergeSystemHints(hints)).get(Hints.FILTER_FACTORY);
        if (!(!(h instanceof Class) ? h instanceof FilterFactory2 : FilterFactory2.class.isAssignableFrom((Class)h))) {
            hints = new Hints(hints);
            hints.put(Hints.FILTER_FACTORY, FilterFactory2.class);
        }
        return (FilterFactory2)CommonFactoryFinder.getFilterFactory(hints);
    }

    public static FilterFactory2 getFilterFactory2() throws FactoryRegistryException {
        return CommonFactoryFinder.getFilterFactory2(null);
    }

    public static synchronized void scanForPlugins() {
        if (registry != null) {
            registry.scanForPlugins();
        }
    }

    public static void reset() {
        FactoryRegistry copy = registry;
        registry = null;
        if (copy != null) {
            copy.deregisterAll();
        }
    }
}

