/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import java.util.regex.Pattern;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class SimpleFeaturePropertyAccessorFactory
implements PropertyAccessorFactory {
    static PropertyAccessor ATTRIBUTE_ACCESS = new SimpleFeaturePropertyAccessor();
    static PropertyAccessor DEFAULT_GEOMETRY_ACCESS = new DefaultGeometrySimpleFeaturePropertyAccessor();
    static PropertyAccessor FID_ACCESS = new FidSimpleFeaturePropertyAccessor();
    static Pattern idPattern = Pattern.compile("@(\\w+:)?id");
    private static final String NAME_START_CHAR = ":A-Z_a-z\\u00c0-\\u00d6\\u00d8-\\u00f6\\u00f8-\\u02ff\\u0370-\\u037d\\u037f-\\u1fff\\u200c-\\u200d\\u2070-\\u218f\\u2c00-\\u2fef\\u3001-\\ud7ff\\uf900-\\ufdcf\\ufdf0-\\ufffd";
    private static final String NAME_CHAR = ":A-Z_a-z\\u00c0-\\u00d6\\u00d8-\\u00f6\\u00f8-\\u02ff\\u0370-\\u037d\\u037f-\\u1fff\\u200c-\\u200d\\u2070-\\u218f\\u2c00-\\u2fef\\u3001-\\ud7ff\\uf900-\\ufdcf\\ufdf0-\\ufffd\\-\\.0-9\\u00b7\\u0300-\\u036f\\u203f-\\u2040";
    static final Pattern propertyPattern = Pattern.compile("^(?!@)([:A-Z_a-z\\u00c0-\\u00d6\\u00d8-\\u00f6\\u00f8-\\u02ff\\u0370-\\u037d\\u037f-\\u1fff\\u200c-\\u200d\\u2070-\\u218f\\u2c00-\\u2fef\\u3001-\\ud7ff\\uf900-\\ufdcf\\ufdf0-\\ufffd][:A-Z_a-z\\u00c0-\\u00d6\\u00d8-\\u00f6\\u00f8-\\u02ff\\u0370-\\u037d\\u037f-\\u1fff\\u200c-\\u200d\\u2070-\\u218f\\u2c00-\\u2fef\\u3001-\\ud7ff\\uf900-\\ufdcf\\ufdf0-\\ufffd\\-\\.0-9\\u00b7\\u0300-\\u036f\\u203f-\\u2040]*)(\\[1])?$");

    public PropertyAccessor createPropertyAccessor(Class type, String xpath, Class target, Hints hints) {
        if (xpath == null) {
            return null;
        }
        if (!SimpleFeature.class.isAssignableFrom(type) && !SimpleFeatureType.class.isAssignableFrom(type)) {
            return null;
        }
        if ("".equals(xpath)) {
            return DEFAULT_GEOMETRY_ACCESS;
        }
        if (idPattern.matcher(xpath).matches()) {
            return FID_ACCESS;
        }
        if (propertyPattern.matcher(xpath).matches()) {
            return ATTRIBUTE_ACCESS;
        }
        return null;
    }

    static String stripPrefixIndex(String xpath) {
        int split = xpath.indexOf(":");
        if (split != -1) {
            xpath = xpath.substring(split + 1);
        }
        if (xpath.endsWith("[1]")) {
            xpath = xpath.substring(0, xpath.length() - 3);
        }
        return xpath;
    }

    static class SimpleFeaturePropertyAccessor
    implements PropertyAccessor {
        SimpleFeaturePropertyAccessor() {
        }

        public boolean canHandle(Object object, String xpath, Class target) {
            String stripped = SimpleFeaturePropertyAccessorFactory.stripPrefixIndex(xpath);
            if (object instanceof SimpleFeature) {
                SimpleFeatureType type = ((SimpleFeature)object).getType();
                return type.indexOf(xpath) >= 0 || type.indexOf(stripped) >= 0;
            }
            if (object instanceof SimpleFeatureType) {
                SimpleFeatureType type = (SimpleFeatureType)object;
                return type.indexOf(xpath) >= 0 || type.indexOf(stripped) >= 0;
            }
            return false;
        }

        public Object get(Object object, String xpath, Class target) {
            if (object instanceof SimpleFeature) {
                SimpleFeatureType type = ((SimpleFeature)object).getType();
                if (type.indexOf(xpath) >= 0) {
                    return ((SimpleFeature)object).getAttribute(xpath);
                }
                String stripped = SimpleFeaturePropertyAccessorFactory.stripPrefixIndex(xpath);
                return ((SimpleFeature)object).getAttribute(stripped);
            }
            if (object instanceof SimpleFeatureType) {
                SimpleFeatureType type = (SimpleFeatureType)object;
                if (type.indexOf(xpath) >= 0) {
                    return type.getDescriptor(xpath);
                }
                String stripped = SimpleFeaturePropertyAccessorFactory.stripPrefixIndex(xpath);
                return type.getDescriptor(stripped);
            }
            return null;
        }

        public void set(Object object, String xpath, Object value, Class target) throws IllegalAttributeException {
            xpath = SimpleFeaturePropertyAccessorFactory.stripPrefixIndex(xpath);
            if (object instanceof SimpleFeature) {
                ((SimpleFeature)object).setAttribute(xpath, value);
            }
            if (object instanceof SimpleFeatureType) {
                throw new IllegalAttributeException("feature type is immutable");
            }
        }
    }

    static class DefaultGeometrySimpleFeaturePropertyAccessor
    implements PropertyAccessor {
        DefaultGeometrySimpleFeaturePropertyAccessor() {
        }

        public boolean canHandle(Object object, String xpath, Class target) {
            if (!"".equals(xpath)) {
                return false;
            }
            return object instanceof SimpleFeature || object instanceof SimpleFeatureType;
        }

        public Object get(Object object, String xpath, Class target) {
            if (object instanceof SimpleFeature) {
                SimpleFeature f = (SimpleFeature)object;
                Object defaultGeometry = f.getDefaultGeometry();
                if (defaultGeometry == null) {
                    for (Object o : f.getAttributes()) {
                        if (!(o instanceof Geometry)) continue;
                        defaultGeometry = o;
                        break;
                    }
                }
                return defaultGeometry;
            }
            if (object instanceof SimpleFeatureType) {
                SimpleFeatureType ft = (SimpleFeatureType)object;
                GeometryDescriptor gd = ft.getGeometryDescriptor();
                if (gd == null) {
                    for (AttributeDescriptor ad : ft.getAttributeDescriptors()) {
                        if (!Geometry.class.isAssignableFrom(ad.getType().getBinding())) continue;
                        return ad;
                    }
                }
                return gd;
            }
            return null;
        }

        public void set(Object object, String xpath, Object value, Class target) throws IllegalAttributeException {
            if (object instanceof SimpleFeature) {
                ((SimpleFeature)object).setDefaultGeometry((Geometry)value);
            }
            if (object instanceof SimpleFeatureType) {
                throw new IllegalAttributeException("feature type is immutable");
            }
        }
    }

    static class FidSimpleFeaturePropertyAccessor
    implements PropertyAccessor {
        FidSimpleFeaturePropertyAccessor() {
        }

        public boolean canHandle(Object object, String xpath, Class target) {
            return object instanceof SimpleFeature && xpath.matches("@(\\w+:)?id");
        }

        public Object get(Object object, String xpath, Class target) {
            SimpleFeature feature = (SimpleFeature)object;
            return feature.getID();
        }

        public void set(Object object, String xpath, Object value, Class target) throws IllegalAttributeException {
            throw new IllegalAttributeException("feature id is immutable");
        }
    }
}

