/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.reference;

import java.util.Collection;
import java.util.GregorianCalendar;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.temporal.object.DefaultCalendarDate;
import org.geotools.temporal.object.DefaultDateAndTime;
import org.geotools.temporal.object.DefaultJulianDate;
import org.geotools.temporal.reference.DefaultTemporalCoordinateSystem;
import org.geotools.temporal.reference.DefaultTemporalReferenceSystem;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.temporal.Calendar;
import org.opengis.temporal.CalendarDate;
import org.opengis.temporal.CalendarEra;
import org.opengis.temporal.Clock;
import org.opengis.temporal.ClockTime;
import org.opengis.temporal.DateAndTime;
import org.opengis.temporal.JulianDate;

public class DefaultCalendar
extends DefaultTemporalReferenceSystem
implements Calendar {
    private Collection<CalendarEra> basis;
    private Clock timeBasis;

    public DefaultCalendar(ReferenceIdentifier name, Extent domainOfValidity) {
        super(name, domainOfValidity);
    }

    @Override
    public JulianDate dateTrans(CalendarDate calDate, ClockTime time) {
        if (calDate != null && time != null) {
            DefaultDateAndTime dateAndTime = new DefaultDateAndTime(this, calDate.getIndeterminatePosition(), calDate.getCalendarEraName(), calDate.getCalendarDate(), time.getClockTime());
            return this.dateTrans(dateAndTime);
        }
        GregorianCalendar gc = new GregorianCalendar(-4713, 1, 1);
        gc.set(0, 0);
        int julianGre = 588829;
        Number coordinateValue = 0;
        DefaultTemporalCoordinateSystem refSystem = new DefaultTemporalCoordinateSystem(new NamedIdentifier(Citations.CRS, new SimpleInternationalString("Julian calendar")), null, gc.getTime(), new SimpleInternationalString("day"));
        if (calDate != null) {
            int[] cal = calDate.getCalendarDate();
            int year = 0;
            int month = 0;
            int day = 0;
            if (cal.length > 3) {
                throw new IllegalArgumentException("The CalendarDate integer array is malformed ! see ISO 8601 format.");
            }
            year = cal[0];
            if (cal.length > 0) {
                month = cal[1];
            }
            if (cal.length > 1) {
                day = cal[2];
            }
            int julianYear = year;
            if (year < 0) {
                ++julianYear;
            }
            int julianMonth = month;
            if (month > 2) {
                ++julianMonth;
            } else {
                --julianYear;
                julianMonth += 13;
            }
            double julian = Math.floor(365.25 * (double)julianYear) + Math.floor(30.6001 * (double)julianMonth) + (double)day + 1720995.0;
            if (day + 31 * (month + 12 * year) >= 588829) {
                int ja = (int)(0.01 * (double)julianYear);
                julian += (double)(2 - ja) + 0.25 * (double)ja;
            }
            coordinateValue = Math.floor(julian);
            DefaultJulianDate response = new DefaultJulianDate(refSystem, null, coordinateValue);
            return response;
        }
        if (time != null) {
            Number[] clk = time.getClockTime();
            Number hour = 0;
            Number minute = 0;
            Number second = 0;
            if (clk.length > 3) {
                throw new IllegalArgumentException("The ClockTime Number array is malformed ! see ISO 8601 format.");
            }
            hour = clk[0];
            if (clk.length > 0) {
                minute = clk[1];
            }
            if (clk.length > 1) {
                second = clk[2];
            }
            double julian = (hour.doubleValue() - 12.0) / 24.0 + minute.doubleValue() / 1440.0 + second.doubleValue() / 86400.0;
            coordinateValue = julian;
            DefaultJulianDate response = new DefaultJulianDate(refSystem, null, coordinateValue);
            return response;
        }
        throw new IllegalArgumentException("the both CalendarDate and ClockTime cannot be null !");
    }

    public JulianDate dateTrans(DateAndTime dateAndTime) {
        GregorianCalendar gc = new GregorianCalendar(-4713, 1, 1);
        gc.set(0, 0);
        int julianGre = 588829;
        DefaultTemporalCoordinateSystem refSystem = new DefaultTemporalCoordinateSystem(new NamedIdentifier(Citations.CRS, new SimpleInternationalString("Julian calendar")), null, gc.getTime(), new SimpleInternationalString("day"));
        Number coordinateValue = 0;
        int year = 0;
        int month = 0;
        int day = 0;
        Number hour = 0;
        Number minute = 0;
        Number second = 0;
        if (dateAndTime == null) {
            throw new IllegalArgumentException("The DateAndTime cannot be null ! ");
        }
        if (dateAndTime.getCalendarDate() != null) {
            int[] cal = dateAndTime.getCalendarDate();
            if (cal.length > 3) {
                throw new IllegalArgumentException("The CalendarDate integer array is malformed ! see ISO 8601 format.");
            }
            year = cal[0];
            if (cal.length > 0) {
                month = cal[1];
            }
            if (cal.length > 1) {
                day = cal[2];
            }
            int julianYear = year;
            if (year < 0) {
                ++julianYear;
            }
            int julianMonth = month;
            if (month > 2) {
                ++julianMonth;
            } else {
                --julianYear;
                julianMonth += 13;
            }
            double julian = Math.floor(365.25 * (double)julianYear) + Math.floor(30.6001 * (double)julianMonth) + (double)day + 1720995.0;
            if (day + 31 * (month + 12 * year) >= 588829) {
                int ja = (int)(0.01 * (double)julianYear);
                julian += (double)(2 - ja) + 0.25 * (double)ja;
            }
            coordinateValue = Math.floor(julian);
        }
        if (dateAndTime.getClockTime() != null) {
            Number[] clk = dateAndTime.getClockTime();
            if (clk.length > 3) {
                throw new IllegalArgumentException("The ClockTime Number array is malformed ! see ISO 8601 format.");
            }
            hour = clk[0];
            if (clk.length > 0) {
                minute = clk[1];
            }
            if (clk.length > 1) {
                second = clk[2];
            }
            double julian = (hour.doubleValue() - 12.0) / 24.0 + minute.doubleValue() / 1440.0 + second.doubleValue() / 86400.0;
            coordinateValue = ((Number)coordinateValue).doubleValue() + julian;
        }
        DefaultJulianDate response = new DefaultJulianDate(refSystem, null, coordinateValue);
        return response;
    }

    @Override
    public CalendarDate julTrans(JulianDate jdt) {
        if (jdt == null) {
            return null;
        }
        DefaultCalendarDate response = null;
        int JGREG = 588829;
        int ja = jdt.getCoordinateValue().intValue();
        if (ja >= JGREG) {
            int jalpha = (int)(((double)(ja - 1867216) - 0.25) / 36524.25);
            ja = ja + 1 + jalpha - jalpha / 4;
        }
        int jb = ja + 1524;
        int jc = (int)(6680.0 + ((double)(jb - 2439870) - 122.1) / 365.25);
        int jd = 365 * jc + jc / 4;
        int je = (int)((double)(jb - jd) / 30.6001);
        int day = jb - jd - (int)(30.6001 * (double)je);
        int month = je - 1;
        if (month > 12) {
            month -= 12;
        }
        int year = jc - 4715;
        if (month > 2) {
            --year;
        }
        if (year <= 0) {
            // empty if block
        }
        int[] calendarDate = new int[]{--year, month, day};
        response = new DefaultCalendarDate(this, null, null, calendarDate);
        return response;
    }

    @Override
    public Collection<CalendarEra> getBasis() {
        return this.basis;
    }

    @Override
    public Clock getClock() {
        return this.timeBasis;
    }

    public void setBasis(Collection<CalendarEra> basis) {
        this.basis = basis;
    }

    public void setClock(Clock clock) {
        this.timeBasis = clock;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultCalendar && super.equals(object)) {
            DefaultCalendar that = (DefaultCalendar)object;
            return Utilities.equals(this.basis, that.basis) && Utilities.equals(this.timeBasis, that.timeBasis);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 37 * hash + (this.timeBasis != null ? this.timeBasis.hashCode() : 0);
        hash = 37 * hash + (this.basis != null ? this.basis.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("Calendar:").append('\n');
        if (this.timeBasis != null) {
            s.append("clock:").append(this.timeBasis).append('\n');
        }
        if (this.basis != null) {
            s.append("basis:").append(this.basis).append('\n');
        }
        return super.toString().concat("\n").concat(s.toString());
    }
}

