/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPOutputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.rowio.RowOutputTextLog;
import org.hsqldb.scriptio.ScriptWriterBase;

public class ScriptWriterText
extends ScriptWriterBase {
    RowOutputInterface rowOut;
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static byte[] BYTES_LINE_SEP;
    static byte[] BYTES_COMMIT;
    static byte[] BYTES_INSERT_INTO;
    static byte[] BYTES_VALUES;
    static byte[] BYTES_TERM;
    static byte[] BYTES_DELETE_FROM;
    static byte[] BYTES_WHERE;
    static byte[] BYTES_SEQUENCE;
    static byte[] BYTES_SEQUENCE_MID;
    static byte[] BYTES_C_ID_INIT;
    static byte[] BYTES_C_ID_TERM;
    static byte[] BYTES_SCHEMA;

    public ScriptWriterText(Database database, OutputStream outputStream, FileAccess.FileSync fileSync, boolean bl) {
        super(database, outputStream, fileSync, bl);
    }

    public ScriptWriterText(Database database, String string, boolean bl, boolean bl2, boolean bl3) {
        super(database, string, bl, bl2, bl3);
    }

    public ScriptWriterText(Database database, String string, boolean bl, boolean bl2) {
        super(database, string, bl, true, false);
        if (bl2) {
            this.isCompressed = true;
            try {
                this.fileStreamOut = new GZIPOutputStream(this.fileStreamOut);
            }
            catch (IOException iOException) {
                throw Error.error(iOException, 452, 26, new Object[]{iOException.toString(), this.outFile});
            }
        }
    }

    @Override
    protected void initBuffers() {
        this.rowOut = new RowOutputTextLog();
    }

    @Override
    protected void writeDataTerm() throws IOException {
    }

    @Override
    protected void writeSessionIdAndSchema(Session session) throws IOException {
        if (session == null) {
            return;
        }
        if (session != this.currentSession) {
            this.rowOut.reset();
            this.rowOut.writeBytes(BYTES_C_ID_INIT);
            this.rowOut.writeLong(session.getId());
            this.rowOut.writeBytes(BYTES_C_ID_TERM);
            this.currentSession = session;
            this.writeRowOutToFile();
        }
        if (this.schemaToLog != session.loggedSchema) {
            this.rowOut.reset();
            this.writeSchemaStatement(this.schemaToLog);
            session.loggedSchema = this.schemaToLog;
            this.writeRowOutToFile();
        }
    }

    private void writeSchemaStatement(HsqlNameManager.HsqlName hsqlName) {
        this.rowOut.writeBytes(BYTES_SCHEMA);
        this.rowOut.writeString(hsqlName.statementName);
        this.rowOut.writeBytes(BYTES_LINE_SEP);
    }

    @Override
    public void writeLogStatement(Session session, String string) throws IOException {
        if (session != null) {
            this.schemaToLog = session.currentSchema;
            this.writeSessionIdAndSchema(session);
        }
        this.rowOut.reset();
        this.rowOut.writeString(string);
        this.rowOut.writeBytes(BYTES_LINE_SEP);
        this.writeRowOutToFile();
        this.needsSync = true;
    }

    @Override
    public void writeRow(Session session, Row row, Table table) throws IOException {
        this.schemaToLog = table.getName().schema;
        this.writeSessionIdAndSchema(session);
        this.rowOut.reset();
        this.rowOut.setMode(0);
        this.rowOut.writeBytes(BYTES_INSERT_INTO);
        this.rowOut.writeString(table.getName().statementName);
        this.rowOut.writeBytes(BYTES_VALUES);
        this.rowOut.writeData(row, table.getColumnTypes());
        this.rowOut.writeBytes(BYTES_TERM);
        this.rowOut.writeBytes(BYTES_LINE_SEP);
        this.writeRowOutToFile();
    }

    @Override
    public void writeTableInit(Table table) throws IOException {
        if (table.isEmpty(this.currentSession)) {
            return;
        }
        if (!this.includeTableInit && this.schemaToLog == this.currentSession.loggedSchema) {
            return;
        }
        this.rowOut.reset();
        this.writeSchemaStatement(table.getName().schema);
        this.writeRowOutToFile();
        this.currentSession.loggedSchema = this.schemaToLog;
    }

    @Override
    public void writeOtherStatement(Session session, String string) throws IOException {
        this.writeLogStatement(session, string);
        if (this.writeDelay == 0) {
            this.sync();
        }
    }

    @Override
    public void writeInsertStatement(Session session, Row row, Table table) throws IOException {
        this.schemaToLog = table.getName().schema;
        this.writeRow(session, row, table);
    }

    @Override
    public void writeDeleteStatement(Session session, Table table, Object[] objectArray) throws IOException {
        this.schemaToLog = table.getName().schema;
        this.writeSessionIdAndSchema(session);
        this.rowOut.reset();
        this.rowOut.setMode(1);
        this.rowOut.writeBytes(BYTES_DELETE_FROM);
        this.rowOut.writeString(table.getName().statementName);
        this.rowOut.writeBytes(BYTES_WHERE);
        this.rowOut.writeData(table.getColumnCount(), table.getColumnTypes(), objectArray, table.columnList, table.getPrimaryKey());
        this.rowOut.writeBytes(BYTES_LINE_SEP);
        this.writeRowOutToFile();
    }

    @Override
    public void writeSequenceStatement(Session session, NumberSequence numberSequence) throws IOException {
        this.schemaToLog = numberSequence.getName().schema;
        this.writeSessionIdAndSchema(session);
        this.rowOut.reset();
        this.rowOut.writeBytes(BYTES_SEQUENCE);
        this.rowOut.writeString(numberSequence.getSchemaName().statementName);
        this.rowOut.writeByte(46);
        this.rowOut.writeString(numberSequence.getName().statementName);
        this.rowOut.writeBytes(BYTES_SEQUENCE_MID);
        this.rowOut.writeLong(numberSequence.peek());
        this.rowOut.writeBytes(BYTES_LINE_SEP);
        this.writeRowOutToFile();
        this.needsSync = true;
    }

    @Override
    public void writeCommitStatement(Session session) throws IOException {
        this.writeSessionIdAndSchema(session);
        this.rowOut.reset();
        this.rowOut.writeBytes(BYTES_COMMIT);
        this.rowOut.writeBytes(BYTES_LINE_SEP);
        this.writeRowOutToFile();
        this.needsSync = true;
        if (this.writeDelay == 0) {
            this.sync();
        }
    }

    @Override
    protected void finishStream() throws IOException {
        if (this.isCompressed) {
            ((GZIPOutputStream)this.fileStreamOut).finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeRowOutToFile() throws IOException {
        if (this.fileStreamOut == null) {
            return;
        }
        OutputStream outputStream = this.fileStreamOut;
        synchronized (outputStream) {
            this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
            this.byteCount += (long)this.rowOut.size();
            ++this.lineCount;
        }
    }

    static {
        String string = System.getProperty("line.separator", "\n");
        try {
            BYTES_LINE_SEP = string.getBytes();
            BYTES_COMMIT = "COMMIT".getBytes(ISO_8859_1);
            BYTES_INSERT_INTO = "INSERT INTO ".getBytes(ISO_8859_1);
            BYTES_VALUES = " VALUES(".getBytes(ISO_8859_1);
            BYTES_TERM = ")".getBytes(ISO_8859_1);
            BYTES_DELETE_FROM = "DELETE FROM ".getBytes(ISO_8859_1);
            BYTES_WHERE = " WHERE ".getBytes(ISO_8859_1);
            BYTES_SEQUENCE = "ALTER SEQUENCE ".getBytes(ISO_8859_1);
            BYTES_SEQUENCE_MID = " RESTART WITH ".getBytes(ISO_8859_1);
            BYTES_C_ID_INIT = "/*C".getBytes(ISO_8859_1);
            BYTES_C_ID_TERM = "*/".getBytes(ISO_8859_1);
            BYTES_SCHEMA = "SET SCHEMA ".getBytes(ISO_8859_1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Error.runtimeError(201, "ScriptWriterText");
        }
        if (BYTES_LINE_SEP[0] != 10 && BYTES_LINE_SEP[0] != 13) {
            BYTES_LINE_SEP = new byte[]{10};
        }
    }
}

