/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.geometry.PrimitiveArrays;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;

public class BufferUtils {
    public static PrimitiveArrays.Bytes createBytes(final ByteBuffer buffer) {
        Preconditions.checkState((buffer.position() == 0 ? 1 : 0) != 0);
        return new PrimitiveArrays.Bytes(){

            @Override
            public byte get(long position) {
                return buffer.get(Ints.checkedCast((long)position));
            }

            @Override
            public long length() {
                return buffer.limit();
            }
        };
    }

    private BufferUtils() {
    }
}

