/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.EncodedInts;
import com.google.common.geometry.InputStreams;
import java.io.IOException;
import java.io.InputStream;

public final class LittleEndianInput {
    private final InputStream input;

    public LittleEndianInput(InputStream input) {
        this.input = input;
    }

    public byte readByte() throws IOException {
        return InputStreams.readByte(this.input);
    }

    public byte[] readBytes(int size) throws IOException {
        if (size < 0) {
            throw new IOException("Attempt to read " + size + " bytes");
        }
        byte[] result = new byte[size];
        int numRead = this.input.read(result);
        if (numRead < size) {
            throw new IOException("EOF");
        }
        return result;
    }

    public int readInt() throws IOException {
        return this.readByte() & 0xFF | (this.readByte() & 0xFF) << 8 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 24;
    }

    public long readLong() throws IOException {
        return LittleEndianInput.readLong(this.input);
    }

    public static long readLong(InputStream input) throws IOException {
        return (long)InputStreams.readByte(input) & 0xFFL | ((long)InputStreams.readByte(input) & 0xFFL) << 8 | ((long)InputStreams.readByte(input) & 0xFFL) << 16 | ((long)InputStreams.readByte(input) & 0xFFL) << 24 | ((long)InputStreams.readByte(input) & 0xFFL) << 32 | ((long)InputStreams.readByte(input) & 0xFFL) << 40 | ((long)InputStreams.readByte(input) & 0xFFL) << 48 | ((long)InputStreams.readByte(input) & 0xFFL) << 56;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public int readVarint32() throws IOException {
        return (int)this.readVarint64();
    }

    public long readVarint64() throws IOException {
        return EncodedInts.readVarint64(this.input);
    }

    public void close() throws IOException {
        this.input.close();
    }
}

