/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.primitives.ImmutableLongArray;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsType;

@JsType
public final class PrimitiveArrays {
    private PrimitiveArrays() {
    }

    @JsType
    public static class Cursor {
        public long position;
        public long limit;

        Cursor(long position, long limit) {
            Preconditions.checkArgument((position >= 0L ? 1 : 0) != 0);
            Preconditions.checkArgument((position <= limit ? 1 : 0) != 0);
            this.position = position;
            this.limit = limit;
        }

        public long remaining() {
            return this.limit - this.position;
        }

        public Cursor seek(long position) {
            Preconditions.checkArgument((position >= 0L && position < this.limit ? 1 : 0) != 0);
            this.position = position;
            return this;
        }
    }

    @JsType
    public static interface Longs {
        public long get(int var1);

        public int length();

        @JsIgnore
        public static Longs fromImmutableLongArray(final ImmutableLongArray immutableLongArray) {
            return new Longs(){

                @Override
                public long get(int position) {
                    return immutableLongArray.get(position);
                }

                @Override
                public int length() {
                    return immutableLongArray.length();
                }
            };
        }

        default public int[] toIntArray() {
            int[] result = new int[this.length()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Ints.checkedCast((long)this.get(i));
            }
            return result;
        }
    }

    @JsType
    public static interface Bytes {
        public byte get(long var1);

        public long length();

        default public Cursor cursor(long position, long limit) {
            Preconditions.checkArgument((position <= limit && position <= this.length() ? 1 : 0) != 0);
            return new Cursor(position, limit);
        }

        default public boolean isEqualTo(Bytes other) {
            if (other == null) {
                return false;
            }
            long length = this.length();
            if (other.length() != length) {
                return false;
            }
            for (long i = 0L; i < length; ++i) {
                if (other.get(i) == this.get(i)) continue;
                return false;
            }
            return true;
        }

        @JsIgnore
        default public Cursor cursor(long position) {
            return this.cursor(position, this.length());
        }

        @JsIgnore
        default public Cursor cursor() {
            return this.cursor(0L);
        }

        public static Bytes fromByteArray(final byte[] bytes) {
            return new Bytes(){

                @Override
                public byte get(long position) {
                    return bytes[Ints.checkedCast((long)position)];
                }

                @Override
                public long length() {
                    return bytes.length;
                }
            };
        }

        @JsIgnore
        default public InputStream toInputStream(final long offset) {
            Preconditions.checkArgument((offset >= 0L && offset <= this.length() ? 1 : 0) != 0);
            return new InputStream(){
                long position;
                {
                    this.position = offset;
                }

                @Override
                public int read() {
                    if (this.position == this.length()) {
                        return -1;
                    }
                    return this.get(this.position++) & 0xFF;
                }
            };
        }

        @JsIgnore
        default public InputStream toInputStream(final Cursor cursor) {
            Preconditions.checkArgument((cursor.position >= 0L && cursor.position <= cursor.limit ? 1 : 0) != 0);
            Preconditions.checkArgument((cursor.remaining() <= this.length() ? 1 : 0) != 0);
            return new InputStream(){

                @Override
                public int read() {
                    if (cursor.position == cursor.limit) {
                        return -1;
                    }
                    return this.get(cursor.position++) & 0xFF;
                }
            };
        }

        @JsIgnore
        default public InputStream toInputStream() {
            return this.toInputStream(0L);
        }

        @JsIgnore
        default public void writeTo(OutputStream output) throws IOException {
            for (long i = 0L; i < this.length(); ++i) {
                output.write(this.get(i));
            }
        }

        default public byte readByte(Cursor cursor) {
            return this.get(cursor.position++);
        }

        default public long readVarint64(Cursor cursor) {
            long result = 0L;
            for (int shift = 0; shift < 64; shift += 7) {
                byte b = this.get(cursor.position++);
                result |= (long)(b & 0x7F) << shift;
                if ((b & 0x80) != 0) continue;
                return result;
            }
            throw new IllegalArgumentException("Malformed varint.");
        }

        default public int readVarint32(Cursor cursor) {
            return Ints.checkedCast((long)this.readVarint64(cursor));
        }

        default public long readUintWithLength(Cursor cursor, int numBytes) {
            long result = this.readUintWithLength(cursor.position, numBytes);
            cursor.position += (long)numBytes;
            return result;
        }

        @JsIgnore
        default public long readUintWithLength(long position, int numBytes) {
            long x = 0L;
            for (int i = 0; i < numBytes; ++i) {
                x += ((long)this.get(position++) & 0xFFL) << 8 * i;
            }
            return x;
        }

        default public long readLittleEndianLong(Cursor cursor) {
            return this.readUintWithLength(cursor, 8);
        }

        default public double readLittleEndianDouble(long position) {
            return Double.longBitsToDouble(this.readUintWithLength(position, 8));
        }
    }
}

