/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.geometry.Matrix;
import com.google.common.geometry.Platform;
import com.google.common.geometry.R2Vector;
import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Predicates;
import com.google.common.geometry.S2RobustCrossProd;
import com.google.errorprone.annotations.Immutable;

public final class S2 {
    public static final double M_PI = Math.PI;
    public static final double M_1_PI = 0.3183098861837907;
    public static final double M_PI_2 = 1.5707963267948966;
    public static final double M_PI_4 = 0.7853981633974483;
    public static final double M_SQRT1_2 = 1.0 / Math.sqrt(2.0);
    public static final double M_SQRT2 = Math.sqrt(2.0);
    public static final double M_SQRT3 = Math.sqrt(3.0);
    public static final double M_E = Math.E;
    public static final double DBL_EPSILON = 2.220446049250313E-16;
    public static final double DBL_ERROR = (double)1.110223E-16f;
    public static final S1Angle ROBUST_CROSS_PROD_ERROR = S1Angle.radians(8.881784197001252E-16);
    public static final S1Angle EXACT_CROSS_PROD_ERROR = S1Angle.radians(1.110223E-16f);
    public static final double MIN_NORM = 32.0 * M_SQRT3 * (double)1.110223E-16f / (ROBUST_CROSS_PROD_ERROR.radians() / (double)1.110223E-16f - (1.0 + 2.0 * M_SQRT3));
    private static final S2Point ORIGIN = new S2Point(-0.00999946643502502, 0.002592454260932412, 0.999946643502502);
    public static final int SWAP_MASK = 1;
    public static final int INVERT_MASK = 2;
    private static final int[] posToOrientation = new int[]{1, 0, 0, 3};
    private static final int[][] posToIj = new int[][]{{0, 1, 3, 2}, {0, 2, 3, 1}, {3, 2, 0, 1}, {3, 1, 0, 2}};
    private static final int[][] IJ_TO_POS = new int[][]{{0, 1, 3, 2}, {0, 3, 1, 2}, {2, 3, 1, 0}, {2, 1, 3, 0}};
    static boolean skipAssertions = false;
    private static final S2Point[] ORTHO_BASES = new S2Point[]{new S2Point(1.0, 0.0053, 0.00457), new S2Point(0.012, 1.0, 0.00457), new S2Point(0.012, 0.0053, 1.0)};

    public static int posToOrientation(int position) {
        Preconditions.checkArgument((0 <= position && position < 4 ? 1 : 0) != 0);
        return posToOrientation[position];
    }

    public static int posToIJ(int orientation, int position) {
        return posToIj[orientation][position];
    }

    public static final int ijToPos(int orientation, int ijIndex) {
        return IJ_TO_POS[orientation][ijIndex];
    }

    public static S2Point origin() {
        return ORIGIN;
    }

    public static boolean isUnitLength(S2Point p) {
        return Math.abs(p.norm2() - 1.0) <= (double)1.110223E-15f;
    }

    public static S2Point ortho(S2Point a) {
        int k = a.largestAbsComponent() - 1;
        if (k < 0) {
            k = 2;
        }
        return a.crossProd(ORTHO_BASES[k]).normalize();
    }

    public static S2Point refDir(S2Point a) {
        return S2.ortho(a);
    }

    public static double area(S2Point a, S2Point b, S2Point c) {
        double sc;
        double sb;
        double sa = S2.stableAngle(b, c);
        double s = 0.5 * (sa + (sb = S2.stableAngle(c, a)) + (sc = S2.stableAngle(a, b)));
        if (s >= 3.0E-4) {
            double area;
            double s2 = s * s;
            double dmin = s - Math.max(sa, Math.max(sb, sc));
            if (dmin < 0.01 * s * s2 * s2 && dmin < s * (0.1 * ((area = S2.girardArea(a, b, c)) + 5.0E-15))) {
                return area;
            }
        }
        return 4.0 * Math.atan(Math.sqrt(Math.max(0.0, Math.tan(0.5 * s) * Math.tan(0.5 * (s - sa)) * Math.tan(0.5 * (s - sb)) * Math.tan(0.5 * (s - sc)))));
    }

    public static double girardArea(S2Point a, S2Point b, S2Point c) {
        S2Point ab = S2RobustCrossProd.robustCrossProd(a, b);
        S2Point bc = S2RobustCrossProd.robustCrossProd(b, c);
        S2Point ac = S2RobustCrossProd.robustCrossProd(a, c);
        return Math.max(0.0, ab.angle(ac) - ab.angle(bc) + bc.angle(ac));
    }

    public static double signedArea(S2Point a, S2Point b, S2Point c) {
        return (double)S2Predicates.sign(a, b, c) * S2.area(a, b, c);
    }

    public static S2Point planarCentroid(S2Point a, S2Point b, S2Point c) {
        return new S2Point((a.x + b.x + c.x) / 3.0, (a.y + b.y + c.y) / 3.0, (a.z + b.z + c.z) / 3.0);
    }

    public static S2Point trueCentroid(S2Point a, S2Point b) {
        S2Point vDiff = a.sub(b);
        S2Point vSum = a.add(b);
        double sin2 = vDiff.norm2();
        double cos2 = vSum.norm2();
        if (cos2 == 0.0) {
            return S2Point.ORIGIN;
        }
        return vSum.mul(Math.sqrt(sin2 / cos2));
    }

    public static S2Point trueCentroid(S2Point a, S2Point b, S2Point c) {
        double aAngle = b.angle(c);
        double bAngle = c.angle(a);
        double cAngle = a.angle(b);
        double ra = aAngle == 0.0 ? 1.0 : aAngle / Math.sin(aAngle);
        double rb = bAngle == 0.0 ? 1.0 : bAngle / Math.sin(bAngle);
        double rc = cAngle == 0.0 ? 1.0 : cAngle / Math.sin(cAngle);
        S2Point x = new S2Point(a.x, b.x - a.x, c.x - a.x);
        S2Point y = new S2Point(a.y, b.y - a.y, c.y - a.y);
        S2Point z = new S2Point(a.z, b.z - a.z, c.z - a.z);
        S2Point r = new S2Point(ra, rb - ra, rc - ra);
        return new S2Point(0.5 * S2Point.scalarTripleProduct(r, y, z), 0.5 * S2Point.scalarTripleProduct(r, z, x), 0.5 * S2Point.scalarTripleProduct(r, x, y));
    }

    public static int planarCCW(R2Vector a, R2Vector b) {
        double db;
        double sab = a.dotProd(b) > 0.0 ? -1.0 : 1.0;
        R2Vector vab = R2Vector.add(a, R2Vector.mul(b, sab));
        double da = a.norm2();
        double sign = da < (db = b.norm2()) || da == db && a.lessThan(b) ? a.crossProd(vab) * sab : vab.crossProd(b);
        if (sign > 0.0) {
            return 1;
        }
        if (sign < 0.0) {
            return -1;
        }
        return 0;
    }

    public static int planarOrderedCCW(R2Vector a, R2Vector b, R2Vector c) {
        int sum = 0;
        sum += S2.planarCCW(a, b);
        sum += S2.planarCCW(b, c);
        if ((sum += S2.planarCCW(c, a)) > 0) {
            return 1;
        }
        if (sum < 0) {
            return -1;
        }
        return 0;
    }

    public static double angle(S2Point a, S2Point b, S2Point c) {
        return S2RobustCrossProd.robustCrossProd(a, b).angle(S2RobustCrossProd.robustCrossProd(c, b));
    }

    public static double turnAngle(S2Point a, S2Point b, S2Point c) {
        double angle = S2RobustCrossProd.robustCrossProd(a, b).angle(S2RobustCrossProd.robustCrossProd(b, c));
        return S2Predicates.sign(a, b, c) > 0 ? angle : -angle;
    }

    public static double stableAngle(S2Point a, S2Point b) {
        return 2.0 * Math.atan2(a.sub(b).norm(), a.add(b).norm());
    }

    public static double getTurningAngleMaxError(int numVertices) {
        double maxErrorPerVertex = 2.1604940059205547E-15;
        return 2.1604940059205547E-15 * (double)numVertices;
    }

    public static Matrix getFrame(S2Point p0) {
        S2Point p1 = S2.ortho(p0);
        S2Point p2 = p1.crossProd(p0).normalize();
        return Matrix.fromCols(p2, p1, p0);
    }

    static S2Point rotate(S2Point p, Matrix r) {
        Matrix rotated = r.mult(new Matrix(1, p.x, p.y, p.z));
        return new S2Point(rotated.get(0, 0), rotated.get(1, 0), rotated.get(2, 0)).normalize();
    }

    static S2Point toFrame(Matrix frame, S2Point p) {
        return frame.transpose().mult(Matrix.fromCols(p)).getCol(0);
    }

    static S2Point fromFrame(Matrix frame, S2Point q) {
        return frame.mult(Matrix.fromCols(q)).getCol(0);
    }

    public static boolean approxEquals(S2Point a, S2Point b, double maxErrorRadians) {
        return a.angle(b) <= maxErrorRadians;
    }

    public static boolean approxEquals(S2Point a, S2Point b) {
        return S2.approxEquals(a, b, 1.0E-15);
    }

    public static boolean approxEquals(double a, double b, double maxError) {
        return Math.abs(a - b) <= maxError;
    }

    public static boolean approxEquals(double a, double b) {
        return S2.approxEquals(a, b, 1.0E-15);
    }

    private S2() {
    }

    @Immutable
    public static final class Metric {
        private final double deriv;
        private final int dim;

        public Metric(int dim, double deriv) {
            this.deriv = deriv;
            this.dim = dim;
        }

        public double deriv() {
            return this.deriv;
        }

        public double getValue(int level) {
            return Math.scalb(this.deriv, -this.dim * level);
        }

        public int getClosestLevel(double value) {
            return this.getMinLevel((this.dim == 1 ? M_SQRT2 : 2.0) * value);
        }

        public int getMinLevel(double value) {
            if (value <= 0.0) {
                return 30;
            }
            int exponent = Platform.getExponent(value / this.deriv);
            int level = Math.max(0, Math.min(30, -(exponent >> this.dim - 1)));
            return level;
        }

        public int getMaxLevel(double value) {
            if (value <= 0.0) {
                return 30;
            }
            int exponent = Platform.getExponent(this.deriv / value);
            int level = Math.max(0, Math.min(30, exponent >> this.dim - 1));
            return level;
        }
    }
}

