/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.geometry.Platform;
import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S2;
import com.google.common.geometry.S2Builder;
import com.google.common.geometry.S2BuilderGraph;
import com.google.common.geometry.S2BuilderLayer;
import com.google.common.geometry.S2BuilderSnapFunctions;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2ContainsPointQuery;
import com.google.common.geometry.S2CrossingEdgesQuery;
import com.google.common.geometry.S2EdgeUtil;
import com.google.common.geometry.S2Error;
import com.google.common.geometry.S2Iterator;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Predicates;
import com.google.common.geometry.S2Shape;
import com.google.common.geometry.S2ShapeIndex;
import com.google.common.geometry.S2ShapeIndexMeasures;
import com.google.common.geometry.S2ShapeUtil;
import com.google.common.geometry.primitives.IdSetLexicon;
import com.google.common.geometry.primitives.IntPairVector;
import com.google.common.geometry.primitives.IntVector;
import com.google.common.geometry.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class S2BooleanOperation {
    private static final byte ALL_FACES_MASK = 63;
    private final Options options;
    private final OpType opType;
    private final S2ShapeIndex[] regions = new S2ShapeIndex[2];
    private final List<S2BuilderLayer> layers;
    private boolean resultEmpty;
    private static final int SET_INSIDE = -1;
    private static final int SET_INVERT_B = -2;
    private static final int SET_REVERSE_A = -3;

    private S2BooleanOperation(OpType opType, List<S2BuilderLayer> layers, Options options) {
        this.options = options;
        this.opType = opType;
        this.layers = layers;
    }

    public OpType opType() {
        return this.opType;
    }

    public Options options() {
        return this.options;
    }

    public boolean build(S2ShapeIndex a, S2ShapeIndex b, S2Error error) {
        this.regions[0] = a;
        this.regions[1] = b;
        Impl impl = new Impl(this);
        return impl.build(error);
    }

    public static boolean isEmpty(OpType opType, S2ShapeIndex a, S2ShapeIndex b, Options options) {
        S2BooleanOperation op = new S2BooleanOperation(opType, (List<S2BuilderLayer>)ImmutableList.of(), options);
        S2Error error = new S2Error();
        boolean ok = op.build(a, b, error);
        assert (ok);
        return op.resultEmpty;
    }

    public static boolean isEmpty(OpType opType, S2ShapeIndex a, S2ShapeIndex b) {
        return S2BooleanOperation.isEmpty(opType, a, b, Options.DEFAULT);
    }

    public static boolean intersects(S2ShapeIndex a, S2ShapeIndex b, Options options) {
        return !S2BooleanOperation.isEmpty(OpType.INTERSECTION, b, a, options);
    }

    public static boolean intersects(S2ShapeIndex a, S2ShapeIndex b) {
        return !S2BooleanOperation.isEmpty(OpType.INTERSECTION, b, a);
    }

    public static boolean contains(S2ShapeIndex a, S2ShapeIndex b, Options options) {
        return S2BooleanOperation.isEmpty(OpType.DIFFERENCE, b, a, options);
    }

    public static boolean contains(S2ShapeIndex a, S2ShapeIndex b) {
        return S2BooleanOperation.isEmpty(OpType.DIFFERENCE, b, a);
    }

    public static boolean equals(S2ShapeIndex a, S2ShapeIndex b, Options options) {
        return S2BooleanOperation.isEmpty(OpType.SYMMETRIC_DIFFERENCE, b, a, options);
    }

    public static boolean equals(S2ShapeIndex a, S2ShapeIndex b) {
        return S2BooleanOperation.isEmpty(OpType.SYMMETRIC_DIFFERENCE, b, a);
    }

    private static IntVector getInputEdgeChainOrder(S2BuilderGraph g, Ints.IntList inputEdgeIds) {
        Preconditions.checkState((g.options().edgeType() == S2Builder.EdgeType.DIRECTED ? 1 : 0) != 0);
        Preconditions.checkState((g.options().duplicateEdges() == S2Builder.GraphOptions.DuplicateEdges.KEEP ? 1 : 0) != 0);
        Preconditions.checkState((g.options().siblingPairs() == S2Builder.GraphOptions.SiblingPairs.KEEP ? 1 : 0) != 0);
        IntVector order = g.getInputEdgeOrder(inputEdgeIds);
        IntPairVector vmap = new IntPairVector();
        int[] indegree = new int[g.numVertices()];
        int begin = 0;
        while (begin < order.size()) {
            int end;
            int inputEdgeId = inputEdgeIds.get(order.get(begin));
            for (end = begin; end < order.size() && inputEdgeIds.get(order.get(end)) == inputEdgeId; ++end) {
            }
            if (end - begin != 1) {
                int i;
                for (int i2 = begin; i2 < end; ++i2) {
                    int edgeId = order.get(i2);
                    vmap.add(g.edgeSrcId(edgeId), edgeId);
                    int n = g.edgeDstId(edgeId);
                    indegree[n] = indegree[n] + 1;
                }
                vmap.sort();
                int nextEdgeId = g.numEdges();
                for (i = begin; i < end; ++i) {
                    int edgeId = order.get(i);
                    if (indegree[g.edgeSrcId(edgeId)] != 0) continue;
                    nextEdgeId = edgeId;
                }
                i = begin;
                while (true) {
                    order.set(i, nextEdgeId);
                    int vertexId = g.edgeDstId(nextEdgeId);
                    indegree[vertexId] = 0;
                    if (++i == end) break;
                    int outIndex = vmap.lowerBound(vertexId, 0);
                    Preconditions.checkState((vertexId == vmap.getFirst(outIndex) ? 1 : 0) != 0);
                    nextEdgeId = vmap.getSecond(outIndex);
                }
                vmap.clear();
            }
            begin = end;
        }
        return order;
    }

    public static boolean edgeIsPoint(S2Shape.MutableEdge e) {
        return e.getStart().equalsPoint(e.getEnd());
    }

    public static boolean edgeEqualsPoint(S2Shape.MutableEdge e, S2Point point) {
        return point.equalsPoint(e.getStart()) && point.equalsPoint(e.getEnd());
    }

    private static class CrossingProcessor {
        private final PolygonModel polygonModel;
        private final PolylineModel polylineModel;
        private final boolean polylineLoopsHaveBoundaries;
        private final S2Builder builder;
        private final IntVector inputDimensions;
        private final InputEdgeCrossings inputCrossings;
        private int aRegionId;
        private int bRegionId;
        private boolean invertA;
        private boolean invertB;
        private boolean invertResult;
        private boolean isUnion;
        private S2Shape aShape;
        private int aDimension;
        private int chainId;
        private int chainStart;
        private int chainLimit;
        private final SourceEdgeCrossings sourceEdgeCrossings = new SourceEdgeCrossings();
        private final List<SourceEdgeCrossing> pendingSourceEdgeCrossings = new ArrayList<SourceEdgeCrossing>();
        private final SourceIdMap sourceIdMap = new SourceIdMap();
        private final Map<ShapeEdgeId, Boolean> isDegenerateHole = new HashMap<ShapeEdgeId, Boolean>();
        private boolean inside;
        private boolean prevInside;
        private int v0EmittedMaxEdgeId;
        private boolean chainV0Emitted;
        private final S2Shape.MutableEdge edgeA = new S2Shape.MutableEdge();

        public CrossingProcessor(PolygonModel polygonModel, PolylineModel polylineModel, boolean polylineLoopsHaveBoundaries, S2Builder builder, IntVector inputDimensions, InputEdgeCrossings inputCrossings) {
            this.polygonModel = polygonModel;
            this.polylineModel = polylineModel;
            this.polylineLoopsHaveBoundaries = polylineLoopsHaveBoundaries;
            this.builder = builder;
            this.inputDimensions = inputDimensions;
            this.inputCrossings = inputCrossings;
            this.prevInside = false;
        }

        public void startBoundary(int aRegionId, boolean invertA, boolean invertB, boolean invertResult) {
            this.aRegionId = aRegionId;
            this.bRegionId = 1 - aRegionId;
            this.invertA = invertA;
            this.invertB = invertB;
            this.invertResult = invertResult;
            this.isUnion = invertB && invertResult;
            this.setClippingState(-3, invertA != invertResult);
            this.setClippingState(-2, invertB);
        }

        public void startShape(S2Shape aShape) {
            this.aShape = aShape;
            this.aDimension = aShape.dimension();
        }

        public void startChain(int chainId, S2Shape shape, boolean inside) {
            this.chainId = chainId;
            this.chainStart = shape.getChainStart(chainId);
            this.chainLimit = this.chainStart + shape.getChainLength(chainId);
            this.inside = inside;
            this.v0EmittedMaxEdgeId = this.chainStart - 1;
            this.chainV0Emitted = false;
        }

        public boolean processEdge(ShapeEdgeId aId, CrossingIterator it) {
            this.aShape.getChainEdge(this.chainId, aId.edgeId - this.chainStart, this.edgeA);
            if (this.aDimension == 0) {
                return this.processEdge0(aId, this.edgeA, it);
            }
            if (this.aDimension == 1) {
                return this.processEdge1(aId, this.edgeA, it);
            }
            assert (this.aDimension == 2);
            return this.processEdge2(aId, this.edgeA, it);
        }

        private boolean processEdge0(ShapeEdgeId aId, S2Shape.MutableEdge a, CrossingIterator it) {
            assert (a.getStart().equalsPoint(a.getEnd()));
            if (this.invertA != this.invertResult) {
                this.skipCrossings(aId, it);
                return true;
            }
            PointCrossingResult r = this.processPointCrossings(aId, a.getStart(), it);
            boolean contained = this.inside ^ this.invertB;
            if (r.matchesPolygon && this.polygonModel != PolygonModel.SEMI_OPEN) {
                boolean bl = contained = this.polygonModel == PolygonModel.CLOSED;
            }
            if (r.matchesPolyline) {
                contained = true;
            }
            if (r.matchesPoint && !this.isUnion) {
                contained = true;
            }
            if (contained == this.invertB) {
                return true;
            }
            return this.addPointEdge(a.getStart(), 0);
        }

        private void skipCrossings(ShapeEdgeId aId, CrossingIterator it) {
            while (!it.done(aId)) {
                it.next();
            }
        }

        private PointCrossingResult processPointCrossings(ShapeEdgeId aId, S2Point a0, CrossingIterator it) {
            PointCrossingResult r = new PointCrossingResult();
            while (!it.done(aId)) {
                if (it.bDimension() == 0) {
                    r.matchesPoint = true;
                } else if (it.bDimension() == 1) {
                    if (this.polylineEdgeContainsVertex(a0, it, 0)) {
                        r.matchesPolyline = true;
                    }
                } else {
                    r.matchesPolygon = true;
                }
                it.next();
            }
            return r;
        }

        private boolean processEdge1(ShapeEdgeId aId, S2Shape.MutableEdge a, CrossingIterator it) {
            if (this.invertA != this.invertResult) {
                this.skipCrossings(aId, it);
                return true;
            }
            EdgeCrossingResult r = this.processEdgeCrossings(aId, a, it);
            boolean a0Inside = this.isPolylineVertexInside(r.a0MatchesPolyline, r.a0MatchesPolygon);
            boolean isDegenerate = S2BooleanOperation.edgeIsPoint(a);
            this.inside ^= (r.a0Crossings & 1) == 1;
            if (this.inside != this.isPolylineEdgeInside(r, isDegenerate)) {
                this.inside ^= true;
                ++r.a1Crossings;
            }
            S2Shape.MutableEdge chainEdge = new S2Shape.MutableEdge();
            this.aShape.getChainEdge(this.chainId, this.chainLimit - this.chainStart - 1, chainEdge);
            if (!this.polylineLoopsHaveBoundaries && aId.edgeId == this.chainStart && a.getStart().equalsPoint(chainEdge.getEnd())) {
                this.chainV0Emitted = this.inside;
            } else if (this.isV0Isolated(aId) && !isDegenerate && this.polylineContainsV0(aId.edgeId, this.chainStart) && a0Inside && !this.addPointEdge(a.getStart(), 1)) {
                return false;
            }
            if ((this.inside || r.interiorCrossings > 0) && !this.addEdge(aId, a.getStart(), a.getEnd(), 1, r.interiorCrossings)) {
                return false;
            }
            if (this.inside) {
                this.v0EmittedMaxEdgeId = aId.edgeId + 1;
            }
            this.inside ^= (r.a1Crossings & 1) == 1;
            assert (!it.crossingsComplete() || new S2ContainsPointQuery(it.bIndex()).contains(a.getEnd()) == this.inside ^ this.invertB);
            this.aShape.getChainEdge(this.chainId, this.chainStart, chainEdge);
            return !it.crossingsComplete() || isDegenerate || !this.isChainLastVertexIsolated(aId) || this.polylineModel != PolylineModel.CLOSED && (this.polylineLoopsHaveBoundaries || !a.getEnd().equalsPoint(chainEdge.getStart())) || !this.isPolylineVertexInside(r.a1MatchesPolyline, r.a1MatchesPolygon) || this.addPointEdge(a.getEnd(), 1);
        }

        private boolean isPolylineVertexInside(boolean matchesPolyline, boolean matchesPolygon) {
            boolean contained = this.inside ^ this.invertB;
            if (matchesPolyline && !this.isUnion) {
                contained = true;
            } else if (matchesPolygon && this.polygonModel != PolygonModel.SEMI_OPEN) {
                contained = this.polygonModel == PolygonModel.CLOSED;
            }
            return contained ^ this.invertB;
        }

        private boolean isPolylineEdgeInside(EdgeCrossingResult r, boolean isDegenerate) {
            boolean contained = this.inside ^ this.invertB;
            if (r.matchesPolyline && !this.isUnion) {
                contained = true;
            } else if (isDegenerate) {
                if (this.polygonModel != PolygonModel.SEMI_OPEN && r.a0MatchesPolygon) {
                    boolean bl = contained = this.polygonModel == PolygonModel.CLOSED;
                }
                if (r.a0MatchesPolyline && !this.isUnion) {
                    contained = true;
                }
            } else if (r.matchesPolygon()) {
                if (this.polygonModel != PolygonModel.SEMI_OPEN || !r.matchesSibling()) {
                    contained = this.polygonModel != PolygonModel.OPEN;
                }
            } else if (r.matchesSibling()) {
                contained = this.polygonModel == PolygonModel.CLOSED;
            }
            return contained ^ this.invertB;
        }

        private boolean processEdge2(ShapeEdgeId aId, S2Shape.MutableEdge a, CrossingIterator it) {
            boolean emitShared = this.aRegionId == 1;
            boolean createDegen = this.polygonModel == PolygonModel.CLOSED && !this.invertA && !this.invertB || this.polygonModel == PolygonModel.OPEN && this.invertA && this.invertB;
            boolean keepDegenA = this.polygonModel == PolygonModel.OPEN && this.invertB;
            boolean keepDegenB = this.polygonModel == PolygonModel.OPEN && this.invertA;
            EdgeCrossingResult r = this.processEdgeCrossings(aId, a, it);
            assert (!r.matchesPolyline);
            if (this.invertA != this.invertB) {
                ShapeEdgeId tmp = r.polygonMatchId;
                r.polygonMatchId = r.siblingMatchId;
                r.siblingMatchId = tmp;
            }
            boolean isPoint = a.getStart().equalsPoint(a.getEnd());
            if (!emitShared) {
                if (r.loopMatchesA0()) {
                    this.isDegenerateHole.put(r.a0LoopMatchId, this.inside);
                    if (isPoint) {
                        return true;
                    }
                }
                if (this.polygonModel != PolygonModel.SEMI_OPEN && isPoint && r.a0MatchesPolygon) {
                    return true;
                }
            }
            this.inside ^= (r.a0Crossings & 1) == 1;
            if (!emitShared && (r.matchesPolygon() || r.matchesSibling())) {
                if (r.matchesPolygon() && r.matchesSibling()) {
                    this.isDegenerateHole.put(r.polygonMatchId, this.inside);
                    this.isDegenerateHole.put(r.siblingMatchId, this.inside);
                }
                assert (r.interiorCrossings == 0);
                this.inside ^= (r.a1Crossings & 1) == 1;
                return true;
            }
            boolean isBHole = r.matchesPolygon() && r.matchesSibling() && this.inside;
            boolean semiOpenInside = this.inside;
            if (isPoint) {
                if (r.loopMatchesA0()) {
                    this.inside = createDegen || keepDegenA || this.inside == this.isDegenerateHole.get(r.a0LoopMatchId);
                } else if (r.a0MatchesPolygon && this.polygonModel != PolygonModel.SEMI_OPEN) {
                    this.inside = createDegen || keepDegenA;
                }
            } else if (r.matchesPolygon()) {
                if (this.isDegenerate(aId)) {
                    this.inside = createDegen || keepDegenA || (!r.matchesSibling() || this.inside) == this.isDegenerateHole.get(aId);
                } else if (!r.matchesSibling() || createDegen || keepDegenB) {
                    this.inside = true;
                }
            } else if (r.matchesSibling()) {
                this.inside = this.isDegenerate(aId) ? (createDegen || keepDegenA) && this.isDegenerateHole.get(aId) == false : createDegen;
            }
            if (this.inside != semiOpenInside) {
                ++r.a1Crossings;
            }
            if (emitShared && r.a0MatchesPolygon && !this.inside && (createDegen || keepDegenB && r.loopMatchesA0()) && !this.addPointEdge(a.getStart(), 2)) {
                return false;
            }
            if (r.matchesSibling() && (createDegen || keepDegenB) && !this.isDegenerate(aId) && !isBHole && !this.addEdge(r.siblingMatchId, a.getEnd(), a.getStart(), 2, 0)) {
                return false;
            }
            if ((this.inside || r.interiorCrossings > 0) && !this.addEdge(aId, a.getStart(), a.getEnd(), 2, r.interiorCrossings)) {
                return false;
            }
            this.inside ^= (r.a1Crossings & 1) == 1;
            assert (!it.crossingsComplete() || new S2ContainsPointQuery(it.bIndex()).contains(a.getEnd()) == this.inside ^ this.invertB);
            return true;
        }

        private EdgeCrossingResult processEdgeCrossings(ShapeEdgeId aId, S2Shape.MutableEdge a, CrossingIterator it) {
            this.pendingSourceEdgeCrossings.clear();
            EdgeCrossingResult r = new EdgeCrossingResult();
            if (it.done(aId)) {
                return r;
            }
            S2Shape.MutableEdge b = new S2Shape.MutableEdge();
            while (!it.done(aId)) {
                if (it.bDimension() != 0) {
                    it.getBEdge(b);
                    if (it.isInteriorCrossing()) {
                        if (this.aDimension <= it.bDimension() && (this.invertB == this.invertResult || it.bDimension() != 1)) {
                            long srcId = SourceId.encode(this.bRegionId, it.bShapeId(), it.bEdgeId());
                            this.addInteriorCrossing(new SourceEdgeCrossing(srcId, it.leftToRight()));
                        }
                        r.interiorCrossings = r.interiorCrossings + (it.bDimension() == 1 ? 2 : 1);
                    } else if (it.bDimension() == 1) {
                        if (this.aDimension != 2) {
                            if (a.isEqualTo(b) || a.isSiblingOf(b)) {
                                r.matchesPolyline = true;
                            }
                            if (b.hasEndpoint(a.getStart()) && this.polylineEdgeContainsVertex(a.getStart(), it, 1)) {
                                r.a0MatchesPolyline = true;
                            }
                            if (b.hasEndpoint(a.getEnd()) && this.polylineEdgeContainsVertex(a.getEnd(), it, 1)) {
                                r.a1MatchesPolyline = true;
                            }
                        }
                    } else {
                        assert (it.bDimension() == 2);
                        if (S2BooleanOperation.edgeIsPoint(a) || S2BooleanOperation.edgeIsPoint(b)) {
                            if (S2BooleanOperation.edgeEqualsPoint(b, a.getStart())) {
                                r.a0LoopMatchId = it.bId();
                            }
                        } else if (a.isEqualTo(b)) {
                            ++r.a0Crossings;
                            r.polygonMatchId = it.bId();
                        } else if (a.isSiblingOf(b)) {
                            ++r.a0Crossings;
                            r.siblingMatchId = it.bId();
                        } else if (it.isVertexCrossing()) {
                            if (b.hasEndpoint(a.getStart())) {
                                ++r.a0Crossings;
                            } else {
                                ++r.a1Crossings;
                            }
                        }
                        if (b.hasEndpoint(a.getStart())) {
                            r.a0MatchesPolygon = true;
                        }
                        if (b.hasEndpoint(a.getEnd())) {
                            r.a1MatchesPolygon = true;
                        }
                    }
                }
                it.next();
            }
            return r;
        }

        private boolean polylineEdgeContainsVertex(S2Point v, CrossingIterator it, int dimension) {
            int bChainLength;
            assert (it.bDimension() == 1);
            assert (dimension == 0 || dimension == 1);
            if (this.polylineModel == PolylineModel.CLOSED) {
                return true;
            }
            S2Shape.MutableEdge bEdge = new S2Shape.MutableEdge();
            it.getBEdge(bEdge);
            assert (bEdge.hasEndpoint(v));
            int bEdgeId = it.bEdgeId();
            int bEdgeChainId = it.bEdgeChainId();
            int bChainStart = it.bShape().getChainStart(bEdgeChainId);
            int bChainLimit = bChainStart + (bChainLength = it.bShape().getChainLength(bEdgeChainId));
            if (bEdgeId == bChainLimit - 1 && v.equalsPoint(bEdge.getEnd()) && (dimension == 0 || bEdgeId > 0 || !v.equalsPoint(bEdge.getStart()))) {
                return false;
            }
            if (this.polylineContainsV0(bEdgeId, bChainStart)) {
                return true;
            }
            if (!v.equalsPoint(bEdge.getStart())) {
                return true;
            }
            if (this.polylineLoopsHaveBoundaries) {
                return false;
            }
            it.bShape().getChainEdge(bEdgeChainId, bChainLength - 1, bEdge);
            return v.equalsPoint(bEdge.getEnd());
        }

        public void doneBoundaryPair() {
            this.sourceIdMap.put(SourceId.special(-1), -1);
            this.sourceIdMap.put(SourceId.special(-2), -2);
            this.sourceIdMap.put(SourceId.special(-3), -3);
            this.sourceEdgeCrossings.forEach((firstInputEdgeId, secondSourceEdgeCrossing) -> {
                long sourceId = secondSourceEdgeCrossing.sourceId();
                assert (this.sourceIdMap.containsKey(sourceId));
                int secondInputEdgeId = (Integer)this.sourceIdMap.get(sourceId);
                this.inputCrossings.add(new CrossingInputEdgePair(firstInputEdgeId, new CrossingInputEdge(secondInputEdgeId, secondSourceEdgeCrossing.leftToRight())));
            });
            this.sourceEdgeCrossings.clear();
            this.sourceIdMap.clear();
        }

        public boolean inside() {
            return this.inside;
        }

        private int inputEdgeId() {
            return this.inputDimensions.size();
        }

        private boolean isV0Isolated(ShapeEdgeId aId) {
            return !this.inside && this.v0EmittedMaxEdgeId < aId.edgeId;
        }

        private boolean isChainLastVertexIsolated(ShapeEdgeId aId) {
            return aId.edgeId == this.chainLimit - 1 && !this.chainV0Emitted && this.v0EmittedMaxEdgeId <= aId.edgeId;
        }

        private boolean polylineContainsV0(int edgeId, int chainStart) {
            return this.polylineModel != PolylineModel.OPEN || edgeId > chainStart;
        }

        private boolean isDegenerate(ShapeEdgeId aId) {
            return this.isDegenerateHole.containsKey(aId);
        }

        private void addCrossing(SourceEdgeCrossing crossing) {
            this.sourceEdgeCrossings.add(this.inputEdgeId(), crossing);
        }

        private void addInteriorCrossing(SourceEdgeCrossing crossing) {
            this.pendingSourceEdgeCrossings.add(crossing);
        }

        private void setClippingState(int parameter, boolean state) {
            this.addCrossing(new SourceEdgeCrossing(SourceId.special(parameter), state));
        }

        private boolean addEdge(ShapeEdgeId aId, S2Point start, S2Point end, int dimension, int interiorCrossings) {
            if (this.builder == null) {
                return false;
            }
            if (interiorCrossings > 0) {
                for (SourceEdgeCrossing crossing : this.pendingSourceEdgeCrossings) {
                    this.sourceEdgeCrossings.add(this.inputEdgeId(), crossing);
                }
                long srcId = SourceId.encode(this.aRegionId, aId.shapeId, aId.edgeId);
                this.sourceIdMap.put(srcId, this.inputEdgeId());
            }
            if (this.inside != this.prevInside) {
                this.setClippingState(-1, this.inside);
            }
            this.inputDimensions.add(dimension);
            this.builder.addEdge(start, end);
            this.inside ^= (interiorCrossings & 1) == 1;
            this.prevInside = this.inside;
            return true;
        }

        private boolean addPointEdge(S2Point p, int dimension) {
            if (this.builder == null) {
                return false;
            }
            if (!this.prevInside) {
                this.setClippingState(-1, true);
            }
            this.inputDimensions.add(dimension);
            this.builder.addEdge(p, p);
            this.prevInside = true;
            return true;
        }

        private static class SourceEdgeCrossings {
            final ArrayList<InputSourceEdgeCrossing> list = new ArrayList();

            private SourceEdgeCrossings() {
            }

            public void add(int inputEdgeId, SourceEdgeCrossing crossing) {
                this.list.add(new InputSourceEdgeCrossing(inputEdgeId, crossing));
            }

            public void forEach(SourceEdgeCrossingVisitor visitor) {
                for (InputSourceEdgeCrossing crossing : this.list) {
                    visitor.visit(crossing.inputEdgeId, crossing.sourceEdgeCrossing);
                }
            }

            public void clear() {
                this.list.clear();
            }

            private static class InputSourceEdgeCrossing {
                public final int inputEdgeId;
                public final SourceEdgeCrossing sourceEdgeCrossing;

                public InputSourceEdgeCrossing(int inputEdgeId, SourceEdgeCrossing crossing) {
                    this.inputEdgeId = inputEdgeId;
                    this.sourceEdgeCrossing = crossing;
                }
            }
        }

        private static interface SourceEdgeCrossingVisitor {
            public void visit(int var1, SourceEdgeCrossing var2);
        }

        private static class SourceEdgeCrossing {
            private final long srcId;
            private final boolean leftToRight;

            public SourceEdgeCrossing(long srcId, boolean leftToRight) {
                this.srcId = srcId;
                this.leftToRight = leftToRight;
            }

            public long sourceId() {
                return this.srcId;
            }

            public boolean leftToRight() {
                return this.leftToRight;
            }

            public String toString() {
                return "SourceEdgeCrossing(" + this.srcId + ", " + this.leftToRight + ")";
            }
        }

        private static class EdgeCrossingResult {
            public boolean matchesPolyline = false;
            public boolean a0MatchesPolyline = false;
            public boolean a1MatchesPolyline = false;
            public boolean a0MatchesPolygon = false;
            public boolean a1MatchesPolygon = false;
            public ShapeEdgeId polygonMatchId = ShapeEdgeId.NONE;
            public ShapeEdgeId siblingMatchId = ShapeEdgeId.NONE;
            public ShapeEdgeId a0LoopMatchId = ShapeEdgeId.NONE;
            public int a0Crossings = 0;
            public int a1Crossings = 0;
            public int interiorCrossings = 0;

            private EdgeCrossingResult() {
            }

            public boolean matchesPolygon() {
                return this.polygonMatchId.edgeId >= 0;
            }

            public boolean matchesSibling() {
                return this.siblingMatchId.edgeId >= 0;
            }

            public boolean loopMatchesA0() {
                return this.a0LoopMatchId.edgeId >= 0;
            }
        }

        private static class SourceIdMap
        extends HashMap<Long, Integer> {
            private SourceIdMap() {
            }
        }
    }

    private static class IndexCrossings {
        private final ArrayList<IndexCrossing> list = new ArrayList();
        public static final Comparator<IndexCrossing> COMPARATOR = (x, y) -> {
            int result = Integer.compare(x.aEdge.shapeId, y.aEdge.shapeId);
            if (result != 0) {
                return result;
            }
            result = Integer.compare(x.aEdge.edgeId, y.aEdge.edgeId);
            if (result != 0) {
                return result;
            }
            result = Integer.compare(x.bEdge.shapeId, y.bEdge.shapeId);
            if (result != 0) {
                return result;
            }
            return Integer.compare(x.bEdge.edgeId, y.bEdge.edgeId);
        };

        private IndexCrossings() {
        }

        public Iterator iterator() {
            return new Iterator();
        }

        public void clear() {
            this.list.clear();
        }

        public void reverseAll() {
            for (IndexCrossing crossing : this.list) {
                crossing.reverse();
            }
        }

        public void sort() {
            this.list.sort(COMPARATOR);
        }

        public void add(IndexCrossing crossing) {
            this.list.add(crossing);
        }

        public int size() {
            return this.list.size();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public class Iterator {
            private int position = 0;
            public IndexCrossing current = null;

            public Iterator() {
                this.current = IndexCrossings.this.list.isEmpty() ? IndexCrossing.SENTINEL : IndexCrossings.this.list.get(0);
            }

            public boolean hasNext() {
                return !this.current.isEqualTo(IndexCrossing.SENTINEL);
            }

            public void next() {
                assert (this.hasNext());
                IndexCrossing last = IndexCrossings.this.list.get(this.position);
                ++this.position;
                while (last.isEqualTo(IndexCrossings.this.list.get(this.position)) && this.position < IndexCrossings.this.list.size()) {
                    ++this.position;
                }
                this.current = this.position == IndexCrossings.this.list.size() ? IndexCrossing.SENTINEL : IndexCrossings.this.list.get(this.position);
            }
        }
    }

    private static class IndexCrossing {
        private static final IndexCrossing SENTINEL = new IndexCrossing(ShapeEdgeId.SENTINEL, ShapeEdgeId.SENTINEL);
        private ShapeEdgeId aEdge;
        private ShapeEdgeId bEdge;
        boolean isInteriorCrossing;
        boolean leftToRight;
        boolean isVertexCrossing;

        public IndexCrossing(ShapeEdgeId a, ShapeEdgeId b) {
            this.aEdge = a;
            this.bEdge = b;
            this.isInteriorCrossing = false;
            this.leftToRight = false;
            this.isVertexCrossing = false;
        }

        public void reverse() {
            ShapeEdgeId tmp = this.aEdge;
            this.aEdge = this.bEdge;
            this.bEdge = tmp;
            this.leftToRight ^= true;
            this.isVertexCrossing ^= true;
        }

        public int hashCode() {
            return this.aEdge.hashCode() * 7 + this.bEdge.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IndexCrossing)) {
                return false;
            }
            IndexCrossing other = (IndexCrossing)obj;
            return this.isEqualTo(other);
        }

        public boolean isEqualTo(IndexCrossing other) {
            return this.aEdge.shapeId == other.aEdge.shapeId && this.aEdge.edgeId == other.aEdge.edgeId && this.bEdge.shapeId == other.bEdge.shapeId && this.bEdge.edgeId == other.bEdge.edgeId;
        }
    }

    private static class CrossingIterator {
        private final S2ShapeIndex bIndex;
        private final IndexCrossings.Iterator it;
        private S2Shape bShape;
        private int bShapeId;
        private int bDimension;
        private final boolean crossingsComplete;
        private int bEdgeChainId;

        public CrossingIterator(S2ShapeIndex bIndex, IndexCrossings crossings, boolean crossingsComplete) {
            this.bIndex = bIndex;
            this.it = crossings.iterator();
            this.bShapeId = -1;
            this.crossingsComplete = crossingsComplete;
            this.update();
        }

        public void next() {
            this.it.next();
            this.update();
        }

        public boolean done(ShapeEdgeId id) {
            return !this.aId().isEqualTo(id);
        }

        public boolean crossingsComplete() {
            return this.crossingsComplete;
        }

        public boolean isInteriorCrossing() {
            return this.it.current.isInteriorCrossing;
        }

        public boolean isVertexCrossing() {
            return this.it.current.isVertexCrossing;
        }

        public boolean leftToRight() {
            return this.it.current.leftToRight;
        }

        public ShapeEdgeId aId() {
            return this.it.current.aEdge;
        }

        public ShapeEdgeId bId() {
            return this.it.current.bEdge;
        }

        public S2ShapeIndex bIndex() {
            return this.bIndex;
        }

        public S2Shape bShape() {
            return this.bShape;
        }

        public int bDimension() {
            return this.bDimension;
        }

        public int bShapeId() {
            return this.bShapeId;
        }

        public int bEdgeId() {
            return this.bId().edgeId;
        }

        public void getBEdge(S2Shape.MutableEdge edge) {
            this.bShape.getEdge(this.bEdgeId(), edge);
        }

        public int bEdgeChainId() {
            if (this.bEdgeChainId < 0) {
                S2Shape.ChainPosition position = new S2Shape.ChainPosition();
                this.bShape.getChainPosition(this.bEdgeId(), position);
                this.bEdgeChainId = position.chainId;
            }
            return this.bEdgeChainId;
        }

        private void update() {
            if (!this.aId().isEqualTo(ShapeEdgeId.SENTINEL) && this.bId().shapeId != this.bShapeId) {
                this.bShapeId = this.bId().shapeId;
                this.bShape = this.bIndex.getShapes().get(this.bShapeId);
                this.bDimension = this.bShape.dimension();
                this.bEdgeChainId = -1;
            }
        }
    }

    private static class PointCrossingResult {
        boolean matchesPoint = false;
        boolean matchesPolyline = false;
        boolean matchesPolygon = false;

        private PointCrossingResult() {
        }
    }

    private static class Impl {
        private final S2BooleanOperation op;
        private S2Builder.Builder builderOptions;
        private final boolean isBooleanOutput;
        private S2Builder builder;
        private final IntVector inputDimensions = new IntVector();
        private final InputEdgeCrossings inputCrossings = new InputEdgeCrossings();
        private final IndexCrossings indexCrossings = new IndexCrossings();
        private int indexCrossingsFirstRegionId;
        private final IndexCrossings tmpCrossings = new IndexCrossings();

        public Impl(S2BooleanOperation op) {
            this.op = op;
            this.isBooleanOutput = op.layers.isEmpty();
            this.indexCrossingsFirstRegionId = -1;
        }

        public boolean build(S2Error error) {
            error.clear();
            this.doBuild(error);
            return error.ok();
        }

        private boolean addBoundary(int aRegionId, boolean invertA, boolean invertB, boolean invertResult, List<ShapeEdgeId> aChainStarts, CrossingProcessor crossingProcessor) {
            S2ShapeIndex aIndex = this.op.regions[aRegionId];
            S2ShapeIndex bIndex = this.op.regions[1 - aRegionId];
            if (!this.initIndexCrossings(aRegionId)) {
                return false;
            }
            S2Shape.ChainPosition chainPosition = new S2Shape.ChainPosition();
            crossingProcessor.startBoundary(aRegionId, invertA, invertB, invertResult);
            Iterator<ShapeEdgeId> chainStartIterator = aChainStarts.iterator();
            ShapeEdgeId chainStart = chainStartIterator.next();
            CrossingIterator nextCrossingIterator = new CrossingIterator(bIndex, this.indexCrossings, true);
            ShapeEdgeId nextId = ShapeEdgeId.min(chainStart, nextCrossingIterator.aId());
            List<S2Shape> aShapes = aIndex.getShapes();
            while (!nextId.isEqualTo(ShapeEdgeId.SENTINEL)) {
                int aShapeId = nextId.shapeId;
                S2Shape aShape = aShapes.get(aShapeId);
                crossingProcessor.startShape(aShape);
                while (nextId.shapeId == aShapeId) {
                    int edgeId = nextId.edgeId;
                    aShape.getChainPosition(edgeId, chainPosition);
                    int chainId = chainPosition.chainId;
                    int chainLimit = aShape.getChainStart(chainId) + aShape.getChainLength(chainId);
                    boolean startInside = nextId.isEqualTo(chainStart);
                    if (startInside) {
                        chainStart = chainStartIterator.next();
                    }
                    crossingProcessor.startChain(chainId, aShape, startInside);
                    while (edgeId < chainLimit) {
                        ShapeEdgeId aId = new ShapeEdgeId(aShapeId, edgeId);
                        assert (crossingProcessor.inside() || nextCrossingIterator.aId().isEqualTo(aId));
                        if (!crossingProcessor.processEdge(aId, nextCrossingIterator)) {
                            return false;
                        }
                        if (crossingProcessor.inside()) {
                            ++edgeId;
                            continue;
                        }
                        if (nextCrossingIterator.aId().shapeId != aShapeId || nextCrossingIterator.aId().edgeId >= chainLimit) break;
                        edgeId = nextCrossingIterator.aId().edgeId;
                    }
                    nextId = ShapeEdgeId.min(chainStart, nextCrossingIterator.aId());
                }
            }
            return true;
        }

        private boolean getChainStarts(int aRegionId, boolean invertA, boolean invertB, boolean invertResult, CrossingProcessor crossingProcessor, List<ShapeEdgeId> chainStarts) {
            boolean bHasInterior;
            S2ShapeIndex aIndex = this.op.regions[aRegionId];
            S2ShapeIndex bIndex = this.op.regions[1 - aRegionId];
            if (this.isBooleanOutput) {
                crossingProcessor.startBoundary(aRegionId, invertA, invertB, invertResult);
            }
            if ((bHasInterior = S2ShapeUtil.hasInterior(bIndex)) || invertB || this.isBooleanOutput) {
                S2ContainsPointQuery bQuery = new S2ContainsPointQuery(bIndex);
                S2Shape.MutableEdge reusableEdge = new S2Shape.MutableEdge();
                int numShapeIds = aIndex.getShapes().size();
                for (int shapeId = 0; shapeId < numShapeIds; ++shapeId) {
                    S2Shape aShape = aIndex.getShapes().get(shapeId);
                    if (invertA != invertResult && aShape.dimension() < 2) continue;
                    if (this.isBooleanOutput) {
                        crossingProcessor.startShape(aShape);
                    }
                    for (int chainId = 0; chainId < aShape.numChains(); ++chainId) {
                        List<S2Point> chain = aShape.chain(chainId);
                        if (chain.isEmpty()) continue;
                        boolean inside = (bHasInterior && bQuery.contains(chain.get(0))) != invertB;
                        int startEdgeId = aShape.getChainStart(chainId);
                        if (inside) {
                            chainStarts.add(new ShapeEdgeId(shapeId, startEdgeId));
                        }
                        if (!this.isBooleanOutput) continue;
                        crossingProcessor.startChain(chainId, aShape, inside);
                        aShape.getEdge(startEdgeId, reusableEdge);
                        ShapeEdge a = new ShapeEdge(shapeId, startEdgeId, reusableEdge.getStart(), reusableEdge.getEnd());
                        if (this.processIncidentEdges(a, bIndex, bQuery, crossingProcessor)) continue;
                        return false;
                    }
                }
            }
            chainStarts.add(ShapeEdgeId.SENTINEL);
            return true;
        }

        private boolean processIncidentEdges(ShapeEdge a, S2ShapeIndex bIndex, S2ContainsPointQuery bQuery, CrossingProcessor crossingProcessor) {
            this.tmpCrossings.clear();
            bQuery.visitIncidentEdges(a.v0, (bShapeId, bEdgeId, bStart, bEnd) -> {
                ShapeEdge b = new ShapeEdge(bShapeId, bEdgeId, bStart, bEnd);
                return this.addIndexCrossing(a, b, false, this.tmpCrossings);
            }, new S2Shape.MutableEdge());
            if (this.tmpCrossings.isEmpty()) {
                return !crossingProcessor.inside();
            }
            if (this.tmpCrossings.size() > 1) {
                this.tmpCrossings.sort();
            }
            this.tmpCrossings.add(new IndexCrossing(ShapeEdgeId.SENTINEL, ShapeEdgeId.SENTINEL));
            CrossingIterator nextCrossing = new CrossingIterator(bIndex, this.tmpCrossings, false);
            return crossingProcessor.processEdge(a.id, nextCrossing);
        }

        private boolean addIndexCrossing(ShapeEdge a, ShapeEdge b, boolean isInterior, IndexCrossings crossings) {
            IndexCrossing crossing = new IndexCrossing(a.id, b.id);
            crossings.add(crossing);
            if (isInterior) {
                crossing.isInteriorCrossing = true;
                if (S2Predicates.sign(a.v0, a.v1, b.v0) > 0) {
                    crossing.leftToRight = true;
                }
                this.builder.addIntersection(S2EdgeUtil.getIntersection(a.v0, a.v1, b.v0, b.v1));
            } else if (S2EdgeUtil.vertexCrossing(a.v0, a.v1, b.v0, b.v1)) {
                crossing.isVertexCrossing = true;
            }
            return true;
        }

        private boolean initIndexCrossings(int regionId) {
            if (regionId == this.indexCrossingsFirstRegionId) {
                return true;
            }
            if (this.indexCrossingsFirstRegionId < 0) {
                Preconditions.checkState((regionId == 0 ? 1 : 0) != 0);
                S2CrossingEdgesQuery query = new S2CrossingEdgesQuery(S2CrossingEdgesQuery.CrossingType.ALL);
                if (!query.visitCrossingEdgePairs(this.op.regions[0], this.op.regions[1], (aShapeId, aEdgeId, aEdgeSrc, aEdgeDst, bShapeId, bEdgeId, bEdgeSrc, bEdgeDst, isInterior) -> {
                    if (isInterior && this.isBooleanOutput) {
                        return false;
                    }
                    ShapeEdge a = new ShapeEdge(aShapeId, aEdgeId, aEdgeSrc, aEdgeDst);
                    ShapeEdge b = new ShapeEdge(bShapeId, bEdgeId, bEdgeSrc, bEdgeDst);
                    return this.addIndexCrossing(a, b, isInterior, this.indexCrossings);
                })) {
                    return false;
                }
                if (this.indexCrossings.size() > 1) {
                    this.indexCrossings.sort();
                }
                this.indexCrossings.add(new IndexCrossing(ShapeEdgeId.SENTINEL, ShapeEdgeId.SENTINEL));
                this.indexCrossingsFirstRegionId = 0;
            }
            if (regionId != this.indexCrossingsFirstRegionId) {
                this.indexCrossings.reverseAll();
                this.indexCrossings.sort();
                this.indexCrossingsFirstRegionId = regionId;
            }
            return true;
        }

        private boolean addBoundaryPair(boolean invertA, boolean invertB, boolean invertResult, CrossingProcessor crossingProcessor) {
            OpType type = this.op.opType;
            if (type == OpType.DIFFERENCE || type == OpType.SYMMETRIC_DIFFERENCE) {
                if (this.areRegionsIdentical()) {
                    return true;
                }
            } else if (this.isBooleanOutput) {
                // empty if block
            }
            ArrayList<ShapeEdgeId> aStarts = new ArrayList<ShapeEdgeId>();
            ArrayList<ShapeEdgeId> bStarts = new ArrayList<ShapeEdgeId>();
            if (!(this.getChainStarts(0, invertA, invertB, invertResult, crossingProcessor, aStarts) && this.getChainStarts(1, invertB, invertA, invertResult, crossingProcessor, bStarts) && this.addBoundary(0, invertA, invertB, invertResult, aStarts, crossingProcessor) && this.addBoundary(1, invertB, invertA, invertResult, bStarts, crossingProcessor))) {
                Preconditions.checkState((boolean)this.isBooleanOutput);
                return false;
            }
            if (!this.isBooleanOutput) {
                crossingProcessor.doneBoundaryPair();
            }
            return true;
        }

        private boolean areRegionsIdentical() {
            return S2ShapeUtil.equals(this.op.regions[0].getShapes(), this.op.regions[1].getShapes());
        }

        private boolean buildOpType(OpType opType) {
            CrossingProcessor crossingProcessor = new CrossingProcessor(this.op.options.polygonModel(), this.op.options.polylineModel(), this.op.options.polylineLoopsHaveBoundaries(), this.builder, this.inputDimensions, this.inputCrossings);
            switch (opType) {
                case UNION: {
                    return this.addBoundaryPair(true, true, true, crossingProcessor);
                }
                case INTERSECTION: {
                    return this.addBoundaryPair(false, false, false, crossingProcessor);
                }
                case DIFFERENCE: {
                    return this.addBoundaryPair(false, true, false, crossingProcessor);
                }
                case SYMMETRIC_DIFFERENCE: {
                    return this.addBoundaryPair(false, true, false, crossingProcessor) && this.addBoundaryPair(true, false, false, crossingProcessor);
                }
            }
            throw new IllegalStateException("Invalid S2BooleanOperation.OpType" + opType);
        }

        private static byte getFaceMask(S2ShapeIndex index) {
            byte mask = 0;
            S2Iterator.ListIterator<S2ShapeIndex.Cell> it = index.iterator();
            while (!it.done()) {
                int face = it.id().face();
                mask = (byte)(mask | 1 << face);
                it.seek(S2CellId.fromFace(face + 1).rangeMin());
            }
            return mask;
        }

        private boolean isFullPolygonResult(S2BuilderGraph unused) {
            assert (S2BuilderSnapFunctions.maxSnapRadius().degrees() <= 70.0);
            S2ShapeIndex a = this.op.regions[0];
            S2ShapeIndex b = this.op.regions[1];
            switch (this.op.opType) {
                case UNION: {
                    return this.isFullPolygonUnion(a, b);
                }
                case INTERSECTION: {
                    return this.isFullPolygonIntersection(a, b);
                }
                case DIFFERENCE: {
                    return this.isFullPolygonDifference(a, b);
                }
                case SYMMETRIC_DIFFERENCE: {
                    return this.isFullPolygonSymmetricDifference(a, b);
                }
            }
            throw new IllegalStateException("Invalid S2BooleanOperation.OpType");
        }

        private boolean isFullPolygonUnion(S2ShapeIndex a, S2ShapeIndex b) {
            double maxArea;
            double bArea;
            if ((Impl.getFaceMask(a) | Impl.getFaceMask(b)) != 63) {
                return false;
            }
            double aArea = S2ShapeIndexMeasures.area(a);
            double minArea = Math.max(aArea, bArea = S2ShapeIndexMeasures.area(b));
            return minArea > Math.PI * 4 - (maxArea = Math.min(Math.PI * 4, aArea + bArea));
        }

        private boolean isFullPolygonIntersection(S2ShapeIndex a, S2ShapeIndex b) {
            double maxArea;
            double bArea;
            if ((Impl.getFaceMask(a) & Impl.getFaceMask(b)) != 63) {
                return false;
            }
            double aArea = S2ShapeIndexMeasures.area(a);
            double minArea = Math.max(0.0, aArea + (bArea = S2ShapeIndexMeasures.area(b)) - Math.PI * 4);
            return minArea > Math.PI * 4 - (maxArea = Math.min(aArea, bArea));
        }

        private boolean isFullPolygonDifference(S2ShapeIndex a, S2ShapeIndex b) {
            double maxArea;
            double bArea;
            if (Impl.getFaceMask(a) != 63) {
                return false;
            }
            double aArea = S2ShapeIndexMeasures.area(a);
            double minArea = Math.max(0.0, aArea - (bArea = S2ShapeIndexMeasures.area(b)));
            return minArea > Math.PI * 4 - (maxArea = Math.min(aArea, Math.PI * 4 - bArea));
        }

        private boolean isFullPolygonSymmetricDifference(S2ShapeIndex a, S2ShapeIndex b) {
            byte bMask;
            byte aMask = Impl.getFaceMask(a);
            if ((aMask | (bMask = Impl.getFaceMask(b))) != 63) {
                return false;
            }
            double aArea = S2ShapeIndexMeasures.area(a);
            double bArea = S2ShapeIndexMeasures.area(b);
            double minArea = Math.abs(aArea - bArea);
            double maxArea = Math.PI * 4 - Math.abs(Math.PI * 4 - (aArea + bArea));
            S1Angle edgeSnapRadius = this.builderOptions.edgeSnapRadius();
            double hemisphereAreaError = Math.PI * 2 * edgeSnapRadius.radians() + 8.881784197001252E-15;
            double errorSign = minArea - (Math.PI * 4 - maxArea);
            if (Math.abs(errorSign) <= hemisphereAreaError) {
                return (aMask & bMask) != 63;
            }
            return errorSign > 0.0;
        }

        private void doBuild(S2Error error) {
            this.builderOptions = new S2Builder.Builder(this.op.options.snapFunction());
            this.builderOptions.setIntersectionTolerance(S1Angle.radians(1.7763568394002505E-15));
            if (this.op.options.splitAllCrossingPolylineEdges()) {
                this.builderOptions.setSplitCrossingEdges(true);
            }
            this.builderOptions.setIdempotent(false);
            if (this.isBooleanOutput) {
                this.op.resultEmpty = this.buildOpType(this.op.opType) && !this.isFullPolygonResult(null);
                return;
            }
            this.builder = this.builderOptions.build();
            this.builder.startLayer(new EdgeClippingLayer(this.op.layers, this.inputDimensions, this.inputCrossings));
            this.builder.addIsFullPolygonPredicate(this::isFullPolygonResult);
            boolean unused = this.buildOpType(this.op.opType);
            unused = this.builder.build(error);
        }
    }

    private static class ShapeEdge {
        public final ShapeEdgeId id;
        public final S2Point v0;
        public final S2Point v1;

        public ShapeEdge(int shapeId, int edgeId, S2Point v0, S2Point v1) {
            this.id = new ShapeEdgeId(shapeId, edgeId);
            this.v0 = v0;
            this.v1 = v1;
        }

        public String toString() {
            return "ShapeEdge(" + this.id + ", " + this.v0 + ", " + this.v1 + ")";
        }
    }

    private static class ShapeEdgeId
    implements Comparable<ShapeEdgeId> {
        public static final ShapeEdgeId SENTINEL = new ShapeEdgeId(Integer.MAX_VALUE, 0);
        public static final ShapeEdgeId NONE = new ShapeEdgeId(-1, -1);
        public final int shapeId;
        public final int edgeId;

        public ShapeEdgeId(int shapeId, int edgeId) {
            this.shapeId = shapeId;
            this.edgeId = edgeId;
        }

        public boolean isEqualTo(ShapeEdgeId other) {
            return this.shapeId == other.shapeId && this.edgeId == other.edgeId;
        }

        public int hashCode() {
            return Objects.hash(this.shapeId, this.edgeId);
        }

        public boolean equals(Object obj) {
            return obj instanceof ShapeEdgeId && this.isEqualTo((ShapeEdgeId)obj);
        }

        @Override
        public int compareTo(ShapeEdgeId other) {
            int result = Integer.compare(this.shapeId, other.shapeId);
            if (result != 0) {
                return result;
            }
            return Integer.compare(this.edgeId, other.edgeId);
        }

        public static ShapeEdgeId min(ShapeEdgeId a, ShapeEdgeId b) {
            return a.compareTo(b) < 0 ? a : b;
        }

        public String toString() {
            if (this.shapeId == Integer.MAX_VALUE && this.edgeId == 0) {
                return "ShapeEdgeId.SENTINEL";
            }
            return "ShapeEdgeId(" + this.shapeId + ", " + this.edgeId + ")";
        }
    }

    private static class EdgeClippingLayer
    implements S2BuilderLayer {
        private final List<S2BuilderLayer> layers;
        private final IntVector inputDimensions;
        private final InputEdgeCrossings inputCrossings;

        public EdgeClippingLayer(List<S2BuilderLayer> layers, IntVector inputDimensions, InputEdgeCrossings inputCrossings) {
            this.layers = layers;
            this.inputDimensions = inputDimensions;
            this.inputCrossings = inputCrossings;
        }

        public String toString() {
            return "S2BooleanOperation.EdgeClippingLayer with " + this.layers.size() + " output layers.";
        }

        @Override
        public S2Builder.GraphOptions graphOptions() {
            return new S2Builder.GraphOptions(S2Builder.EdgeType.DIRECTED, S2Builder.GraphOptions.DegenerateEdges.KEEP, S2Builder.GraphOptions.DuplicateEdges.KEEP, S2Builder.GraphOptions.SiblingPairs.KEEP);
        }

        @Override
        public boolean build(S2BuilderGraph g, S2Error error) {
            S2BuilderGraph.EdgeList newEdges = new S2BuilderGraph.EdgeList();
            IntVector newInputEdgeIds = new IntVector();
            GraphEdgeClipper gec = new GraphEdgeClipper(g, this.inputDimensions, this.inputCrossings, newEdges, newInputEdgeIds);
            gec.run();
            gec = null;
            IdSetLexicon newInputEdgeIdSetLexicon = g.inputEdgeIdSetLexicon();
            if (this.layers.size() == 1) {
                S2BuilderGraph newGraph = g.makeSubgraph(this.layers.get(0).graphOptions(), newEdges, newInputEdgeIds, newInputEdgeIdSetLexicon, g.isFullPolygonPredicate(), error);
                boolean bl = this.layers.get(0).build(newGraph, error);
            } else {
                Preconditions.checkState((this.layers.size() == 3 ? 1 : 0) != 0);
                S2BuilderGraph.EdgeList[] layerEdges = new S2BuilderGraph.EdgeList[3];
                IntVector[] layerInputEdgeIds = new IntVector[3];
                for (int d = 0; d < 3; ++d) {
                    layerEdges[d] = new S2BuilderGraph.EdgeList();
                    layerInputEdgeIds[d] = new IntVector();
                }
                for (int i = 0; i < newEdges.size(); ++i) {
                    int newInputEdgeId = newInputEdgeIds.get(i);
                    int d = this.inputDimensions.get(newInputEdgeId);
                    layerEdges[d].copyEdge(newEdges, i);
                    layerInputEdgeIds[d].add(newInputEdgeId);
                }
                newEdges.clear();
                newInputEdgeIds.clear();
                S2BuilderGraph[] layerGraphs = new S2BuilderGraph[3];
                for (int d = 0; d < 3; ++d) {
                    layerGraphs[d] = g.makeSubgraph(this.layers.get(d).graphOptions(), layerEdges[d], layerInputEdgeIds[d], newInputEdgeIdSetLexicon, g.isFullPolygonPredicate(), error);
                    boolean bl = this.layers.get(d).build(layerGraphs[d], error);
                }
            }
            return error.ok();
        }
    }

    private static class GraphEdgeClipper {
        private final S2BuilderGraph g;
        private final S2BuilderGraph.VertexInMap in;
        private final S2BuilderGraph.VertexOutMap out;
        private final IntVector inputDimensions;
        private final InputEdgeCrossings inputCrossings;
        private final S2BuilderGraph.EdgeList newEdges;
        private final IntVector newInputEdgeIds;
        private final Ints.IntList inputEdgeIds;
        private final IntVector order;
        private final int[] rank;
        private static final int TRUE = 1;
        private static final int FALSE = 0;

        public GraphEdgeClipper(S2BuilderGraph g, IntVector inputDimensions, InputEdgeCrossings inputCrossings, S2BuilderGraph.EdgeList newEdges, IntVector newInputEdgeIds) {
            this.g = g;
            this.in = new S2BuilderGraph.VertexInMap(g);
            this.out = new S2BuilderGraph.VertexOutMap(g);
            this.inputDimensions = inputDimensions;
            this.inputCrossings = inputCrossings;
            this.newEdges = newEdges;
            this.newInputEdgeIds = newInputEdgeIds;
            this.inputEdgeIds = g.inputEdgeIdSetIds();
            this.order = S2BooleanOperation.getInputEdgeChainOrder(g, this.inputEdgeIds);
            this.rank = new int[this.order.size()];
            this.order.forEach((k, v) -> {
                this.rank[v] = k;
            });
            newEdges.ensureCapacity(g.numEdges());
            newInputEdgeIds.ensureCapacity(g.numEdges());
        }

        public void run() {
            IntVector aVertices = new IntVector();
            IntVector aNumCrossings = new IntVector();
            IntVector aIsolated = new IntVector();
            CrossingInputEdgeVector bInputEdges = new CrossingInputEdgeVector();
            CrossingGraphEdgeVectorVector bEdges = new CrossingGraphEdgeVectorVector();
            boolean inside = false;
            boolean invertB = false;
            boolean reverseA = false;
            int inputCrossingsIndex = 0;
            for (int i = 0; i < this.order.size(); ++i) {
                int ai;
                CrossingInputEdgePair crossingPair;
                int edge0Id = this.order.get(i);
                int aInputEdgeId = this.inputEdgeIds.get(edge0Id);
                int edge0SrcId = this.g.edgeSrcId(edge0Id);
                int edge0DstId = this.g.edgeDstId(edge0Id);
                bInputEdges.clear();
                while (inputCrossingsIndex < this.inputCrossings.size() && (crossingPair = (CrossingInputEdgePair)this.inputCrossings.get(inputCrossingsIndex)).first() == aInputEdgeId) {
                    if (crossingPair.second().inputEdgeId() >= 0) {
                        bInputEdges.add(crossingPair.second());
                    } else if (crossingPair.second().inputEdgeId() == -1) {
                        inside = crossingPair.second().leftToRight();
                    } else if (crossingPair.second().inputEdgeId() == -2) {
                        invertB = crossingPair.second().leftToRight();
                    } else {
                        Preconditions.checkState((crossingPair.second().inputEdgeId() == -3 ? 1 : 0) != 0);
                        reverseA = crossingPair.second().leftToRight();
                    }
                    ++inputCrossingsIndex;
                }
                if (edge0SrcId == edge0DstId) {
                    inside ^= (bInputEdges.size() & 1) == 1;
                    this.addEdge(edge0SrcId, edge0DstId, aInputEdgeId);
                    continue;
                }
                if (bInputEdges.isEmpty()) {
                    if (!inside) continue;
                    if (reverseA) {
                        this.addEdge(edge0DstId, edge0SrcId, aInputEdgeId);
                        continue;
                    }
                    this.addEdge(edge0SrcId, edge0DstId, aInputEdgeId);
                    continue;
                }
                aVertices.clear();
                aVertices.add(edge0SrcId);
                bEdges.reinitialize(bInputEdges.size());
                this.gatherIncidentEdges(aVertices, 0, bInputEdges, bEdges);
                while (i < this.order.size() && this.inputEdgeIds.get(this.order.get(i)) == aInputEdgeId) {
                    aVertices.add(this.g.edgeDstId(this.order.get(i)));
                    this.gatherIncidentEdges(aVertices, aVertices.size() - 1, bInputEdges, bEdges);
                    ++i;
                }
                --i;
                aNumCrossings.clear();
                aNumCrossings.resize(aVertices.size());
                aIsolated.clear();
                aIsolated.resize(aVertices.size());
                for (int bi = 0; bi < bInputEdges.size(); ++bi) {
                    boolean isLine;
                    CrossingInputEdge bCrossingEdge = (CrossingInputEdge)bInputEdges.get(bi);
                    int bInputEdgeId = bCrossingEdge.inputEdgeId();
                    boolean leftToRight = bCrossingEdge.leftToRight();
                    int aIndex = this.getCrossedVertexIndex(aVertices, bEdges.get(bi), leftToRight);
                    if (aIndex < 0) {
                        throw new IllegalStateException("Failed to get crossed vertex index.");
                    }
                    boolean bl = isLine = this.inputDimensions.get(bInputEdgeId) == 1;
                    int sign = isLine ? 0 : (leftToRight == invertB ? -1 : 1);
                    aNumCrossings.incrementAt(aIndex, sign);
                    aIsolated.set(aIndex, 1);
                }
                int multiplicity = (inside ? 1 : 0) + aNumCrossings.get(0);
                for (ai = 1; ai < aVertices.size(); ++ai) {
                    int ei;
                    if (multiplicity != 0) {
                        aIsolated.set(ai - 1, 0);
                        aIsolated.set(ai, 0);
                    }
                    int edgeCount = reverseA ? -multiplicity : multiplicity;
                    for (ei = 0; ei < edgeCount; ++ei) {
                        this.addEdge(aVertices.get(ai - 1), aVertices.get(ai), aInputEdgeId);
                    }
                    for (ei = edgeCount; ei < 0; ++ei) {
                        this.addEdge(aVertices.get(ai), aVertices.get(ai - 1), aInputEdgeId);
                    }
                    multiplicity += aNumCrossings.get(ai);
                }
                Preconditions.checkState((multiplicity == 0 || multiplicity == 1 ? 1 : 0) != 0);
                boolean bl = inside = multiplicity != 0;
                if (this.inputDimensions.get(aInputEdgeId) == 0) continue;
                for (ai = 0; ai < aVertices.size(); ++ai) {
                    if (aIsolated.get(ai) != 1) continue;
                    this.addEdge(aVertices.get(ai), aVertices.get(ai), aInputEdgeId);
                }
            }
        }

        private void addEdge(int edgeSrcId, int edgeDstId, int inputEdgeId) {
            this.newEdges.add(edgeSrcId, edgeDstId);
            this.newInputEdgeIds.add(inputEdgeId);
        }

        private void gatherIncidentEdges(IntVector a, int ai, CrossingInputEdgeVector bInputEdges, CrossingGraphEdgeVectorVector bEdges) {
            Preconditions.checkState((bInputEdges.size() == bEdges.size() ? 1 : 0) != 0);
            this.in.edgeIds(a.get(ai)).forEach(snappedEdgeId -> {
                int inputEdgeId = this.inputEdgeIds.get(snappedEdgeId);
                int index = bInputEdges.lowerBound(inputEdgeId);
                if (index != bInputEdges.size() && ((CrossingInputEdge)bInputEdges.get(index)).inputEdgeId() == inputEdgeId) {
                    bEdges.addCrossingGraphEdge(index, snappedEdgeId, ai, false, this.g.edgeSrcId(snappedEdgeId));
                }
            });
            this.out.edgeIds(a.get(ai)).forEach(snappedEdgeId -> {
                int inputEdgeId = this.inputEdgeIds.get(snappedEdgeId);
                int index = bInputEdges.lowerBound(inputEdgeId);
                if (index != bInputEdges.size() && ((CrossingInputEdge)bInputEdges.get(index)).inputEdgeId() == inputEdgeId) {
                    bEdges.addCrossingGraphEdge(index, snappedEdgeId, ai, true, this.g.edgeDstId(snappedEdgeId));
                }
            });
        }

        private int getCrossedVertexIndex(IntVector a, CrossingGraphEdgeVector b, boolean leftToRight) {
            if (a.isEmpty() || b.isEmpty()) {
                throw new IllegalStateException("GraphEdgeClipper.getCrossedVertexIndex called with " + a.size() + " vertex ids and " + b.size() + " crossing graph edges.");
            }
            int n = a.size();
            if (n == 1) {
                return 0;
            }
            if (b.firstAIndex() == b.lastAIndex()) {
                return b.firstAIndex();
            }
            boolean bReversed = this.getVertexRank(b.first()) > this.getVertexRank(b.last());
            int lo = -1;
            int hi = this.order.size();
            int bFirstEdgeId = -1;
            int bLastEdgeId = -1;
            for (Object e : b) {
                int ai = ((CrossingGraphEdge)e).aIndex;
                if (ai == 0) {
                    if (((CrossingGraphEdge)e).outgoing == bReversed || ((CrossingGraphEdge)e).otherVertexId == a.get(1)) continue;
                    bFirstEdgeId = ((CrossingGraphEdge)e).edgeId;
                    continue;
                }
                if (ai == n - 1) {
                    if (((CrossingGraphEdge)e).outgoing != bReversed || ((CrossingGraphEdge)e).otherVertexId == a.get(n - 2)) continue;
                    bLastEdgeId = ((CrossingGraphEdge)e).edgeId;
                    continue;
                }
                if (((CrossingGraphEdge)e).otherVertexId == a.get(ai - 1) || ((CrossingGraphEdge)e).otherVertexId == a.get(ai + 1)) continue;
                boolean onLeft = S2Predicates.orderedCCW(this.g.vertex(a.get(ai + 1)), this.g.vertex(((CrossingGraphEdge)e).otherVertexId), this.g.vertex(a.get(ai - 1)), this.g.vertex(a.get(ai)));
                if (leftToRight == onLeft) {
                    lo = Math.max(lo, this.rank[((CrossingGraphEdge)e).edgeId] + 1);
                    continue;
                }
                hi = Math.min(hi, this.rank[((CrossingGraphEdge)e).edgeId]);
            }
            if (bFirstEdgeId >= 0 && bLastEdgeId >= 0) {
                if (bReversed) {
                    int tmp = bFirstEdgeId;
                    bLastEdgeId = bFirstEdgeId;
                    bFirstEdgeId = tmp;
                }
                boolean hasInteriorVertex = false;
                for (CrossingGraphEdge e : b) {
                    if (e.aIndex <= 0 || e.aIndex >= n - 1 || this.rank[e.edgeId] < this.rank[bFirstEdgeId] || this.rank[e.edgeId] > this.rank[bLastEdgeId]) continue;
                    hasInteriorVertex = true;
                    break;
                }
                if (!hasInteriorVertex) {
                    boolean onLeft = this.edgeChainOnLeft(a, bFirstEdgeId, bLastEdgeId);
                    if (leftToRight == onLeft) {
                        lo = Math.max(lo, this.rank[bLastEdgeId] + 1);
                    } else {
                        hi = Math.min(hi, this.rank[bFirstEdgeId]);
                    }
                }
            }
            int best = -1;
            Preconditions.checkState((lo <= hi ? 1 : 0) != 0);
            for (CrossingGraphEdge e : b) {
                int ai = e.aIndex;
                int vrank = this.getVertexRank(e);
                if (vrank < lo || vrank > hi || best >= 0 && a.get(ai) >= a.get(best)) continue;
                best = ai;
            }
            return best;
        }

        private int getVertexRank(CrossingGraphEdge e) {
            return this.rank[e.edgeId] + (!e.outgoing ? 1 : 0);
        }

        private boolean edgeChainOnLeft(IntVector a, int bFirstEdgeId, int bLastEdgeId) {
            IntVector loop = new IntVector();
            for (int i = this.rank[bFirstEdgeId]; i < this.rank[bLastEdgeId]; ++i) {
                loop.push(this.g.edgeDstId(this.order.get(i)));
            }
            if (this.g.edgeDstId(bLastEdgeId) != a.get(0)) {
                loop.reverse();
            }
            loop.insert(loop.size(), a);
            for (int j = 0; j < 2; ++j) {
                loop.insert(loop.size(), loop.get(j));
            }
            double sum = 0.0;
            for (int i = 2; i < loop.size(); ++i) {
                sum += S2.turnAngle(this.g.vertex(loop.get(i - 2)), this.g.vertex(loop.get(i - 1)), this.g.vertex(loop.get(i)));
            }
            return sum > 0.0;
        }

        private static class CrossingInputEdgeVector
        extends ArrayList<CrossingInputEdge> {
            private CrossingInputEdgeVector() {
            }

            public int lowerBound(int inputEdgeId) {
                return S2ShapeUtil.lowerBound(0, this.size(), target -> ((CrossingInputEdge)this.get(target)).inputEdgeId() < inputEdgeId);
            }
        }
    }

    private static class CrossingGraphEdgeVectorVector {
        private CrossingGraphEdgeVector[] vectors = new CrossingGraphEdgeVector[32];
        private int size = 0;

        private CrossingGraphEdgeVectorVector() {
        }

        public int size() {
            return this.size;
        }

        public CrossingGraphEdgeVector get(int index) {
            return this.vectors[index];
        }

        public void addCrossingGraphEdge(int vectorIndex, int edgeId, int aIndex, boolean outgoing, int otherVertexId) {
            this.vectors[vectorIndex].add(new CrossingGraphEdge(edgeId, aIndex, outgoing, otherVertexId));
        }

        public void reinitialize(int size) {
            this.size = size;
            if (this.vectors.length < size) {
                this.vectors = Arrays.copyOf(this.vectors, size);
            }
            for (int v = 0; v < size; ++v) {
                if (this.vectors[v] == null) {
                    this.vectors[v] = new CrossingGraphEdgeVector();
                    continue;
                }
                this.vectors[v].clear();
            }
        }
    }

    private static class CrossingGraphEdgeVector
    extends ArrayList<CrossingGraphEdge> {
        private CrossingGraphEdgeVector() {
        }

        public CrossingGraphEdge first() {
            return (CrossingGraphEdge)this.get(0);
        }

        public CrossingGraphEdge last() {
            return (CrossingGraphEdge)this.get(this.size() - 1);
        }

        public int firstAIndex() {
            return ((CrossingGraphEdge)this.get((int)0)).aIndex;
        }

        public int lastAIndex() {
            return ((CrossingGraphEdge)this.get((int)(this.size() - 1))).aIndex;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.size(); ++i) {
                sb.append(this.get(i));
                if (i >= this.size() - 1) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
    }

    private static class CrossingGraphEdge {
        final int edgeId;
        final int aIndex;
        final boolean outgoing;
        final int otherVertexId;

        public CrossingGraphEdge(int edgeId, int aIndex, boolean outgoing, int otherVertexId) {
            this.edgeId = edgeId;
            this.aIndex = aIndex;
            this.outgoing = outgoing;
            this.otherVertexId = otherVertexId;
        }

        public String toString() {
            return Platform.formatString("CrossingGraphEdge(edgeId=%d, aIndex=%d, outgoing=%b, otherVertexId=%d)", this.edgeId, this.aIndex, this.outgoing, this.otherVertexId);
        }
    }

    private static class InputEdgeCrossings
    extends ArrayList<CrossingInputEdgePair> {
        private InputEdgeCrossings() {
        }
    }

    private static class CrossingInputEdgePair {
        private final int inputEdgeId;
        private final CrossingInputEdge crossingInputEdge;

        CrossingInputEdgePair(int inputEdgeId, CrossingInputEdge crossingInputEdge) {
            this.inputEdgeId = inputEdgeId;
            this.crossingInputEdge = crossingInputEdge;
        }

        public int first() {
            return this.inputEdgeId;
        }

        public CrossingInputEdge second() {
            return this.crossingInputEdge;
        }

        public String toString() {
            return Platform.formatString("CrossingInputEdgePair(%d, %s)", this.inputEdgeId, this.crossingInputEdge);
        }
    }

    private static class CrossingInputEdge {
        private final int inputEdgeId;
        private final boolean leftToRight;

        public CrossingInputEdge(int inputEdgeId, boolean leftToRight) {
            this.inputEdgeId = inputEdgeId;
            this.leftToRight = leftToRight;
        }

        public int inputEdgeId() {
            return this.inputEdgeId;
        }

        public boolean leftToRight() {
            return this.leftToRight;
        }

        public String toString() {
            if (this.inputEdgeId >= 0) {
                return Platform.formatString("CrossingInputEdge(%d, %s)", this.inputEdgeId, this.leftToRight);
            }
            switch (this.inputEdgeId) {
                case -3: {
                    return Platform.formatString("CrossingInputEdge(SET_REVERSE_A = %s", this.leftToRight);
                }
                case -2: {
                    return Platform.formatString("CrossingInputEdge(SET_INVERT_B = %s", this.leftToRight);
                }
                case -1: {
                    return Platform.formatString("CrossingInputEdge(SET_INSIDE = %s", this.leftToRight);
                }
            }
            throw new IllegalArgumentException("Unknown edgeId: " + this.inputEdgeId);
        }
    }

    public static class Builder {
        private Options options = new Options();

        public Builder() {
            this.options.snapFunction = Options.DEFAULT_SNAP_FUNCTION;
        }

        public Builder(S2Builder.SnapFunction snapFunction) {
            this.options.snapFunction = snapFunction;
        }

        public Builder(Options options) {
            this.options = options;
        }

        public Options options() {
            return new Options(this.options);
        }

        public S2BooleanOperation build(OpType opType, S2BuilderLayer layer0, S2BuilderLayer layer1, S2BuilderLayer layer2) {
            return new S2BooleanOperation(opType, (List<S2BuilderLayer>)ImmutableList.of((Object)layer0, (Object)layer1, (Object)layer2), this.options());
        }

        public S2BooleanOperation build(OpType opType, S2BuilderLayer layer) {
            return new S2BooleanOperation(opType, (List<S2BuilderLayer>)ImmutableList.of((Object)layer), this.options());
        }

        public String toString() {
            return "S2BooleanOperation.Builder{snapFunction=" + this.options.snapFunction() + ", polygonModel=" + this.options.polygonModel() + ", polylineModel=" + this.options.polylineModel() + ", polylineLoopsHaveBoundaries=" + this.options.polylineLoopsHaveBoundaries() + ", splitAllCrossingPolylineEdges=" + this.options.splitAllCrossingPolylineEdges() + "}";
        }

        @CanIgnoreReturnValue
        public Builder setSnapFunction(S2Builder.SnapFunction snapFunction) {
            this.options.snapFunction = snapFunction;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPolygonModel(PolygonModel model) {
            this.options.polygonModel = model;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPolylineModel(PolylineModel model) {
            this.options.polylineModel = model;
            return this;
        }

        public void setPolylineLoopsHaveBoundaries(boolean value) {
            this.options.polylineLoopsHaveBoundaries = value;
        }

        @CanIgnoreReturnValue
        public Builder setSplitAllCrossingPolylineEdges(boolean value) {
            this.options.splitAllCrossingPolylineEdges = value;
            return this;
        }
    }

    public static final class Options {
        private S2Builder.SnapFunction snapFunction;
        private PolygonModel polygonModel;
        private PolylineModel polylineModel;
        private boolean polylineLoopsHaveBoundaries;
        private boolean splitAllCrossingPolylineEdges;
        private final Precision precision;
        private final boolean conservativeOutput;
        public static final S2Builder.SnapFunction DEFAULT_SNAP_FUNCTION = new S2BuilderSnapFunctions.IdentitySnapFunction();
        public static final PolygonModel DEFAULT_POLYGON_MODEL = PolygonModel.SEMI_OPEN;
        public static final PolylineModel DEFAULT_POLYLINE_MODEL = PolylineModel.CLOSED;
        public static final boolean DEFAULT_POLYLINE_LOOPS_HAVE_BOUNDARIES = true;
        public static final boolean DEFAULT_SPLIT_ALL_CROSSING_POLYLINE_EDGES = false;
        public static final Precision DEFAULT_PRECISION = Precision.EXACT;
        public static final boolean DEFAULT_CONSERVATIVE_OUTPUT = false;
        public static final Options DEFAULT = new Options();

        public Options() {
            this.snapFunction = DEFAULT_SNAP_FUNCTION;
            this.polygonModel = DEFAULT_POLYGON_MODEL;
            this.polylineModel = DEFAULT_POLYLINE_MODEL;
            this.polylineLoopsHaveBoundaries = true;
            this.splitAllCrossingPolylineEdges = false;
            this.precision = DEFAULT_PRECISION;
            this.conservativeOutput = false;
        }

        Options(Options other) {
            this.snapFunction = other.snapFunction;
            this.polygonModel = other.polygonModel;
            this.polylineModel = other.polylineModel;
            this.polylineLoopsHaveBoundaries = other.polylineLoopsHaveBoundaries;
            this.splitAllCrossingPolylineEdges = other.splitAllCrossingPolylineEdges;
            this.precision = other.precision;
            this.conservativeOutput = other.conservativeOutput;
        }

        public S2Builder.SnapFunction snapFunction() {
            return this.snapFunction;
        }

        public PolygonModel polygonModel() {
            return this.polygonModel;
        }

        public PolylineModel polylineModel() {
            return this.polylineModel;
        }

        public boolean polylineLoopsHaveBoundaries() {
            return this.polylineLoopsHaveBoundaries;
        }

        public boolean splitAllCrossingPolylineEdges() {
            return this.splitAllCrossingPolylineEdges;
        }

        public Precision precision() {
            return this.precision;
        }

        public boolean conservativeOutput() {
            return this.conservativeOutput;
        }

        public String toString() {
            return "S2BooleanOperation.Options{snapFunction=" + this.snapFunction() + ", polygonModel=" + this.polygonModel() + ", polylineModel=" + this.polylineModel() + ", polylineLoopsHaveBoundaries=" + this.polylineLoopsHaveBoundaries() + ", splitAllCrossingPolylineEdges=" + this.splitAllCrossingPolylineEdges() + "}";
        }
    }

    private static class SourceId {
        private static final long REGION_MASK = Long.MIN_VALUE;
        private static final long SHAPE_MASK = -4294967296L;
        private static final long EDGE_MASK = 0xFFFFFFFFL;

        private SourceId() {
        }

        private static long encode(int regionId, int shapeId, int edgeId) {
            Preconditions.checkArgument((edgeId >= 0 ? 1 : 0) != 0);
            return (long)regionId << 63 | (long)shapeId << 32 | (long)edgeId;
        }

        public static int regionId(long encoded) {
            return (encoded & Long.MIN_VALUE) == 0L ? 0 : 1;
        }

        public static int shapeId(long encoded) {
            return (int)((encoded & 0xFFFFFFFF00000000L) >> 32);
        }

        public static int edgeId(long encoded) {
            return (int)(encoded & 0xFFFFFFFFL);
        }

        public static long special(int specialEdgeId) {
            Preconditions.checkArgument((specialEdgeId < 0 ? 1 : 0) != 0);
            return specialEdgeId;
        }
    }

    public static enum Precision {
        EXACT,
        SNAPPED;

    }

    public static enum PolylineModel {
        OPEN,
        SEMI_OPEN,
        CLOSED;

    }

    public static enum PolygonModel {
        OPEN,
        SEMI_OPEN,
        CLOSED;

    }

    public static enum OpType {
        UNION,
        INTERSECTION,
        DIFFERENCE,
        SYMMETRIC_DIFFERENCE;

    }
}

