/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.S1ChordAngle;
import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2CellRangeIterator;
import com.google.common.geometry.S2CellUnion;
import com.google.common.geometry.S2Iterator;
import com.google.common.geometry.S2ShapeIndex;
import com.google.common.primitives.UnsignedLongs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class S2CellIteratorJoin<E1 extends S2Iterator.Entry, E2 extends S2Iterator.Entry> {
    private final S2CellRangeIterator<E1> iterA;
    private final S2CellRangeIterator<E2> iterB;
    private final S1ChordAngle tolerance;
    private final List<S2Cell> matchedCells = new ArrayList<S2Cell>();
    int idx;
    S2Cell[] reusableChildCells = new S2Cell[4];
    static final int MAX_CROSS_PRODUCT = 25;
    static final int COVER_LIMIT = 12;

    public S2CellIteratorJoin(S2Iterator<E1> iteratorA, S2Iterator<E2> iteratorB) {
        this(iteratorA, iteratorB, S1ChordAngle.ZERO);
    }

    public S2CellIteratorJoin(S2Iterator<E1> iteratorA, S2Iterator<E2> iteratorB, S1ChordAngle tolerance) {
        this.iterA = S2CellRangeIterator.makeS2CellRangeIterator(iteratorA);
        this.iterB = S2CellRangeIterator.makeS2CellRangeIterator(iteratorB);
        this.tolerance = tolerance;
    }

    @CanIgnoreReturnValue
    public <V extends BiPredicate<S2CellRangeIterator<E1>, S2CellRangeIterator<E2>>> boolean join(V visitor) {
        if (this.tolerance.isZero()) {
            return this.exactJoin(visitor);
        }
        return this.tolerantJoin(visitor);
    }

    @CanIgnoreReturnValue
    public boolean simpleJoin(final Predicate<S2CellRangeIterator<E1>> leftResults) {
        return this.join(new BiPredicate<S2CellRangeIterator<E1>, S2CellRangeIterator<E2>>(){
            S2CellId lastId = S2CellId.SENTINEL;

            @Override
            public boolean test(S2CellRangeIterator<E1> left, S2CellRangeIterator<E2> right) {
                if (this.lastId.equals(left.id())) {
                    return true;
                }
                this.lastId = left.id();
                return leftResults.test(left);
            }
        });
    }

    private <V extends BiPredicate<S2CellRangeIterator<E1>, S2CellRangeIterator<E2>>> boolean exactJoin(V visitor) {
        this.iterA.begin();
        this.iterB.begin();
        block10: while (!this.iterA.done() && !this.iterB.done()) {
            int order = this.iterA.relation(this.iterB);
            switch (order) {
                case -1: {
                    this.iterA.seekTo(this.iterB);
                    continue block10;
                }
                case 1: {
                    this.iterB.seekTo(this.iterA);
                    continue block10;
                }
                case 0: {
                    if (!visitor.test(this.iterA, this.iterB)) {
                        return false;
                    }
                    long lsbA = this.iterA.id().lowestOnBit();
                    long lsbB = this.iterB.id().lowestOnBit();
                    int cmp = UnsignedLongs.compare((long)lsbA, (long)lsbB);
                    switch (cmp) {
                        case -1: {
                            this.iterA.next();
                            continue block10;
                        }
                        case 1: {
                            this.iterB.next();
                            continue block10;
                        }
                        case 0: {
                            this.iterA.next();
                            this.iterB.next();
                            continue block10;
                        }
                    }
                    throw new IllegalStateException("Unexpected compareUnsigned result: " + cmp);
                }
            }
            throw new IllegalStateException("Unexpected order: " + order);
        }
        return true;
    }

    private void coverCurrentPosition(S2CellRangeIterator<?> iter, S2CellUnion covering) {
        iter.restart();
        covering.clear();
        if (iter.done()) {
            return;
        }
        S2CellId min = iter.rangeMin();
        iter.finish();
        if (!iter.prev()) {
            return;
        }
        S2CellId max = iter.rangeMax();
        covering.initFromMinMax(min, max);
    }

    private <V extends BiPredicate<S2CellRangeIterator<E1>, S2CellRangeIterator<E2>>> boolean tolerantJoin(V visitor) {
        S2CellUnion coveringA = new S2CellUnion();
        S2CellUnion coveringB = new S2CellUnion();
        this.coverCurrentPosition(this.iterA, coveringA);
        this.coverCurrentPosition(this.iterB, coveringB);
        ArrayList<S2Cell> nearbyCells = new ArrayList<S2Cell>();
        for (S2CellId cellIdA : coveringA.cellIds()) {
            nearbyCells.clear();
            S2Cell cellA = new S2Cell(cellIdA);
            for (S2CellId cellIdB : coveringB.cellIds()) {
                S2Cell cellB = new S2Cell(cellIdB);
                if (!cellA.isDistanceLessOrEqual(cellB, this.tolerance)) continue;
                nearbyCells.add(cellB);
            }
            if (nearbyCells.isEmpty() || this.processCellPairs(cellA, nearbyCells, visitor)) continue;
            return false;
        }
        return true;
    }

    private <V extends BiPredicate<S2CellRangeIterator<E1>, S2CellRangeIterator<E2>>> boolean processNearby(S2Cell cellA, List<S2Cell> cellsB, V visitor) {
        ArrayList<S2Cell> nearbyCells = new ArrayList<S2Cell>();
        for (S2Cell cellB : cellsB) {
            if (!cellA.isDistanceLessOrEqual(cellB, this.tolerance)) continue;
            nearbyCells.add(cellB);
        }
        return nearbyCells.isEmpty() || this.processCellPairs(cellA, nearbyCells, visitor);
    }

    private <V extends BiPredicate<S2CellRangeIterator<E1>, S2CellRangeIterator<E2>>> boolean processNearbySubdivided(S2Cell cellA, List<S2Cell> cellsB, V visitor) {
        S2Cell[] childCells = new S2Cell[4];
        for (int i = 0; i < 4; ++i) {
            childCells[i] = new S2Cell();
        }
        cellA.subdivide(childCells);
        for (S2Cell childA : childCells) {
            if (this.processNearby(childA, cellsB, visitor)) continue;
            return false;
        }
        return true;
    }

    private <V extends BiPredicate<S2CellRangeIterator<E1>, S2CellRangeIterator<E2>>> boolean processCellPairs(S2Cell cellA, List<S2Cell> cellsB, V visitor) {
        int numCoveredA = S2CellIteratorJoin.estimateCoveredCells(this.iterA, cellA.id());
        if (numCoveredA == 0) {
            return true;
        }
        boolean subdivided = false;
        ArrayList<S2Cell> subdividedB = new ArrayList<S2Cell>();
        for (S2Cell cellB : cellsB) {
            int numCoveredB = S2CellIteratorJoin.estimateCoveredCells(this.iterB, cellB.id());
            if (numCoveredB == 0) continue;
            if (numCoveredB < 12) {
                subdividedB.add(cellB);
                continue;
            }
            this.appendChildren(cellB, subdividedB);
            subdivided = true;
        }
        if (numCoveredA >= 12 || subdivided) {
            return numCoveredA >= 12 ? this.processNearbySubdivided(cellA, subdividedB, visitor) : this.processNearby(cellA, subdividedB, visitor);
        }
        this.matchedCells.clear();
        for (S2Cell cellB : cellsB) {
            S2CellIteratorJoin.scanCellRange(this.iterB, cellB.id(), iter -> {
                this.matchedCells.add(new S2Cell(iter.id()));
                return true;
            });
        }
        return S2CellIteratorJoin.scanCellRange(this.iterA, cellA.id(), iterA -> {
            S2CellId id;
            if (!cellA.id().intersects(iterA.id().rangeMin())) {
                return true;
            }
            S2Cell subCellA = new S2Cell(iterA.id());
            this.idx = 0;
            boolean success = true;
            for (int i = 0; i < cellsB.size() && success; success &= S2CellIteratorJoin.scanCellRange(this.iterB, id, iterB -> !subCellA.isDistanceLessOrEqual(this.matchedCells.get(this.idx++), this.tolerance) || visitor.test(iterA, iterB)), ++i) {
                id = ((S2Cell)cellsB.get(i)).id();
            }
            return success;
        });
    }

    private void appendChildren(S2Cell cell, List<S2Cell> cells) {
        int i;
        for (i = 0; i < 4; ++i) {
            this.reusableChildCells[i] = new S2Cell();
        }
        cell.subdivide(this.reusableChildCells);
        for (i = 0; i < 4; ++i) {
            cells.add(this.reusableChildCells[i]);
        }
    }

    @CanIgnoreReturnValue
    private static <E extends S2Iterator.Entry, V extends Predicate<S2CellRangeIterator<E>>> boolean scanCellRange(S2CellRangeIterator<E> iter, S2CellId id, V visitor) {
        S2ShapeIndex.CellRelation unused = iter.locate(id);
        while (!iter.done() && iter.id().intersects(id)) {
            if (!visitor.test(iter)) {
                return false;
            }
            iter.next();
        }
        return true;
    }

    private static int estimateCoveredCells(S2Iterator<?> iter, S2CellId cell) {
        S2ShapeIndex.CellRelation relation = iter.locate(cell);
        switch (relation) {
            case DISJOINT: {
                return 0;
            }
            case INDEXED: {
                return 1;
            }
            case SUBDIVIDED: {
                S2CellId end = cell.rangeMax();
                int matches = 0;
                while (!iter.done() && iter.compareTo(end) <= 0) {
                    if (++matches > 12) {
                        return 12;
                    }
                    iter.next();
                }
                return matches;
            }
        }
        throw new IllegalStateException("Unexpected CellRelation: " + relation);
    }
}

