/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S2EdgeUtil;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Shape;
import com.google.common.geometry.S2ShapeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class S2ChainInterpolationQuery {
    private final S2Shape shape;
    private final ArrayList<S1Angle> cumulativeValues;
    private final int firstEdgeId;
    private final int lastEdgeId;
    private S2Point resultPoint;
    private int resultEdgeId;
    private S1Angle resultDistance;

    public S2ChainInterpolationQuery(S2Shape shape) {
        this(shape, -1);
    }

    public S2ChainInterpolationQuery(S2Shape shape, int chainId) {
        Preconditions.checkArgument((chainId < shape.numChains() ? 1 : 0) != 0);
        this.shape = shape;
        if (chainId >= 0) {
            this.firstEdgeId = shape.getChainStart(chainId);
            this.lastEdgeId = this.firstEdgeId + shape.getChainLength(chainId) - 1;
        } else {
            this.firstEdgeId = 0;
            this.lastEdgeId = shape.numEdges() - 1;
        }
        this.cumulativeValues = new ArrayList();
        S1Angle cumulativeAngle = S1Angle.ZERO;
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        for (int i = this.firstEdgeId; i <= this.lastEdgeId; ++i) {
            this.cumulativeValues.add(cumulativeAngle);
            shape.getEdge(i, edge);
            cumulativeAngle = cumulativeAngle.add(new S1Angle(edge.a, edge.b));
        }
        if (!this.cumulativeValues.isEmpty()) {
            this.cumulativeValues.add(cumulativeAngle);
        }
    }

    public S1Angle getLength() {
        return this.cumulativeValues.isEmpty() ? S1Angle.ZERO : (S1Angle)Iterables.getLast(this.cumulativeValues);
    }

    public S1Angle getLengthAtEdgeEnd(int edgeId) {
        if (this.cumulativeValues.isEmpty()) {
            return S1Angle.ZERO;
        }
        if (edgeId < this.firstEdgeId || edgeId > this.lastEdgeId) {
            return S1Angle.INFINITY;
        }
        return this.cumulativeValues.get(edgeId - this.firstEdgeId + 1);
    }

    public List<S2Point> slice(double a, double b) {
        ArrayList<S2Point> result = new ArrayList<S2Point>();
        this.addSlice(result, a, b);
        return result;
    }

    public void addSlice(List<S2Point> result, double a, double b) {
        boolean reverse;
        if (this.cumulativeValues.isEmpty()) {
            return;
        }
        int start = result.size();
        boolean bl = reverse = a > b;
        if (reverse) {
            double t = a;
            a = b;
            b = t;
        }
        Preconditions.checkArgument((boolean)this.findPointAtFraction(a), (String)"Invalid value of A %s", (Object)a);
        int startEdge = this.resultEdgeId();
        S2Point last = this.resultPoint();
        result.add(last);
        Preconditions.checkArgument((boolean)this.findPointAtFraction(b), (String)"Invalid value of B %s", (Object)b);
        int endEdge = this.resultEdgeId();
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        for (int id = startEdge; id < endEdge; ++id) {
            this.shape.getEdge(id, edge);
            if (last.equalsPoint(edge.b)) continue;
            last = edge.b;
            result.add(edge.b);
        }
        result.add(this.resultPoint());
        if (reverse) {
            Collections.reverse(result.subList(start, result.size()));
        }
    }

    public boolean findPoint(S1Angle distance) {
        if (this.cumulativeValues.isEmpty()) {
            return false;
        }
        int lowerBound = S2ShapeUtil.lowerBound(0, this.cumulativeValues.size(), i -> this.cumulativeValues.get(i).compareTo(distance) < 0);
        S2Shape.MutableEdge shapeEdge = new S2Shape.MutableEdge();
        if (lowerBound == 0) {
            this.shape.getEdge(this.firstEdgeId, shapeEdge);
            this.resultPoint = shapeEdge.getStart();
            this.resultEdgeId = this.firstEdgeId;
            this.resultDistance = this.cumulativeValues.get(0);
        } else if (lowerBound == this.cumulativeValues.size()) {
            this.shape.getEdge(this.lastEdgeId, shapeEdge);
            this.resultPoint = shapeEdge.getEnd();
            this.resultEdgeId = this.lastEdgeId;
            this.resultDistance = (S1Angle)Iterables.getLast(this.cumulativeValues);
        } else {
            this.resultEdgeId = lowerBound + this.firstEdgeId - 1;
            this.shape.getEdge(this.resultEdgeId, shapeEdge);
            this.resultDistance = distance;
            this.resultPoint = S2EdgeUtil.getPointOnLine(shapeEdge.getStart(), shapeEdge.getEnd(), distance.sub(this.cumulativeValues.get(lowerBound - 1)));
        }
        return true;
    }

    public boolean findPointAtFraction(double fraction) {
        return this.findPoint(this.getLength().mul(fraction));
    }

    public S2Point resultPoint() {
        return this.resultPoint;
    }

    public int resultEdgeId() {
        return this.resultEdgeId;
    }

    public S1Angle resultDistance() {
        return this.resultDistance;
    }
}

