/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.geometry.DistanceCollector;
import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S1ChordAngle;
import com.google.common.geometry.S1Distance;
import com.google.common.geometry.S2BestDistanceTarget;
import com.google.common.geometry.S2BestEdgesQueryBase;
import com.google.common.geometry.S2Cap;
import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2ContainsPointQuery;
import com.google.common.geometry.S2EdgeUtil;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Shape;
import com.google.common.geometry.S2ShapeIndex;
import com.google.common.geometry.S2ShapeIndexRegion;
import com.google.common.geometry.S2ShapeUtil;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

@CheckReturnValue
public abstract class S2ClosestEdgeQuery<D extends S1Distance<D>>
extends S2BestEdgesQueryBase<D> {
    S2ClosestEdgeQuery(S2BestEdgesQueryBase.Options<D> options) {
        super(options);
    }

    public List<S2BestEdgesQueryBase.Result<D>> findClosestEdges(S2BestDistanceTarget<D> target) {
        return this.findBestEdges(target);
    }

    public List<S2BestEdgesQueryBase.Result<D>> findClosestEdges(S2BestDistanceTarget<D> target, @Nullable S2BestEdgesQueryBase.ShapeFilter shapeFilter) {
        return this.findBestEdges(target, shapeFilter);
    }

    public void findClosestEdges(S2BestDistanceTarget<D> target, S2BestEdgesQueryBase.ResultVisitor<D> visitor) {
        this.findBestEdges(target, visitor);
    }

    public void findClosestEdges(S2BestDistanceTarget<D> target, @Nullable S2BestEdgesQueryBase.ShapeFilter shapeFilter, S2BestEdgesQueryBase.ResultVisitor<D> visitor) {
        this.findBestEdges(target, shapeFilter, visitor);
    }

    public Optional<S2BestEdgesQueryBase.Result<D>> findClosestEdge(S2BestDistanceTarget<D> target) {
        return this.findBestEdge(target);
    }

    public Optional<S2BestEdgesQueryBase.Result<D>> findClosestEdge(S2BestDistanceTarget<D> target, @Nullable S2BestEdgesQueryBase.ShapeFilter shapeFilter) {
        return this.findBestEdge(target, shapeFilter);
    }

    public D getDistance(S2BestDistanceTarget<D> target) {
        return this.getDistance(target, null);
    }

    public D getDistance(S2BestDistanceTarget<D> target, @Nullable S2BestEdgesQueryBase.ShapeFilter shapeFilter) {
        Optional<S2BestEdgesQueryBase.Result<D>> result = this.findBestEdge(target, shapeFilter);
        return result.isPresent() ? result.get().distance() : this.beyondWorstDistance();
    }

    public boolean isDistanceLess(S2BestDistanceTarget<D> target, D limit) {
        return this.isDistanceLess(target, limit, null);
    }

    public boolean isDistanceLess(S2BestDistanceTarget<D> target, D limit, S2BestEdgesQueryBase.ShapeFilter shapeFilter) {
        this.maxResults = 1;
        this.maxError = this.worstDistance();
        this.distanceLimit = limit;
        this.shapeFilter = shapeFilter;
        this.findBestEdgesInternal(target);
        this.shapeFilter = null;
        boolean result = this.bestResult != null;
        this.bestResult = null;
        return result;
    }

    public S2Point project(S2Point targetPoint, S2BestEdgesQueryBase.Result<D> result) {
        if (result.edgeId() < 0) {
            return targetPoint;
        }
        S2Shape.MutableEdge resultEdge = new S2Shape.MutableEdge();
        this.index.getShapes().get(result.shapeId()).getEdge(result.edgeId(), resultEdge);
        return S2EdgeUtil.getClosestPoint(targetPoint, resultEdge.getStart(), resultEdge.getEnd());
    }

    @VisibleForTesting
    @CanIgnoreReturnValue
    public boolean visitContainingShapes(Target<D> target, S2ContainsPointQuery.ShapeVisitor visitor) {
        return this.visitBestDistanceContainingShapes(target, visitor);
    }

    @Override
    @CanIgnoreReturnValue
    protected boolean visitBestDistanceContainingShapes(S2BestDistanceTarget<D> target, S2ContainsPointQuery.ShapeVisitor visitor) {
        S2ContainsPointQuery containsPointQuery = new S2ContainsPointQuery(this.index);
        return target.visitConnectedComponentPoints(targetPoint -> containsPointQuery.visitContainingShapes((S2Point)targetPoint, visitor));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ShapeIndexTarget<S1ChordAngle> createShapeIndexTarget(S2ShapeIndex index) {
        return new ShapeIndexTarget<S1ChordAngle>(index, new Builder());
    }

    public static class Query
    extends S2ClosestEdgeQuery<S1ChordAngle> {
        Query(S2BestEdgesQueryBase.Options<S1ChordAngle> options) {
            super(options);
        }

        Query(S2BestEdgesQueryBase.Options<S1ChordAngle> options, S2ShapeIndex index) {
            super(options);
            this.init(index);
        }

        public Builder toBuilder() {
            return new Builder(this.options());
        }

        @Override
        protected DistanceCollector<S1ChordAngle> newDistanceCollector() {
            return S1ChordAngle.minCollector();
        }

        @Override
        protected boolean atBestLimit(DistanceCollector<S1ChordAngle> distanceCollector) {
            return distanceCollector.distance().getLength2() <= 0.0;
        }

        @Override
        protected Comparator<S1ChordAngle> distanceComparator() {
            return (a, b) -> a.compareTo((S1ChordAngle)b);
        }

        @Override
        protected S1ChordAngle zeroDistance() {
            return S1ChordAngle.ZERO;
        }

        @Override
        protected S1ChordAngle bestDistance() {
            return S1ChordAngle.ZERO;
        }

        @Override
        protected S1ChordAngle worstDistance() {
            return S1ChordAngle.STRAIGHT;
        }

        @Override
        protected S1ChordAngle beyondWorstDistance() {
            return S1ChordAngle.INFINITY;
        }

        @Override
        protected S1ChordAngle errorBoundedDistance(S1ChordAngle value) {
            return S1ChordAngle.sub(value, (S1ChordAngle)this.maxError);
        }

        @Override
        protected S1ChordAngle searchCapRadius(S1ChordAngle targetCapRadius, S1ChordAngle maxDistance) {
            Preconditions.checkArgument((!targetCapRadius.isNegative() ? 1 : 0) != 0);
            Preconditions.checkArgument((!targetCapRadius.isInfinity() ? 1 : 0) != 0);
            Preconditions.checkArgument((!maxDistance.isNegative() ? 1 : 0) != 0);
            Preconditions.checkArgument((!maxDistance.isInfinity() ? 1 : 0) != 0);
            return S1ChordAngle.add(targetCapRadius, maxDistance.plusError(maxDistance.getS1AngleConstructorMaxError()));
        }

        public boolean isDistanceLessOrEqual(Target<S1ChordAngle> target, S1ChordAngle limit) {
            return this.isDistanceLessOrEqual(target, limit, null);
        }

        public boolean isDistanceLessOrEqual(Target<S1ChordAngle> target, S1ChordAngle limit, @Nullable S2BestEdgesQueryBase.ShapeFilter shapeFilter) {
            this.distanceLimit = limit.successor();
            this.maxResults = 1;
            this.maxError = this.worstDistance();
            this.shapeFilter = shapeFilter;
            this.findBestEdgesInternal(target);
            this.shapeFilter = null;
            boolean result = this.bestResult != null;
            this.bestResult = null;
            return result;
        }

        public boolean isConservativeDistanceLessOrEqual(Target<S1ChordAngle> target, S1ChordAngle limit) {
            return this.isConservativeDistanceLessOrEqual(target, limit, null);
        }

        public boolean isConservativeDistanceLessOrEqual(Target<S1ChordAngle> target, S1ChordAngle limit, @Nullable S2BestEdgesQueryBase.ShapeFilter shapeFilter) {
            this.distanceLimit = limit.plusError(S2EdgeUtil.getMinDistanceMaxError(limit)).successor();
            this.maxResults = 1;
            this.maxError = this.worstDistance();
            this.shapeFilter = shapeFilter;
            this.findBestEdgesInternal(target);
            this.shapeFilter = null;
            boolean result = this.bestResult != null;
            this.bestResult = null;
            return result;
        }
    }

    public static class Builder
    extends S2BestEdgesQueryBase.Builder<S1ChordAngle> {
        public Builder() {
            super(S1ChordAngle.INFINITY, S1ChordAngle.ZERO);
        }

        public Builder(S2BestEdgesQueryBase.Options<S1ChordAngle> options) {
            super(options);
        }

        public Query build() {
            return new Query(new S2BestEdgesQueryBase.Options<S1ChordAngle>(this));
        }

        public Query build(S2ShapeIndex index) {
            return new Query(new S2BestEdgesQueryBase.Options<S1ChordAngle>(this), index);
        }

        @CanIgnoreReturnValue
        public Builder setMaxResults(int maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxDistance(S1ChordAngle maxDistance) {
            this.distanceLimit = maxDistance;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxDistance(S1Angle maxDistance) {
            this.distanceLimit = S1ChordAngle.fromS1Angle(maxDistance);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInclusiveMaxDistance(S1ChordAngle maxDistance) {
            this.distanceLimit = maxDistance.successor();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInclusiveMaxDistance(S1Angle maxDistance) {
            this.setInclusiveMaxDistance(S1ChordAngle.fromS1Angle(maxDistance));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setConservativeMaxDistance(S1ChordAngle maxDistance) {
            this.distanceLimit = maxDistance.plusError(S2EdgeUtil.getMinDistanceMaxError(maxDistance)).successor();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setConservativeMaxDistance(S1Angle maxDistance) {
            this.setConservativeMaxDistance(S1ChordAngle.fromS1Angle(maxDistance));
            return this;
        }

        public S1ChordAngle maxDistance() {
            return (S1ChordAngle)this.distanceLimit;
        }

        @CanIgnoreReturnValue
        public Builder setMaxError(S1ChordAngle maxError) {
            this.maxError = maxError;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxError(S1Angle maxError) {
            this.maxError = S1ChordAngle.fromS1Angle(maxError);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setIncludeInteriors(boolean includeInteriors) {
            this.includeInteriors = includeInteriors;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUseBruteForce(boolean useBruteForce) {
            this.useBruteForce = useBruteForce;
            return this;
        }
    }

    public static class ShapeIndexTarget<D extends S1Distance<D>>
    extends S2BestEdgesQueryBase.ShapeIndexTarget<D>
    implements Target<D> {
        public ShapeIndexTarget(S2ShapeIndex index, S2BestEdgesQueryBase.Builder<D> queryBuilder) {
            super(index, queryBuilder);
        }

        @Override
        public int maxBruteForceIndexSize() {
            return 40;
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Point p, DistanceCollector<D> collector) {
            return this.updateBestDistance(new PointTarget(p), collector);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Point v0, S2Point v1, DistanceCollector<D> collector) {
            return this.updateBestDistance(new EdgeTarget(v0, v1), collector);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Cell cell, DistanceCollector<D> collector) {
            return this.updateBestDistance(new CellTarget(cell), collector);
        }

        @Override
        public S2Cap getCapBound() {
            int maxSize = 16;
            if (!this.index.isFresh() && S2ShapeUtil.countEdgesUpTo(this.index, maxSize) < maxSize) {
                S2Cap.Builder builder = new S2Cap.Builder();
                S2Shape.MutableEdge e = new S2Shape.MutableEdge();
                for (S2Shape shape : this.index.getShapes()) {
                    for (int i = 0; i < shape.numEdges(); ++i) {
                        shape.getEdge(i, e);
                        builder.add(e);
                    }
                }
                return builder.build();
            }
            return new S2ShapeIndexRegion(this.index).getCapBound();
        }
    }

    public static class CellTarget<D2 extends S1Distance<D2>>
    extends S2BestEdgesQueryBase.CellTarget<D2>
    implements Target<D2> {
        public static final int MAX_BRUTE_FORCE_INDEX_SIZE = 16;

        public CellTarget(S2Cell c) {
            super(c);
        }

        @Override
        public int maxBruteForceIndexSize() {
            return 16;
        }

        @Override
        public S2Cap getCapBound() {
            return this.cell.getCapBound();
        }
    }

    public static class EdgeTarget<D2 extends S1Distance<D2>>
    extends S2BestEdgesQueryBase.EdgeTarget<D2>
    implements Target<D2> {
        public EdgeTarget(S2Point a, S2Point b) {
            super(a, b);
        }

        @Override
        public int maxBruteForceIndexSize() {
            return 40;
        }

        @Override
        public S2Cap getCapBound() {
            double r2 = this.getHalfEdgeLength2();
            return S2Cap.fromAxisChord(this.a.add(this.b).normalize(), S1ChordAngle.fromLength2(r2));
        }
    }

    public static class PointTarget<D2 extends S1Distance<D2>>
    extends S2BestEdgesQueryBase.PointTarget<D2>
    implements Target<D2> {
        public PointTarget(S2Point p) {
            super(p);
        }

        @Override
        public int maxBruteForceIndexSize() {
            return 40;
        }

        @Override
        public S2Cap getCapBound() {
            return S2Cap.fromAxisChord(this.point, S1ChordAngle.ZERO);
        }
    }

    public static interface Target<D extends S1Distance<D>>
    extends S2BestDistanceTarget<D> {
    }
}

