/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2EdgeQuery;
import com.google.common.geometry.S2EdgeUtil;
import com.google.common.geometry.S2Iterator;
import com.google.common.geometry.S2PaddedCell;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2ShapeIndex;
import com.google.common.geometry.S2ShapeUtil;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;

public class S2CrossingEdgesQuery {
    private final CrossingType crossingType;
    private final int minCrossingSign;
    private final boolean needAdjacent;
    private final IndexCrosser abCrosser = new IndexCrosser();
    private final IndexCrosser baCrosser = new IndexCrosser();
    private final S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser();
    private final S2ShapeUtil.LoadedShape a = new S2ShapeUtil.LoadedShape();
    private final S2ShapeUtil.LoadedShape b = new S2ShapeUtil.LoadedShape();
    private S2CellId currentId = S2CellId.sentinel();

    public S2CellId currentId() {
        return this.currentId;
    }

    public S2CrossingEdgesQuery(CrossingType type) {
        this(type, type == CrossingType.ALL);
    }

    public S2CrossingEdgesQuery(CrossingType type, boolean needAdjacent) {
        this.crossingType = type;
        this.needAdjacent = needAdjacent;
        this.minCrossingSign = type == CrossingType.INTERIOR ? 1 : 0;
    }

    @CanIgnoreReturnValue
    public boolean visitCrossingEdgePairs(S2ShapeIndex index, EdgePairVisitor visitor) {
        this.a.init(index);
        this.b.init(index);
        return this.visitCrossings(index, visitor);
    }

    @CanIgnoreReturnValue
    public boolean visitCrossingEdgePairs(S2ShapeIndex aIndex, S2ShapeIndex bIndex, EdgePairVisitor visitor) {
        this.a.init(aIndex);
        this.b.init(bIndex);
        S2ShapeUtil.RangeIterator<S2ShapeIndex.Cell> ai = new S2ShapeUtil.RangeIterator<S2ShapeIndex.Cell>(aIndex.iterator());
        S2ShapeUtil.RangeIterator<S2ShapeIndex.Cell> bi = new S2ShapeUtil.RangeIterator<S2ShapeIndex.Cell>(bIndex.iterator());
        this.abCrosser.init(aIndex, bIndex, this.crossingType, visitor, false);
        this.baCrosser.init(bIndex, aIndex, this.crossingType, visitor, true);
        while (!ai.done() || !bi.done()) {
            if (ai.rangeMax().lessThan(bi.rangeMin())) {
                ai.seekTo(bi);
                continue;
            }
            if (bi.rangeMax().lessThan(ai.rangeMin())) {
                bi.seekTo(ai);
                continue;
            }
            long abRelation = ai.id().lowestOnBit() - bi.id().lowestOnBit();
            if (abRelation > 0L) {
                this.currentId = bi.id();
                if (this.abCrosser.visitCrossings(ai, bi)) continue;
                return false;
            }
            if (abRelation < 0L) {
                this.currentId = ai.id();
                if (this.baCrosser.visitCrossings(bi, ai)) continue;
                return false;
            }
            if (ai.iterator().entry().numEdges() > 0 && bi.iterator().entry().numEdges() > 0) {
                this.currentId = ai.id();
                if (!this.abCrosser.visitCellCellCrossings(ai.iterator().entry(), bi.iterator().entry())) {
                    return false;
                }
            }
            ai.next();
            bi.next();
        }
        this.currentId = S2CellId.sentinel();
        return true;
    }

    private boolean visitCrossings(S2ShapeIndex index, EdgePairVisitor visitor) {
        S2Iterator.ListIterator<S2ShapeIndex.Cell> it = index.iterator();
        while (!it.done()) {
            this.currentId = it.id();
            if (!this.visitCellCrossings((S2ShapeIndex.Cell)it.entry(), visitor)) {
                return false;
            }
            it.next();
        }
        this.currentId = S2CellId.sentinel();
        return true;
    }

    private boolean visitCellCrossings(S2ShapeIndex.Cell cell, EdgePairVisitor visitor) {
        for (int aShapeNum = 0; aShapeNum < cell.numShapes(); ++aShapeNum) {
            this.a.load(cell.clipped(aShapeNum));
            for (int bShapeNum = aShapeNum; bShapeNum < cell.numShapes(); ++bShapeNum) {
                this.b.load(cell.clipped(bShapeNum));
                for (int ai = 0; ai < this.a.size(); ++ai) {
                    int bi;
                    S2Point aSrc = this.a.srcs.get(ai);
                    S2Point aDst = this.a.dsts.get(ai);
                    int aId = this.a.ids[ai];
                    this.crosser.init(aSrc, aDst);
                    int n = bi = aShapeNum == bShapeNum ? ai + 1 : 0;
                    while (bi < this.b.size()) {
                        int sign;
                        S2Point bSrc = this.b.srcs.get(bi);
                        S2Point bDst = this.b.dsts.get(bi);
                        int bId = this.b.ids[bi];
                        if (!(!this.needAdjacent && aDst.equalsPoint(bSrc) || (sign = this.crosser.robustCrossing(bSrc, bDst)) < this.minCrossingSign || visitor.visit(this.a.shapeId, aId, aSrc, aDst, this.b.shapeId, bId, bSrc, bDst, sign == 1))) {
                            return false;
                        }
                        ++bi;
                    }
                }
            }
        }
        return true;
    }

    private static class IndexCrosser {
        private EdgePairVisitor visitor;
        private int minCrossingSign;
        private boolean swapped;
        private S2EdgeQuery bQuery;
        private final S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser();
        private final ArrayList<S2ShapeIndex.Cell> bCells = new ArrayList();
        private final S2ShapeUtil.LoadedShape a = new S2ShapeUtil.LoadedShape();
        private final S2ShapeUtil.LoadedShape b = new S2ShapeUtil.LoadedShape();

        public void init(S2ShapeIndex aIndex, S2ShapeIndex bIndex, CrossingType type, EdgePairVisitor visitor, boolean swapped) {
            this.a.init(aIndex);
            this.b.init(bIndex);
            this.visitor = visitor;
            this.minCrossingSign = type == CrossingType.INTERIOR ? 1 : 0;
            this.swapped = swapped;
            this.bQuery = new S2EdgeQuery(bIndex);
        }

        private boolean visitEdgePair(int aShapeId, int aEdgeId, S2Point aEdgeSrc, S2Point aEdgeDst, int bShapeId, int bEdgeId, S2Point bEdgeSrc, S2Point bEdgeDst, boolean isInterior) {
            if (this.swapped) {
                return this.visitor.visit(bShapeId, bEdgeId, bEdgeSrc, bEdgeDst, aShapeId, aEdgeId, aEdgeSrc, aEdgeDst, isInterior);
            }
            return this.visitor.visit(aShapeId, aEdgeId, aEdgeSrc, aEdgeDst, bShapeId, bEdgeId, bEdgeSrc, bEdgeDst, isInterior);
        }

        private boolean visitLoadedShapeCrossings() {
            for (int ai = 0; ai < this.a.srcs.size(); ++ai) {
                int aId = this.a.ids[ai];
                S2Point aSrc = this.a.srcs.get(ai);
                S2Point aDst = this.a.dsts.get(ai);
                this.crosser.init(aSrc, aDst);
                for (int bi = 0; bi < this.b.srcs.size(); ++bi) {
                    S2Point bDst;
                    int bId = this.b.ids[bi];
                    S2Point bSrc = this.b.srcs.get(bi);
                    int sign = this.crosser.robustCrossing(bSrc, bDst = this.b.dsts.get(bi));
                    if (sign < this.minCrossingSign || this.visitEdgePair(this.a.shapeId, aId, aSrc, aDst, this.b.shapeId, bId, bSrc, bDst, sign == 1)) continue;
                    return false;
                }
            }
            return true;
        }

        @CanIgnoreReturnValue
        public boolean visitCrossings(S2ShapeUtil.RangeIterator<S2ShapeIndex.Cell> ai, S2ShapeUtil.RangeIterator<S2ShapeIndex.Cell> bi) {
            Preconditions.checkArgument((boolean)ai.id().contains(bi.id()));
            if (ai.entry().numEdges() == 0) {
                bi.seekBeyond(ai);
            } else {
                int kEdgeQueryMinEdges = 23;
                int bEdges = 0;
                this.bCells.clear();
                do {
                    int cellEdges;
                    if ((cellEdges = bi.entry().numEdges()) > 0) {
                        if ((bEdges += cellEdges) >= 23) {
                            if (!this.visitSubcellCrossings(ai.entry(), ai.id())) {
                                return false;
                            }
                            bi.seekBeyond(ai);
                            return true;
                        }
                        this.bCells.add(bi.entry());
                    }
                    bi.next();
                } while (bi.id().lessOrEquals(ai.rangeMax()));
                if (!this.bCells.isEmpty() && !this.visitCellCellsCrossings(ai.entry(), this.bCells)) {
                    return false;
                }
            }
            ai.next();
            return true;
        }

        private boolean visitSubcellCrossings(S2ShapeIndex.Cell aCell, S2CellId bId) {
            S2PaddedCell bRoot = new S2PaddedCell(bId, 0.0);
            for (int aShapeNum = 0; aShapeNum < aCell.numShapes(); ++aShapeNum) {
                S2ShapeIndex.S2ClippedShape aClippedShape = aCell.clipped(aShapeNum);
                this.a.load(aClippedShape);
                if (this.a.visit((shapeId, edgeId, src, dst) -> {
                    this.bCells.clear();
                    this.bQuery.getCells(src, dst, bRoot, this.bCells);
                    for (S2ShapeIndex.Cell bCell : this.bCells) {
                        if (this.visitEdgeCellCrossings(shapeId, edgeId, src, dst, bCell)) continue;
                        return false;
                    }
                    return true;
                })) continue;
                return false;
            }
            return true;
        }

        private boolean visitEdgeCellCrossings(int aShapeId, int aEdgeId, S2Point aSrc, S2Point aDst, S2ShapeIndex.Cell bCell) {
            this.crosser.init(aSrc, aDst);
            for (int bShapeNum = 0; bShapeNum < bCell.numShapes(); ++bShapeNum) {
                S2ShapeIndex.S2ClippedShape bClippedShape = bCell.clipped(bShapeNum);
                this.b.load(bClippedShape);
                if (this.b.visit((bShapeId, bEdgeId, bSrc, bDst) -> {
                    int sign = this.crosser.robustCrossing(bSrc, bDst);
                    return sign < this.minCrossingSign || this.visitEdgePair(aShapeId, aEdgeId, aSrc, aDst, bShapeId, bEdgeId, bSrc, bDst, sign == 1);
                })) continue;
                return false;
            }
            return true;
        }

        private boolean visitCellCellsCrossings(S2ShapeIndex.Cell aCell, List<S2ShapeIndex.Cell> bCells) {
            for (int aShapeNum = 0; aShapeNum < aCell.numShapes(); ++aShapeNum) {
                this.a.load(aCell.clipped(aShapeNum));
                for (S2ShapeIndex.Cell bCell : bCells) {
                    for (int bShapeNum = 0; bShapeNum < bCell.numShapes(); ++bShapeNum) {
                        this.b.load(bCell.clipped(bShapeNum));
                        if (this.visitLoadedShapeCrossings()) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        private boolean visitCellCellCrossings(S2ShapeIndex.Cell aCell, S2ShapeIndex.Cell bCell) {
            for (int aShapeNum = 0; aShapeNum < aCell.numShapes(); ++aShapeNum) {
                this.a.load(aCell.clipped(aShapeNum));
                for (int bShapeNum = 0; bShapeNum < bCell.numShapes(); ++bShapeNum) {
                    this.b.load(bCell.clipped(bShapeNum));
                    if (this.visitLoadedShapeCrossings()) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static interface EdgePairVisitor {
        public boolean visit(int var1, int var2, S2Point var3, S2Point var4, int var5, int var6, S2Point var7, S2Point var8, boolean var9);
    }

    public static enum CrossingType {
        INTERIOR,
        ALL;

    }
}

