/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.S2Shape;
import com.google.common.geometry.S2ShapeIndex;

public final class S2EdgeIterator {
    private final S2ShapeIndex index;
    private int shapeId = -1;
    private int edgeId = -1;
    private int numEdges = 0;

    public S2EdgeIterator(S2ShapeIndex index) {
        this.index = index;
        this.next();
    }

    public S2EdgeIterator(S2EdgeIterator other) {
        this.index = other.index;
        this.shapeId = other.shapeId;
        this.edgeId = other.edgeId;
        this.numEdges = other.numEdges;
    }

    public int shapeId() {
        return this.shapeId;
    }

    public int edgeId() {
        return this.edgeId;
    }

    public void getEdge(S2Shape.MutableEdge edge) {
        this.index.getShapes().get(this.shapeId).getEdge(this.edgeId, edge);
    }

    public boolean done() {
        return this.shapeId >= this.index.getShapes().size();
    }

    public boolean isEqualTo(S2EdgeIterator other) {
        return this.index == other.index && this.shapeId == other.shapeId && this.edgeId == other.edgeId;
    }

    public void next() {
        while (++this.edgeId >= this.numEdges && ++this.shapeId < this.index.getShapes().size()) {
            S2Shape shape = this.index.getShapes().get(this.shapeId);
            this.numEdges = shape == null ? 0 : shape.numEdges();
            this.edgeId = -1;
        }
    }
}

