/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.collect.Iterables;
import com.google.common.geometry.Projection;
import com.google.common.geometry.R2Vector;
import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S1ChordAngle;
import com.google.common.geometry.S2;
import com.google.common.geometry.S2EdgeUtil;
import com.google.common.geometry.S2Point;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.List;
import java.util.function.Consumer;

@CheckReturnValue
public final class S2EdgeTessellator {
    private static final double INTERPOLATION_FRACTION = 0.31215691082248315;
    private static final double SCALE_FACTOR = 0.8382999256988851;
    public static final S1Angle MIN_TOLERANCE = S1Angle.radians(1.0E-13);
    private final Projection projection;
    private final S1ChordAngle scaledTolerance;

    public S2EdgeTessellator(Projection projection, S1Angle tolerance) {
        this.projection = projection;
        this.scaledTolerance = S1ChordAngle.fromS1Angle(S1Angle.max(MIN_TOLERANCE, tolerance).mul(0.8382999256988851));
    }

    public void appendProjected(S2Point a, S2Point b, List<R2Vector> vertices) {
        R2Vector pa = this.projection.project(a);
        if (vertices.isEmpty()) {
            vertices.add(pa);
        } else {
            pa = this.projection.wrapDestination((R2Vector)Iterables.getLast(vertices), pa);
            assert (vertices.get(vertices.size() - 1).equals(pa)) : "Appended edges must form a chain";
        }
        R2Vector pb = this.projection.project(b);
        this.appendProjectedHelper(pa, a, pb, b, vertices::add);
    }

    public void appendUnprojected(R2Vector pa, R2Vector pb, List<S2Point> vertices) {
        S2Point a = this.projection.unproject(pa);
        S2Point b = this.projection.unproject(pb);
        if (vertices.isEmpty()) {
            vertices.add(a);
        } else assert (S2.approxEquals(vertices.get(vertices.size() - 1), a)) : "Appended edges must form a chain";
        this.appendUnprojectedHelper(pa, a, pb, b, vertices::add);
    }

    private void appendProjectedHelper(R2Vector pa, S2Point a, R2Vector pbIn, S2Point b, Consumer<R2Vector> vertexAdder) {
        R2Vector pb = this.projection.wrapDestination(pa, pbIn);
        if (this.estimateMaxError(pa, a, pb, b).lessOrEquals(this.scaledTolerance)) {
            vertexAdder.accept(pb);
        } else {
            S2Point mid = a.add(b).normalize();
            R2Vector projectedMid = this.projection.wrapDestination(pa, this.projection.project(mid));
            this.appendProjectedHelper(pa, a, projectedMid, mid, vertexAdder);
            this.appendProjectedHelper(projectedMid, mid, pb, b, vertexAdder);
        }
    }

    private void appendUnprojectedHelper(R2Vector pa, S2Point a, R2Vector pbIn, S2Point b, Consumer<S2Point> vertexAdder) {
        R2Vector pb = this.projection.wrapDestination(pa, pbIn);
        if (this.estimateMaxError(pa, a, pb, b).lessOrEquals(this.scaledTolerance)) {
            vertexAdder.accept(b);
        } else {
            R2Vector projectedMid = Projection.interpolate(0.5, pa, pb);
            S2Point mid = this.projection.unproject(projectedMid);
            this.appendUnprojectedHelper(pa, a, projectedMid, mid, vertexAdder);
            this.appendUnprojectedHelper(projectedMid, mid, pb, b, vertexAdder);
        }
    }

    private S1ChordAngle estimateMaxError(R2Vector pa, S2Point a, R2Vector pb, S2Point b) {
        if (a.dotProd(b) < -1.0E-14) {
            return S1ChordAngle.INFINITY;
        }
        double t1 = 0.31215691082248315;
        double t2 = 0.6878430891775169;
        S2Point mid1 = S2EdgeUtil.interpolate(t1, a, b);
        S2Point mid2 = S2EdgeUtil.interpolate(t2, a, b);
        S2Point projectedMid1 = this.projection.unproject(Projection.interpolate(t1, pa, pb));
        S2Point projectedMid2 = this.projection.unproject(Projection.interpolate(t2, pa, pb));
        S1ChordAngle mid1Angle = new S1ChordAngle(mid1, projectedMid1);
        S1ChordAngle mid2Angle = new S1ChordAngle(mid2, projectedMid2);
        return S1ChordAngle.max(mid1Angle, mid2Angle);
    }
}

