/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Strings;
import jsinterop.annotations.JsType;

@JsType
public class S2Error {
    private Code code = Code.NO_ERROR;
    private String text = "";

    public void clear() {
        this.code = Code.NO_ERROR;
        this.text = "";
    }

    public void init(Code code, String format, Object ... args) {
        this.code = code;
        format = format.replace("%d", "%s");
        this.text = Strings.lenientFormat((String)format, (Object[])args);
    }

    public Code code() {
        return this.code;
    }

    public boolean ok() {
        return this.code == Code.NO_ERROR;
    }

    public String text() {
        return this.text;
    }

    public String toString() {
        if (this.code == Code.NO_ERROR) {
            return "OK";
        }
        return Strings.lenientFormat((String)"%s: %s", (Object[])new Object[]{this.code, this.text});
    }

    @JsType
    public static enum Code {
        NO_ERROR(0),
        UNKNOWN(1000),
        UNIMPLEMENTED(1001),
        OUT_OF_RANGE(1002),
        INVALID_ARGUMENT(1003),
        FAILED_PRECONDITION(1004),
        INTERNAL(1005),
        DATA_LOSS(1006),
        RESOURCE_EXHAUSTED(1007),
        CANCELLED(1008),
        NOT_UNIT_LENGTH(1),
        DUPLICATE_VERTICES(2),
        ANTIPODAL_VERTICES(3),
        NOT_CONTINUOUS(4),
        INVALID_VERTEX(5),
        LOOP_NOT_ENOUGH_VERTICES(100),
        LOOP_SELF_INTERSECTION(101),
        POLYGON_LOOPS_SHARE_EDGE(200),
        POLYGON_LOOPS_CROSS(201),
        POLYGON_EMPTY_LOOP(202),
        POLYGON_EXCESS_FULL_LOOP(203),
        POLYGON_INCONSISTENT_LOOP_ORIENTATIONS(204),
        POLYGON_INVALID_LOOP_DEPTH(205),
        POLYGON_INVALID_LOOP_NESTING(206),
        INVALID_DIMENSION(207),
        SPLIT_INTERIOR(208),
        OVERLAPPING_GEOMETRY(209),
        BUILDER_SNAP_RADIUS_TOO_SMALL(300),
        BUILDER_MISSING_EXPECTED_SIBLING_EDGES(301),
        BUILDER_UNEXPECTED_DEGENERATE_EDGE(302),
        BUILDER_EDGES_DO_NOT_FORM_LOOPS(303),
        BUILDER_EDGES_DO_NOT_FORM_POLYLINE(304),
        BUILDER_IS_FULL_PREDICATE_NOT_SPECIFIED(305),
        USER_DEFINED_START(1000000),
        USER_DEFINED_END(9999999);

        private final int code;

        private Code(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }
    }
}

