/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.geometry.DistanceCollector;
import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S1ChordAngle;
import com.google.common.geometry.S1Distance;
import com.google.common.geometry.S2BestDistanceTarget;
import com.google.common.geometry.S2BestEdgesQueryBase;
import com.google.common.geometry.S2Cap;
import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2ContainsPointQuery;
import com.google.common.geometry.S2EdgeUtil;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Shape;
import com.google.common.geometry.S2ShapeIndex;
import com.google.common.geometry.S2ShapeIndexRegion;
import com.google.common.geometry.S2ShapeUtil;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

@CheckReturnValue
public abstract class S2FurthestEdgeQuery<D extends S1Distance<D>>
extends S2BestEdgesQueryBase<D> {
    S2FurthestEdgeQuery(S2BestEdgesQueryBase.Options<D> options) {
        super(options);
    }

    public List<S2BestEdgesQueryBase.Result<D>> findFurthestEdges(S2BestDistanceTarget<D> target) {
        return this.findBestEdges(target);
    }

    public void findFurthestEdges(S2BestDistanceTarget<D> target, S2BestEdgesQueryBase.ResultVisitor<D> visitor) {
        this.findBestEdges(target, visitor);
    }

    public Optional<S2BestEdgesQueryBase.Result<D>> findFurthestEdge(S2BestDistanceTarget<D> target) {
        return this.findBestEdge(target);
    }

    public D getDistance(S2BestDistanceTarget<D> target) {
        Optional<S2BestEdgesQueryBase.Result<D>> result = this.findBestEdge(target);
        return result.isPresent() ? result.get().distance() : this.beyondWorstDistance();
    }

    public boolean isDistanceGreater(S2BestDistanceTarget<D> target, D limit) {
        this.maxResults = 1;
        this.maxError = this.worstDistance();
        this.distanceLimit = limit;
        this.findBestEdgesInternal(target);
        boolean result = this.bestResult != null;
        this.bestResult = null;
        return result;
    }

    @VisibleForTesting
    @CanIgnoreReturnValue
    public boolean visitAntipodalShapes(Target<D> target, S2ContainsPointQuery.ShapeVisitor visitor) {
        return this.visitBestDistanceContainingShapes(target, visitor);
    }

    @Override
    @CanIgnoreReturnValue
    protected boolean visitBestDistanceContainingShapes(S2BestDistanceTarget<D> target, S2ContainsPointQuery.ShapeVisitor visitor) {
        S2ContainsPointQuery containsPointQuery = new S2ContainsPointQuery(this.index);
        return target.visitConnectedComponentPoints(targetPoint -> containsPointQuery.visitContainingShapes(targetPoint.neg(), visitor));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ShapeIndexTarget<S1ChordAngle> createShapeIndexTarget(S2ShapeIndex index) {
        return new ShapeIndexTarget<S1ChordAngle>(index, new Builder());
    }

    public static class Query
    extends S2FurthestEdgeQuery<S1ChordAngle> {
        Query(S2BestEdgesQueryBase.Options<S1ChordAngle> options) {
            super(options);
        }

        Query(S2BestEdgesQueryBase.Options<S1ChordAngle> options, S2ShapeIndex index) {
            super(options);
            this.init(index);
        }

        public Builder toBuilder() {
            return new Builder(this.options());
        }

        @Override
        protected DistanceCollector<S1ChordAngle> newDistanceCollector() {
            return S1ChordAngle.maxCollector();
        }

        @Override
        protected boolean atBestLimit(DistanceCollector<S1ChordAngle> distanceCollector) {
            return distanceCollector.distance().getLength2() >= 4.0;
        }

        @Override
        protected Comparator<S1ChordAngle> distanceComparator() {
            return (a, b) -> b.compareTo((S1ChordAngle)a);
        }

        @Override
        protected S1ChordAngle zeroDistance() {
            return S1ChordAngle.ZERO;
        }

        @Override
        protected S1ChordAngle bestDistance() {
            return S1ChordAngle.STRAIGHT;
        }

        @Override
        protected S1ChordAngle worstDistance() {
            return S1ChordAngle.ZERO;
        }

        @Override
        protected S1ChordAngle beyondWorstDistance() {
            return S1ChordAngle.NEGATIVE;
        }

        @Override
        protected S1ChordAngle errorBoundedDistance(S1ChordAngle value) {
            return S1ChordAngle.add(value, (S1ChordAngle)this.maxError);
        }

        @Override
        protected S1ChordAngle searchCapRadius(S1ChordAngle antipodalCapRadius, S1ChordAngle minDistance) {
            Preconditions.checkArgument((!antipodalCapRadius.isNegative() ? 1 : 0) != 0);
            Preconditions.checkArgument((!antipodalCapRadius.isInfinity() ? 1 : 0) != 0);
            Preconditions.checkArgument((!minDistance.isNegative() ? 1 : 0) != 0);
            Preconditions.checkArgument((!minDistance.isInfinity() ? 1 : 0) != 0);
            return S1ChordAngle.add(antipodalCapRadius, S1ChordAngle.sub(S1ChordAngle.STRAIGHT, minDistance));
        }

        public boolean isDistanceGreaterOrEqual(Target<S1ChordAngle> target, S1ChordAngle limit) {
            this.distanceLimit = limit.predecessor();
            this.maxResults = 1;
            this.maxError = this.worstDistance();
            this.findBestEdgesInternal(target);
            boolean result = this.bestResult != null;
            this.bestResult = null;
            return result;
        }

        public boolean isConservativeDistanceGreaterOrEqual(Target<S1ChordAngle> target, S1ChordAngle limit) {
            this.distanceLimit = limit.plusError(-S2EdgeUtil.getMinDistanceMaxError(limit)).predecessor();
            this.maxResults = 1;
            this.maxError = this.worstDistance();
            this.findBestEdgesInternal(target);
            boolean result = this.bestResult != null;
            this.bestResult = null;
            return result;
        }
    }

    public static class Builder
    extends S2BestEdgesQueryBase.Builder<S1ChordAngle> {
        public Builder() {
            super(S1ChordAngle.ZERO, S1ChordAngle.ZERO);
        }

        public Builder(S2BestEdgesQueryBase.Options<S1ChordAngle> options) {
            super(options);
        }

        public Query build() {
            return new Query(new S2BestEdgesQueryBase.Options<S1ChordAngle>(this));
        }

        public Query build(S2ShapeIndex index) {
            return new Query(new S2BestEdgesQueryBase.Options<S1ChordAngle>(this), index);
        }

        @CanIgnoreReturnValue
        public Builder setMaxResults(int maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMinDistance(S1ChordAngle minDistance) {
            this.distanceLimit = minDistance;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMinDistance(S1Angle minDistance) {
            this.distanceLimit = S1ChordAngle.fromS1Angle(minDistance);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInclusiveMinDistance(S1ChordAngle minDistance) {
            this.distanceLimit = minDistance.predecessor();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInclusiveMinDistance(S1Angle minDistance) {
            this.setInclusiveMinDistance(S1ChordAngle.fromS1Angle(minDistance));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setConservativeMinDistance(S1ChordAngle minDistance) {
            this.distanceLimit = minDistance.plusError(-S2EdgeUtil.getMinDistanceMaxError(minDistance)).predecessor();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setConservativeMinDistance(S1Angle minDistance) {
            this.setConservativeMinDistance(S1ChordAngle.fromS1Angle(minDistance));
            return this;
        }

        public S1ChordAngle minDistance() {
            return (S1ChordAngle)this.distanceLimit;
        }

        @CanIgnoreReturnValue
        public Builder setMaxError(S1ChordAngle maxError) {
            this.maxError = maxError;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxError(S1Angle maxError) {
            this.maxError = S1ChordAngle.fromS1Angle(maxError);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setIncludeInteriors(boolean includeInteriors) {
            this.includeInteriors = includeInteriors;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUseBruteForce(boolean useBruteForce) {
            this.useBruteForce = useBruteForce;
            return this;
        }
    }

    public static class ShapeIndexTarget<D extends S1Distance<D>>
    extends S2BestEdgesQueryBase.ShapeIndexTarget<D>
    implements Target<D> {
        public ShapeIndexTarget(S2ShapeIndex index, S2BestEdgesQueryBase.Builder<D> queryBuilder) {
            super(index, queryBuilder);
        }

        @Override
        public int maxBruteForceIndexSize() {
            return 32;
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Point p, DistanceCollector<D> collector) {
            return this.updateBestDistance(new PointTarget(p), collector);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Point v0, S2Point v1, DistanceCollector<D> collector) {
            return this.updateBestDistance(new EdgeTarget(v0, v1), collector);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Cell cell, DistanceCollector<D> collector) {
            return this.updateBestDistance(new CellTarget(cell), collector);
        }

        @Override
        public S2Cap getCapBound() {
            if (this.index.isFresh() || S2ShapeUtil.countEdgesUpTo(this.index, 96) >= 96) {
                S2Cap cap = new S2ShapeIndexRegion(this.index).getCapBound();
                return S2Cap.fromAxisChord(cap.axis().neg(), cap.radius());
            }
            S2Cap.Builder builder = new S2Cap.Builder();
            S2Shape.MutableEdge e = new S2Shape.MutableEdge();
            for (S2Shape shape : this.index.getShapes()) {
                for (int i = 0; i < shape.numEdges(); ++i) {
                    shape.getEdge(i, e);
                    builder.add(e);
                }
            }
            S2Cap cap = builder.build();
            return S2Cap.fromAxisChord(cap.axis().neg(), cap.radius());
        }
    }

    public static class CellTarget<D2 extends S1Distance<D2>>
    extends S2BestEdgesQueryBase.CellTarget<D2>
    implements Target<D2> {
        public static final int MAX_BRUTE_FORCE_INDEX_SIZE = 96;

        public CellTarget(S2Cell c) {
            super(c);
        }

        @Override
        public int maxBruteForceIndexSize() {
            return 96;
        }

        @Override
        public S2Cap getCapBound() {
            S2Cap cap = this.cell.getCapBound();
            return S2Cap.fromAxisChord(cap.axis().neg(), cap.radius());
        }
    }

    public static class EdgeTarget<D2 extends S1Distance<D2>>
    extends S2BestEdgesQueryBase.EdgeTarget<D2>
    implements Target<D2> {
        public EdgeTarget(S2Point a, S2Point b) {
            super(a, b);
        }

        @Override
        public int maxBruteForceIndexSize() {
            return 40;
        }

        @Override
        public S2Cap getCapBound() {
            double r2 = this.getHalfEdgeLength2();
            return S2Cap.fromAxisChord(this.a.add(this.b).neg().normalize(), S1ChordAngle.fromLength2(r2));
        }
    }

    public static class PointTarget<D extends S1Distance<D>>
    extends S2BestEdgesQueryBase.PointTarget<D>
    implements Target<D> {
        public PointTarget(S2Point p) {
            super(p);
        }

        @Override
        public int maxBruteForceIndexSize() {
            return 64;
        }

        @Override
        public S2Cap getCapBound() {
            return S2Cap.fromAxisChord(this.point.neg(), S1ChordAngle.ZERO);
        }
    }

    public static interface Target<D extends S1Distance<D>>
    extends S2BestDistanceTarget<D> {
    }
}

