/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Shape;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public final class S2IncidentEdgeTracker {
    private final List<VertexEdge> nursery = new ArrayList<VertexEdge>();
    private int currentShapeId = -1;
    private final IncidentEdgeMap incidentEdgeMap = new IncidentEdgeMap();

    public void startShape(int shapeId) {
        this.nursery.clear();
        this.currentShapeId = shapeId;
    }

    public void addEdge(int edgeId, S2Shape.MutableEdge edge) {
        this.addEdge(edgeId, edge.a, edge.b);
    }

    public void addEdge(int edgeId, S2Point a, S2Point b) {
        Preconditions.checkState((this.currentShapeId >= 0 ? 1 : 0) != 0);
        this.nursery.add(VertexEdge.of(a, edgeId));
        if (!a.equalsPoint(b)) {
            this.nursery.add(VertexEdge.of(b, edgeId));
        }
    }

    public void finishShape() {
        Preconditions.checkState((this.currentShapeId >= 0 ? 1 : 0) != 0);
        int nurserySize = this.nursery.size();
        int start = 0;
        while (start < nurserySize) {
            int end = start + 1;
            int next = start;
            S2Point currVertex = this.nursery.get((int)start).vertex;
            while (++next < nurserySize) {
                if (!this.nursery.get((int)next).vertex.equalsPoint(currVertex)) continue;
                VertexEdge tmp = this.nursery.get(next);
                this.nursery.set(next, this.nursery.get(end));
                this.nursery.set(end++, tmp);
            }
            int numEdges = end - start;
            if (numEdges <= 2) {
                start = end;
                continue;
            }
            IncidentEdgeKey key = new IncidentEdgeKey(this.currentShapeId, this.nursery.get((int)start).vertex);
            HashSet<Integer> edges = (HashSet<Integer>)this.incidentEdgeMap.get(key);
            if (edges == null) {
                edges = new HashSet<Integer>(8, 0.5f);
                this.incidentEdgeMap.put(key, edges);
            }
            while (start != end) {
                edges.add(this.nursery.get((int)start++).edgeId);
            }
        }
        this.nursery.clear();
    }

    public void reset() {
        this.incidentEdgeMap.clear();
    }

    public IncidentEdgeMap incidentEdges() {
        return this.incidentEdgeMap;
    }

    private static class VertexEdge {
        final S2Point vertex;
        final int edgeId;

        public VertexEdge(S2Point vertex, int edgeId) {
            this.vertex = vertex;
            this.edgeId = edgeId;
        }

        public static VertexEdge of(S2Point vertex, int edgeId) {
            return new VertexEdge(vertex, edgeId);
        }
    }

    public static class IncidentEdgeMap
    extends TreeMap<IncidentEdgeKey, Set<Integer>> {
    }

    public static class IncidentEdgeKey
    implements Comparable<IncidentEdgeKey> {
        static final Comparator<IncidentEdgeKey> COMPARATOR = Comparator.comparingInt(IncidentEdgeKey::shapeId).thenComparing(IncidentEdgeKey::vertex);
        int shapeId;
        S2Point vertex;

        public IncidentEdgeKey() {
        }

        public IncidentEdgeKey(int shapeId) {
            this.shapeId = shapeId;
        }

        public IncidentEdgeKey(int shapeId, S2Point vertex) {
            this.shapeId = shapeId;
            this.vertex = vertex;
        }

        public int shapeId() {
            return this.shapeId;
        }

        public S2Point vertex() {
            return this.vertex;
        }

        public boolean isEqualTo(IncidentEdgeKey other) {
            return this.shapeId == other.shapeId && this.vertex.equalsPoint(other.vertex);
        }

        @Override
        public int compareTo(IncidentEdgeKey other) {
            return COMPARATOR.compare(this, other);
        }
    }
}

