/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.LittleEndianInput;
import com.google.common.geometry.LittleEndianOutput;
import com.google.common.geometry.PrimitiveArrays;
import com.google.common.geometry.R1Interval;
import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S1ChordAngle;
import com.google.common.geometry.S1Interval;
import com.google.common.geometry.S2;
import com.google.common.geometry.S2Cap;
import com.google.common.geometry.S2Coder;
import com.google.common.geometry.S2EdgeUtil;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2LatLngRectBase;
import com.google.common.geometry.S2Point;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;

@JsType
public final class S2LatLngRect
extends S2LatLngRectBase {
    private static final byte LOSSLESS_ENCODING_VERSION = 1;
    public static final S2Coder<S2LatLngRect> CODER = new S2Coder<S2LatLngRect>(){

        @Override
        public void encode(S2LatLngRect value, OutputStream output) throws IOException {
            value.encode(output);
        }

        @Override
        public S2LatLngRect decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) throws IOException {
            return S2LatLngRect.decode(data.toInputStream(cursor));
        }

        @Override
        public boolean isLazy() {
            return false;
        }
    };

    public static S2LatLngRect empty() {
        return new S2LatLngRect(R1Interval.empty(), S1Interval.empty());
    }

    public static S2LatLngRect full() {
        return new S2LatLngRect(S2LatLngRect.fullLat(), S2LatLngRect.fullLng());
    }

    public static R1Interval fullLat() {
        return new R1Interval(-1.5707963267948966, 1.5707963267948966);
    }

    public static S1Interval fullLng() {
        return S1Interval.full();
    }

    public static S2LatLngRect fromCenterSize(S2LatLng center, S2LatLng size) {
        return S2LatLngRect.fromPoint(center).expanded(size.mul(0.5));
    }

    public static S2LatLngRect fromPoint(S2LatLng p) {
        assert (S2.skipAssertions || p.isValid());
        return new S2LatLngRect(p, p);
    }

    public static S2LatLngRect fromPointPair(S2LatLng p1, S2LatLng p2) {
        assert (S2.skipAssertions || p1.isValid());
        assert (S2.skipAssertions || p2.isValid());
        return new S2LatLngRect(R1Interval.fromPointPair(p1.lat().radians(), p2.lat().radians()), S1Interval.fromPointPair(p1.lng().radians(), p2.lng().radians()));
    }

    @Deprecated
    public static S2LatLngRect fromEdge(S2Point a, S2Point b) {
        S2EdgeUtil.RectBounder bounder = new S2EdgeUtil.RectBounder();
        bounder.addPoint(a);
        bounder.addPoint(b);
        return bounder.getBound();
    }

    @JsIgnore
    public S2LatLngRect(S2LatLng lo, S2LatLng hi) {
        super(lo, hi);
        this.assertValid();
    }

    @JsIgnore
    public S2LatLngRect(R1Interval lat, S1Interval lng) {
        super(lat, lng);
        this.assertValid();
    }

    @JsIgnore
    public S2LatLngRect(S2LatLngRectBase b) {
        this.lat.setLo(b.lat.lo());
        this.lat.setHi(b.lat.hi());
        this.lng.set(b.lng.lo(), b.lng.hi(), true);
    }

    @Override
    public final R1Interval lat() {
        return this.lat;
    }

    @Override
    public final S1Interval lng() {
        return this.lng;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public S2LatLngRect addPoint(S2Point p) {
        return this.addPoint(new S2LatLng(p));
    }

    @JsMethod(name="addLatLng")
    public S2LatLngRect addPoint(S2LatLng ll) {
        assert (S2.skipAssertions || ll.isValid());
        R1Interval newLat = this.lat.addPoint(ll.lat().radians());
        S1Interval newLng = this.lng.addPoint(ll.lng().radians());
        return new S2LatLngRect(newLat, newLng);
    }

    public S2LatLngRect expanded(S2LatLng margin) {
        assert (margin.lat().radians() >= 0.0);
        assert (margin.lng().radians() >= 0.0);
        return new S2LatLngRect(this.lat.expanded(margin.lat().radians()).intersection(S2LatLngRect.fullLat()), this.lng.expanded(margin.lng().radians()));
    }

    public S2LatLngRect expandedByDistance(S1Angle distance) {
        double cSin;
        if (distance.radians() >= 0.0) {
            S1ChordAngle radius = S1ChordAngle.fromS1Angle(distance);
            Builder r = this.toBuilder();
            for (int k = 0; k < 4; ++k) {
                r.union(S2Cap.fromAxisChord(this.getVertex(k).toPoint(), radius).getRectBound());
            }
            return r.build();
        }
        R1Interval full = S2LatLngRect.fullLat();
        R1Interval latResult = new R1Interval(this.lat().lo() <= full.lo() && this.lng().isFull() ? full.lo() : this.lat().lo() - distance.radians(), this.lat().hi() >= full.hi() && this.lng().isFull() ? full.hi() : this.lat().hi() + distance.radians());
        if (latResult.isEmpty()) {
            return S2LatLngRect.empty();
        }
        double maxAbsLat = Math.max(-latResult.lo(), latResult.hi());
        double aSin = Math.sin(-distance.radians());
        double maxLngMargin = aSin < (cSin = Math.cos(maxAbsLat)) ? Math.asin(aSin / cSin) : 1.5707963267948966;
        S1Interval lngResult = this.lng().expanded(-maxLngMargin);
        if (lngResult.isEmpty()) {
            return S2LatLngRect.empty();
        }
        return new S2LatLngRect(latResult, lngResult);
    }

    public S2LatLngRect polarClosure() {
        if (this.lat.lo() == -1.5707963267948966 || this.lat.hi() == 1.5707963267948966) {
            return new S2LatLngRect(this.lat, S1Interval.full());
        }
        return this;
    }

    public S2LatLngRect union(S2LatLngRectBase other) {
        return new S2LatLngRect(this.lat.union(other.lat), this.lng.union(other.lng));
    }

    public S2LatLngRect intersection(S2LatLngRectBase other) {
        R1Interval intersectLat = this.lat.intersection(other.lat);
        S1Interval intersectLng = this.lng.intersection(other.lng);
        if (intersectLat.isEmpty() || intersectLng.isEmpty()) {
            return S2LatLngRect.empty();
        }
        return new S2LatLngRect(intersectLat, intersectLng);
    }

    public S2LatLngRect convolveWithCap(S1Angle angle) {
        Builder builder = this.toBuilder();
        builder.convolveWithCap(angle);
        return builder.build();
    }

    @Override
    public S2LatLngRect getRectBound() {
        return this;
    }

    @JsIgnore
    public void encode(OutputStream output) throws IOException {
        this.encode(new LittleEndianOutput(output));
    }

    @JsIgnore
    void encode(LittleEndianOutput encoder) throws IOException {
        encoder.writeByte((byte)1);
        encoder.writeDouble(this.lat().lo());
        encoder.writeDouble(this.lat().hi());
        encoder.writeDouble(this.lng().lo());
        encoder.writeDouble(this.lng().hi());
    }

    @JsIgnore
    public static S2LatLngRect decode(InputStream input) throws IOException {
        return S2LatLngRect.decode(new LittleEndianInput(input));
    }

    @JsIgnore
    static S2LatLngRect decode(LittleEndianInput decoder) throws IOException {
        double lngHi;
        double lngLo;
        S1Interval lng;
        double latHi;
        byte version = decoder.readByte();
        if (version != 1) {
            throw new IOException("Unsupported S2LatLngRect encoding version " + version);
        }
        double latLo = decoder.readDouble();
        R1Interval lat = new R1Interval(latLo, latHi = decoder.readDouble());
        if (!S2LatLngRect.isValid(lat, lng = new S1Interval(lngLo = decoder.readDouble(), lngHi = decoder.readDouble()))) {
            throw new IOException("Decoded lat and lng intervals do not form a valid S2LatLngRect.");
        }
        return new S2LatLngRect(lat, lng);
    }

    public static final class Builder
    extends S2LatLngRectBase {
        public Builder() {
        }

        public Builder(S2LatLng lo, S2LatLng hi) {
            super(lo, hi);
        }

        public Builder(R1Interval lat, S1Interval lng) {
            super(lat, lng);
        }

        public Builder(S2LatLngRectBase b) {
            this.lat.setLo(b.lat.lo());
            this.lat.setHi(b.lat.hi());
            this.lng.set(b.lng.lo(), b.lng.hi(), true);
        }

        public void clear() {
            this.lat.setEmpty();
            this.lng.setEmpty();
        }

        @Override
        public final R1Interval lat() {
            return new R1Interval(this.lat);
        }

        @Override
        public final S1Interval lng() {
            return new S1Interval(this.lng);
        }

        public void setLat(double lo, double hi) {
            this.lat.set(lo, hi);
        }

        public void setLng(double lo, double hi) {
            this.lng.set(lo, hi, false);
        }

        public S2LatLngRect build() {
            S2LatLngRect r = new S2LatLngRect(new R1Interval(this.lat), new S1Interval(this.lng));
            return r;
        }

        public static Builder empty() {
            return new Builder(R1Interval.empty(), S1Interval.empty());
        }

        @CanIgnoreReturnValue
        public Builder setFull() {
            this.lat.set(-1.5707963267948966, 1.5707963267948966);
            this.lng.setFull();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addPoint(S2Point p) {
            this.addPoint(new S2LatLng(p));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addPoint(S2LatLng ll) {
            assert (S2.skipAssertions || ll.isValid());
            this.lat.unionInternal(ll.lat().radians());
            this.lng.unionInternal(S1Interval.fromPoint(ll.lng().radians()));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder expanded(S2LatLng margin) {
            assert (margin.lat().radians() >= 0.0);
            assert (margin.lng().radians() >= 0.0);
            this.lat.expandedInternal(margin.lat().radians());
            this.lat.intersectionInternal(S2LatLngRect.fullLat());
            this.lng.expandedInternal(margin.lng().radians());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder polarClosure() {
            if (this.lat.lo() == -1.5707963267948966 || this.lat.hi() == 1.5707963267948966) {
                this.lng.setFull();
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder union(S2LatLngRect other) {
            this.lat.unionInternal(other.lat);
            this.lng.unionInternal(other.lng);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder intersection(S2LatLngRect other) {
            this.lat.intersectionInternal(other.lat);
            this.lng.intersectionInternal(other.lng);
            if (this.lat.isEmpty() && !this.lng.isEmpty()) {
                this.lng.setEmpty();
            } else if (this.lng.isEmpty() && !this.lat.isEmpty()) {
                this.lat.setEmpty();
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder convolveWithCap(S1Angle angle) {
            S1ChordAngle r = S1ChordAngle.fromS1Angle(angle);
            double latLo = this.lat.lo();
            double latHi = this.lat.hi();
            double lngLo = this.lng.lo();
            double lngHi = this.lng.hi();
            this.union(S2Cap.fromAxisChord(S2LatLng.fromRadians(latLo, lngLo).toPoint(), r).getRectBound());
            this.union(S2Cap.fromAxisChord(S2LatLng.fromRadians(latLo, lngHi).toPoint(), r).getRectBound());
            this.union(S2Cap.fromAxisChord(S2LatLng.fromRadians(latHi, lngLo).toPoint(), r).getRectBound());
            this.union(S2Cap.fromAxisChord(S2LatLng.fromRadians(latHi, lngHi).toPoint(), r).getRectBound());
            return this;
        }

        @Override
        public S2LatLngRect getRectBound() {
            return this.build();
        }
    }
}

