/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.geometry.S2Builder;
import com.google.common.geometry.S2BuilderGraph;
import com.google.common.geometry.S2BuilderShapesLayer;
import com.google.common.geometry.S2Error;
import com.google.common.geometry.S2LaxPolylineShape;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.primitives.IdSetLexicon;
import com.google.common.geometry.primitives.IntVector;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;

public class S2LaxPolylineLayer
implements S2BuilderShapesLayer {
    private final Options options;
    private S2LaxPolylineShape polyline = null;
    private final IntVector labelSetIds;
    private final IdSetLexicon labelSetLexicon;
    private final S2BuilderGraph.PolylineBuilder polylineBuilder = new S2BuilderGraph.PolylineBuilder();
    private S2BuilderGraph.LabelFetcher fetcher = null;

    public S2LaxPolylineLayer() {
        this.options = new Options();
        this.labelSetIds = null;
        this.labelSetLexicon = null;
    }

    public S2LaxPolylineLayer(Options options) {
        this.options = options;
        this.labelSetIds = null;
        this.labelSetLexicon = null;
    }

    public S2LaxPolylineLayer(Options options, IdSetLexicon labelSetLexicon, IntVector labelSetIds) {
        Preconditions.checkNotNull((Object)options);
        Preconditions.checkNotNull((Object)labelSetLexicon);
        Preconditions.checkNotNull((Object)labelSetIds);
        this.options = options;
        this.labelSetIds = labelSetIds;
        this.labelSetLexicon = labelSetLexicon;
    }

    public S2LaxPolylineShape getPolyline() {
        Preconditions.checkNotNull((Object)this.polyline, (Object)"Must call build() first.");
        return this.polyline;
    }

    public Iterable<S2LaxPolylineShape> shapes() {
        return ImmutableList.of((Object)this.getPolyline());
    }

    @Override
    public S2Builder.GraphOptions graphOptions() {
        return new S2Builder.GraphOptions(this.options.edgeType(), S2Builder.GraphOptions.DegenerateEdges.KEEP, S2Builder.GraphOptions.DuplicateEdges.KEEP, S2Builder.GraphOptions.SiblingPairs.KEEP);
    }

    @Override
    public boolean build(S2BuilderGraph g, S2Error error) {
        if (this.labelSetIds != null) {
            this.labelSetIds.clear();
            this.labelSetLexicon.clear();
        }
        if (g.numEdges() == 0) {
            this.polyline = S2LaxPolylineShape.EMPTY;
            return true;
        }
        this.polylineBuilder.init(g);
        List<int[]> edgePolylines = this.polylineBuilder.buildWalks();
        if (edgePolylines.size() != 1) {
            error.init(S2Error.Code.BUILDER_EDGES_DO_NOT_FORM_POLYLINE, "Input edges cannot be assembled into a single polyline", new Object[0]);
            return false;
        }
        int[] edgePolyline = edgePolylines.get(0);
        S2Point[] vertices = new S2Point[edgePolyline.length + 1];
        vertices[0] = g.vertex(g.edgeSrcId(edgePolyline[0]));
        int i = 1;
        for (int edgeId : edgePolyline) {
            vertices[i++] = g.vertex(g.edgeDstId(edgeId));
        }
        if (this.labelSetIds != null) {
            if (this.fetcher == null) {
                this.fetcher = new S2BuilderGraph.LabelFetcher(g, this.options.edgeType());
            } else {
                this.fetcher.init(g, this.options.edgeType());
            }
            IntVector labels = new IntVector();
            for (int edgeId : edgePolyline) {
                this.fetcher.fetch(edgeId, labels);
                this.labelSetIds.add(this.labelSetLexicon.add(labels));
            }
        }
        this.polyline = S2LaxPolylineShape.create(vertices);
        return true;
    }

    public static class Options {
        private S2Builder.EdgeType edgeType;

        public Options() {
            this.edgeType = S2Builder.EdgeType.DIRECTED;
        }

        public Options(S2Builder.EdgeType edgeType) {
            Preconditions.checkNotNull((Object)((Object)edgeType));
            this.edgeType = edgeType;
        }

        public S2Builder.EdgeType edgeType() {
            return this.edgeType;
        }

        @CanIgnoreReturnValue
        public Options setEdgeType(S2Builder.EdgeType edgeType) {
            Preconditions.checkNotNull((Object)((Object)edgeType));
            this.edgeType = edgeType;
            return this;
        }
    }
}

