/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2Coder;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2PointVectorCoder;
import com.google.common.geometry.S2Polyline;
import com.google.common.geometry.S2ShapeAspect;
import java.io.IOException;
import java.util.List;

public interface S2LaxPolylineShape
extends S2ShapeAspect.EdgeAspect.Open {
    public static final S2LaxPolylineShape EMPTY = new SimpleArray((Iterable<S2Point>)ImmutableList.of());
    public static final S2Coder<S2LaxPolylineShape> FAST_CODER = S2PointVectorCoder.FAST.delegating(S2ShapeAspect.VertexAspect::vertices, x$0 -> new SimpleList((List<S2Point>)x$0));
    public static final S2Coder<S2LaxPolylineShape> COMPACT_CODER = S2PointVectorCoder.COMPACT.delegating(S2ShapeAspect.VertexAspect::vertices, x$0 -> new SimpleList((List<S2Point>)x$0));

    public static S2LaxPolylineShape create(S2Polyline line) {
        if (line.numVertices() == 1) {
            S2Point[] pts = new S2Point[]{line.vertices().get(0), line.vertices().get(0)};
            return S2LaxPolylineShape.create(pts);
        }
        return S2LaxPolylineShape.create(line.vertices());
    }

    public static S2LaxPolylineShape create(Iterable<S2Point> vertices) {
        return Iterables.isEmpty(vertices = S2LaxPolylineShape.filterLine(vertices)) ? EMPTY : new SimpleArray(vertices);
    }

    public static S2LaxPolylineShape create(S2Point[] vertices) {
        return vertices.length < 2 ? EMPTY : new SimpleArray(vertices);
    }

    public static S2LaxPolylineShape createPacked(Iterable<S2Point> vertices) {
        return Iterables.isEmpty(vertices = S2LaxPolylineShape.filterLine(vertices)) ? EMPTY : new SimplePacked(vertices);
    }

    public static S2LaxPolylineShape createSnapped(Iterable<S2CellId> vertices) {
        return Iterables.isEmpty(vertices = S2LaxPolylineShape.filterLine(vertices)) ? EMPTY : new SimpleSnapped(vertices);
    }

    public static S2LaxPolylineShape createMulti(Iterable<? extends Iterable<S2Point>> lines) {
        if (Iterables.isEmpty(lines = S2LaxPolylineShape.filterLines(lines))) {
            return EMPTY;
        }
        if (Iterables.size(lines) == 1) {
            return new SimpleArray((Iterable)Iterables.getOnlyElement(lines));
        }
        return new MultiArray((Iterable<? extends Iterable<S2Point>>)lines);
    }

    public static S2LaxPolylineShape createMultiPacked(Iterable<? extends Iterable<S2Point>> lines) {
        if (Iterables.isEmpty(lines = S2LaxPolylineShape.filterLines(lines))) {
            return EMPTY;
        }
        if (Iterables.size(lines) == 1) {
            return new SimplePacked((Iterable)Iterables.getOnlyElement(lines));
        }
        return new MultiPacked((Iterable<? extends Iterable<S2Point>>)lines);
    }

    public static S2LaxPolylineShape createMultiSnapped(Iterable<? extends Iterable<S2CellId>> lines) {
        if (Iterables.isEmpty(lines = S2LaxPolylineShape.filterLines(lines))) {
            return EMPTY;
        }
        if (Iterables.size(lines) == 1) {
            return new SimpleSnapped((Iterable)Iterables.getOnlyElement(lines));
        }
        return new MultiSnapped((Iterable<? extends Iterable<S2CellId>>)lines);
    }

    public static <T> Iterable<T> filterLine(Iterable<T> input) {
        return Iterables.size(input) < 2 ? ImmutableList.of() : input;
    }

    public static <T> Iterable<? extends Iterable<T>> filterLines(Iterable<? extends Iterable<T>> input) {
        return Iterables.filter((Iterable)Iterables.transform(input, S2LaxPolylineShape::filterLine), (Predicate)Predicates.not(Iterables::isEmpty));
    }

    default public Object readResolve() {
        return this.numVertices() == 0 ? EMPTY : this;
    }

    @Override
    default public int dimension() {
        return 1;
    }

    @Override
    default public boolean hasInterior() {
        return false;
    }

    @Override
    default public boolean containsOrigin() {
        return false;
    }

    @Override
    default public int numEdges() {
        return this.numVertices() == 0 ? 0 : this.numVertices() - this.numChains();
    }

    @Override
    default public boolean isEmpty() {
        return this.numEdges() == 0;
    }

    @Override
    default public boolean isFull() {
        return false;
    }

    public static class MultiSnapped
    extends S2ShapeAspect.ChainAspect.Multi.Snapped
    implements S2LaxPolylineShape {
        MultiSnapped(Iterable<? extends Iterable<S2CellId>> chains) {
            super(chains);
        }
    }

    public static class MultiPacked
    extends S2ShapeAspect.ChainAspect.Multi.Packed
    implements S2LaxPolylineShape {
        MultiPacked(Iterable<? extends Iterable<S2Point>> chains) {
            super(chains);
        }
    }

    public static class MultiArray
    extends S2ShapeAspect.ChainAspect.Multi.Array
    implements S2LaxPolylineShape {
        private MultiArray(Iterable<? extends Iterable<S2Point>> chains) {
            super(chains);
        }
    }

    public static class SimpleSnapped
    extends S2ShapeAspect.ChainAspect.Simple.Snapped
    implements S2LaxPolylineShape {
        private SimpleSnapped(Iterable<S2CellId> vertices) {
            super(vertices);
        }
    }

    public static class SimplePacked
    extends S2ShapeAspect.ChainAspect.Simple.Packed
    implements S2LaxPolylineShape {
        private SimplePacked(Iterable<S2Point> vertices) {
            super(vertices);
        }
    }

    public static class SimpleList
    extends S2ShapeAspect.ChainAspect.Simple
    implements S2LaxPolylineShape {
        private final List<S2Point> vertices;

        private SimpleList(List<S2Point> vertices) throws IOException {
            if (vertices.size() == 1) {
                throw new IOException("A valid S2LaxPolylineShape may not have a single vertex.");
            }
            this.vertices = vertices;
        }

        @Override
        public int numVertices() {
            return this.vertices.size();
        }

        @Override
        public S2Point vertex(int vertexId) {
            return this.vertices.get(vertexId);
        }
    }

    public static abstract class Simple
    extends S2ShapeAspect.ChainAspect.Simple
    implements S2LaxPolylineShape {
    }

    public static class SimpleArray
    extends S2ShapeAspect.ChainAspect.Simple.Array
    implements S2LaxPolylineShape {
        private SimpleArray(Iterable<S2Point> vertices) {
            super(vertices);
        }

        private SimpleArray(S2Point[] vertices) {
            super(vertices);
        }
    }
}

