/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Objects;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2Iterator;
import com.google.common.geometry.S2Point;
import com.google.common.primitives.UnsignedLongs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import java.util.Comparator;
import org.jspecify.annotations.Nullable;

public final class S2PointIndex<D> {
    private final ObjectAVLTreeSet<Entry<D>> entries;

    public static <D extends Comparable<D>> S2PointIndex<D> forComparableData() {
        return new S2PointIndex(Entry.stableOrder());
    }

    public S2PointIndex() {
        this.entries = new ObjectAVLTreeSet(Entry.order());
    }

    private S2PointIndex(Comparator<Entry<D>> comparator) {
        this.entries = new ObjectAVLTreeSet(comparator);
    }

    public int numPoints() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public S2Iterator<Entry<D>> iterator() {
        return new S2Iterator.AvlSetIterator<Entry<D>>(this.entries, id -> new Entry<Object>((S2CellId)id, null, null));
    }

    @Deprecated
    public void applyUpdates() {
    }

    public void add(S2Point point, D data) {
        this.add(S2PointIndex.createEntry(point, data));
    }

    public void add(Entry<D> entry) {
        this.entries.add(entry);
    }

    @CanIgnoreReturnValue
    public boolean remove(S2Point point, D data) {
        return this.remove(S2PointIndex.createEntry(point, data));
    }

    @CanIgnoreReturnValue
    public boolean remove(Entry<D> entry) {
        return this.entries.remove(entry);
    }

    public void reset() {
        this.entries.clear();
    }

    public static <D> Entry<D> createEntry(S2Point point, D data) {
        return new Entry<D>(S2CellId.fromPoint(point), point, data);
    }

    public static class Entry<D>
    implements S2Iterator.Entry,
    Comparable<Entry<D>> {
        private final long id;
        private final S2Point point;
        private final @Nullable D data;

        public static <D extends Comparable<D>> Comparator<Entry<D>> stableOrder() {
            return (a, b) -> Entry.compare(a, b, Comparator.naturalOrder());
        }

        public static <D> Comparator<Entry<D>> order() {
            return (a, b) -> Entry.compare(a, b, (aData, bData) -> aData.equals(bData) ? 0 : -1);
        }

        public Entry(S2CellId cellId, S2Point point, D data) {
            this.id = cellId.id();
            this.point = point;
            this.data = data;
        }

        @Override
        public long id() {
            return this.id;
        }

        public S2Point point() {
            return this.point;
        }

        public D data() {
            return this.data;
        }

        public boolean equals(Object other) {
            if (other instanceof Entry) {
                Entry e = (Entry)other;
                return this.point.equalsPoint(e.point) && Objects.equal(this.data, e.data);
            }
            return false;
        }

        public int hashCode() {
            return this.point.hashCode() * 31 + (this.data == null ? 0 : this.data.hashCode());
        }

        @Override
        public int compareTo(Entry<D> other) {
            return UnsignedLongs.compare((long)this.id, (long)other.id);
        }

        public String toString() {
            return this.point.toDegreesString() + " : " + this.data;
        }

        private static <D> int compare(Entry<D> a, Entry<D> b, Comparator<D> comparator) {
            if (a == b) {
                return 0;
            }
            int cmp = UnsignedLongs.compare((long)a.id, (long)b.id);
            if (cmp != 0) {
                return cmp;
            }
            if (a.point == null && b.point == null) {
                cmp = 0;
            } else {
                if (a.point == null) {
                    return -1;
                }
                if (b.point == null) {
                    return 1;
                }
                cmp = a.point.compareTo(b.point);
            }
            if (cmp != 0) {
                return cmp;
            }
            if (a.data == null && b.data == null) {
                return 0;
            }
            if (a.data == null) {
                return -1;
            }
            if (b.data == null) {
                return 1;
            }
            return comparator.compare(a.data, b.data);
        }
    }
}

