/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S2;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2ClosestPointQuery;
import com.google.common.geometry.S2Edge;
import com.google.common.geometry.S2Iterator;
import com.google.common.geometry.S2Loop;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2PointIndex;
import com.google.common.geometry.S2Polygon;
import com.google.common.geometry.S2Predicates;
import com.google.common.geometry.S2Projections;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;
import org.jspecify.annotations.Nullable;

@JsType
@Deprecated
public final class S2PolygonBuilder {
    private final Options options;
    private final Map<S2Point, Multiset<S2Point>> edges = Maps.newHashMap();
    private final List<S2Point> startingVertices = Lists.newArrayList();

    @JsIgnore
    public S2PolygonBuilder() {
        this(Options.DIRECTED_XOR);
    }

    public S2PolygonBuilder(Options options) {
        this.options = options;
    }

    public Options options() {
        return this.options;
    }

    @CanIgnoreReturnValue
    public boolean addEdge(S2Point v0, S2Point v1) {
        if (v0.equalsPoint(v1)) {
            return false;
        }
        if (this.options.getXorEdges() && this.hasEdge(v1, v0)) {
            this.eraseEdge(v1, v0);
            return false;
        }
        if (this.edges.get(v0) == null) {
            this.edges.put(v0, (Multiset<S2Point>)HashMultiset.create());
            this.startingVertices.add(v0);
        }
        this.edges.get(v0).add((Object)v1);
        if (this.options.getUndirectedEdges()) {
            if (this.edges.get(v1) == null) {
                this.edges.put(v1, (Multiset<S2Point>)HashMultiset.create());
                this.startingVertices.add(v1);
            }
            this.edges.get(v1).add((Object)v0);
        }
        return true;
    }

    public void addLoop(S2Loop loop) {
        if (!loop.isEmptyOrFull()) {
            int sign = loop.sign();
            for (int i = loop.numVertices(); i > 0; --i) {
                this.addEdge(loop.vertex(i), loop.vertex(i + sign));
            }
        }
    }

    public void addPolygon(S2Polygon polygon) {
        for (int i = 0; i < polygon.numLoops(); ++i) {
            this.addLoop(polygon.loop(i));
        }
    }

    private S2Point snapPointToLevel(S2Point p, int level) {
        return S2CellId.fromPoint(p).parent(level).toPoint();
    }

    private S2Loop snapLoopToLevel(S2Loop loop, int level) {
        ArrayList snappedVertices = Lists.newArrayListWithCapacity((int)loop.numVertices());
        for (int i = 0; i < loop.numVertices(); ++i) {
            snappedVertices.add(this.snapPointToLevel(loop.vertex(i), level));
        }
        return new S2Loop(snappedVertices);
    }

    @CanIgnoreReturnValue
    public boolean assembleLoops(List<S2Loop> loops, @Nullable List<S2Edge> unusedEdges) {
        if (this.options.getMergeDistance().radians() > 0.0) {
            S1Angle mergeDistance = this.options.getMergeDistance();
            Map<S2Point, S2Point> mergeMap = this.buildMergeMap(mergeDistance);
            this.moveVertices(mergeMap);
            double spliceFraction = this.options.getEdgeSpliceFraction();
            if (spliceFraction > 0.0) {
                this.spliceEdges(S1Angle.radians(mergeDistance.radians() * spliceFraction));
            }
        }
        int snapLevel = this.options.getSnapLevel();
        if (unusedEdges != null) {
            unusedEdges.clear();
        } else {
            unusedEdges = new ArrayList<S2Edge>();
        }
        int i = 0;
        while (i < this.startingVertices.size()) {
            S2Point v0 = this.startingVertices.get(i);
            Multiset<S2Point> candidates = this.edges.get(v0);
            if (candidates == null) {
                ++i;
                continue;
            }
            S2Point v1 = (S2Point)candidates.iterator().next();
            S2Loop loop = this.assembleLoop(v0, v1, unusedEdges);
            if (loop == null) continue;
            this.eraseLoop(loop, loop.numVertices());
            if (snapLevel >= 0) {
                loop = this.snapLoopToLevel(loop, snapLevel);
            }
            loops.add(loop);
        }
        return unusedEdges.isEmpty();
    }

    @CanIgnoreReturnValue
    public boolean assemblePolygon(S2Polygon polygon, @Nullable List<S2Edge> unusedEdges) {
        ArrayList loops = Lists.newArrayList();
        boolean success = this.assembleLoops(loops, unusedEdges);
        if (this.options.getUndirectedEdges()) {
            polygon.init(loops);
        } else {
            polygon.initOriented(loops);
        }
        if (this.options.getValidate() && !polygon.isValid()) {
            polygon.release(loops);
            if (unusedEdges != null) {
                for (S2Loop loop : loops) {
                    this.rejectLoop(loop, loop.numVertices(), unusedEdges);
                }
            }
            return false;
        }
        return success;
    }

    @JsMethod(name="getPolygon")
    public S2Polygon assemblePolygon() {
        S2Polygon polygon = new S2Polygon();
        this.assemblePolygon(polygon, null);
        return polygon;
    }

    private void eraseEdge(S2Point v0, S2Point v1) {
        Multiset<S2Point> vset = this.edges.get(v0);
        vset.remove((Object)v1);
        if (vset.isEmpty()) {
            this.edges.remove(v0);
        }
        if (this.options.getUndirectedEdges()) {
            vset = this.edges.get(v1);
            vset.remove((Object)v0);
            if (vset.isEmpty()) {
                this.edges.remove(v1);
            }
        }
    }

    private void eraseLoop(List<S2Point> v, int n) {
        int i = n - 1;
        int j = 0;
        while (j < n) {
            this.eraseEdge(v.get(i), v.get(j));
            i = j++;
        }
    }

    private void eraseLoop(S2Loop v, int n) {
        int i = n - 1;
        int j = 0;
        while (j < n) {
            this.eraseEdge(v.vertex(i), v.vertex(j));
            i = j++;
        }
    }

    private @Nullable S2Loop assembleLoop(S2Point v0, S2Point v1, @Nullable List<S2Edge> unusedEdges) {
        List<S2Point> path = Lists.newArrayList();
        HashMap index = Maps.newHashMap();
        path.add(v0);
        path.add(v1);
        index.put(v1, 1);
        while (path.size() >= 2) {
            v0 = (S2Point)path.get(path.size() - 2);
            v1 = (S2Point)path.get(path.size() - 1);
            S2Point v2 = null;
            boolean v2Found = false;
            Multiset<S2Point> vset = this.edges.get(v1);
            if (vset != null) {
                for (S2Point v : vset) {
                    if (v.equalsPoint(v0)) continue;
                    if (!v2Found || S2Predicates.orderedCCW(v0, v2, v, v1)) {
                        v2 = v;
                    }
                    v2Found = true;
                }
            }
            if (!v2Found) {
                if (unusedEdges != null) {
                    unusedEdges.add(new S2Edge(v0, v1));
                }
                this.eraseEdge(v0, v1);
                index.remove(v1);
                path.remove(path.size() - 1);
                continue;
            }
            if (index.get(v2) == null) {
                index.put(v2, path.size());
                path.add(v2);
                continue;
            }
            if ((Integer)index.get(v2) == 1 && ((S2Point)path.get(0)).equalsPoint((S2Point)path.get(path.size() - 1))) {
                path.remove(path.size() - 1);
            } else {
                path = path.subList((Integer)index.get(v2), path.size());
            }
            S2Loop loop = new S2Loop(path);
            if (this.options.getValidate() && !loop.isValid()) {
                if (unusedEdges != null) {
                    this.rejectLoop(path, path.size(), unusedEdges);
                }
                this.eraseLoop(path, path.size());
                return null;
            }
            if (this.options.getUndirectedEdges() && !loop.isNormalized()) {
                return this.assembleLoop(path.get(1), path.get(0), unusedEdges);
            }
            return loop;
        }
        return null;
    }

    private void rejectLoop(S2Loop v, int n, List<S2Edge> unusedEdges) {
        int i = n - 1;
        int j = 0;
        while (j < n) {
            unusedEdges.add(new S2Edge(v.vertex(i), v.vertex(j)));
            i = j++;
        }
    }

    private void rejectLoop(List<S2Point> v, int n, List<S2Edge> unusedEdges) {
        int i = n - 1;
        int j = 0;
        while (j < n) {
            unusedEdges.add(new S2Edge(v.get(i), v.get(j)));
            i = j++;
        }
    }

    private void moveVertices(Map<S2Point, S2Point> mergeMap) {
        if (mergeMap.isEmpty()) {
            return;
        }
        ArrayList edgesCopy = Lists.newArrayList();
        for (Map.Entry<S2Point, Multiset<S2Point>> edge : this.edges.entrySet()) {
            S2Point v0 = edge.getKey();
            Multiset<S2Point> vset = edge.getValue();
            for (S2Point v1 : vset) {
                if (mergeMap.get(v0) == null && mergeMap.get(v1) == null || this.options.getUndirectedEdges() && !v0.lessThan(v1)) continue;
                edgesCopy.add(new S2Edge(v0, v1));
            }
        }
        for (int i = 0; i < edgesCopy.size(); ++i) {
            S2Point new1;
            S2Point v0 = ((S2Edge)edgesCopy.get(i)).getStart();
            S2Point v1 = ((S2Edge)edgesCopy.get(i)).getEnd();
            this.eraseEdge(v0, v1);
            S2Point new0 = mergeMap.get(v0);
            if (new0 != null) {
                v0 = new0;
            }
            if ((new1 = mergeMap.get(v1)) != null) {
                v1 = new1;
            }
            this.addEdge(v0, v1);
        }
    }

    private S2PointIndex<Void> index() {
        S2PointIndex<Void> index = new S2PointIndex<Void>();
        for (Map.Entry<S2Point, Multiset<S2Point>> edge : this.edges.entrySet()) {
            index.add(edge.getKey(), null);
            for (S2Point v : edge.getValue().elementSet()) {
                index.add(v, null);
            }
        }
        return index;
    }

    private Map<S2Point, S2Point> buildMergeMap(S1Angle snapDistance) {
        HashMap mergeMap = Maps.newHashMap();
        Stack<S2Point> frontier = new Stack<S2Point>();
        ArrayList mergeable = Lists.newArrayList();
        S2PointIndex<Void> index = this.index();
        S2ClosestPointQuery<Void> query = new S2ClosestPointQuery<Void>(index);
        query.setMaxDistance(snapDistance);
        S2Iterator<S2PointIndex.Entry<Void>> it = index.iterator();
        while (!it.done()) {
            S2Point vstart = it.entry().point();
            if (!mergeMap.containsKey(vstart)) {
                frontier.add(vstart);
                while (!frontier.isEmpty()) {
                    mergeable.clear();
                    query.findClosestPoints(mergeable, (S2Point)frontier.pop());
                    for (S2ClosestPointQuery.Result result : mergeable) {
                        S2Point vnear = result.entry().point();
                        if (mergeMap.containsKey(vnear) || vstart.equalsPoint(vnear)) continue;
                        frontier.push(vnear);
                        mergeMap.put(vnear, vstart);
                    }
                }
            }
            it.next();
        }
        return mergeMap;
    }

    public boolean hasEdge(S2Point v0, S2Point v1) {
        Multiset<S2Point> vset = this.edges.get(v0);
        return vset == null ? false : vset.count((Object)v1) > 0;
    }

    private void spliceEdges(S1Angle spliceDistance) {
        ArrayList pendingEdges = Lists.newArrayList();
        for (Map.Entry<S2Point, Multiset<S2Point>> edge : this.edges.entrySet()) {
            S2Point v0 = edge.getKey();
            for (S2Point v1 : edge.getValue().elementSet()) {
                if (this.options.getUndirectedEdges() && v0.compareTo(v1) >= 0) continue;
                pendingEdges.add(new S2Edge(v0, v1));
            }
        }
        S2ClosestPointQuery<Void> query = new S2ClosestPointQuery<Void>(this.index());
        query.setMaxDistance(spliceDistance);
        ArrayList results = new ArrayList();
        block2: while (!pendingEdges.isEmpty()) {
            S2Point v1;
            S2Edge lastPair = (S2Edge)pendingEdges.remove(pendingEdges.size() - 1);
            S2Point v0 = lastPair.getStart();
            v1 = lastPair.getEnd();
            if (this.options.getXorEdges() && !this.hasEdge(v0, v1)) continue;
            results.clear();
            query.findClosestPointsToEdge(results, v0, v1);
            for (S2ClosestPointQuery.Result result : results) {
                S2Point vmid = result.entry().point();
                if (vmid.equalsPoint(v0) || vmid.equalsPoint(v1)) continue;
                assert (Math.toDegrees(S2.angle(vmid, v0, v1)) < 60.0) : "Closest points query found a point too far to splice into existing edge (\u2206 splice angle \u226560\u00ba) which could cause infinite looping and OOM. Perhaps mergeRadius is too small or edgeSpliceFraction is too large.";
                this.eraseEdge(v0, v1);
                if (this.addEdge(v0, vmid)) {
                    pendingEdges.add(new S2Edge(v0, vmid));
                }
                if (!this.addEdge(vmid, v1)) continue block2;
                pendingEdges.add(new S2Edge(vmid, v1));
                continue block2;
            }
        }
    }

    @JsType
    public static final class Options {
        public static final Options DIRECTED_XOR = Options.builder().setUndirectedEdges(false).setXorEdges(true).build();
        public static final Options UNDIRECTED_XOR = Options.builder().setUndirectedEdges(true).setXorEdges(true).build();
        public static final Options UNDIRECTED_UNION = Options.builder().setUndirectedEdges(true).setXorEdges(false).build();
        public static final Options DIRECTED_UNION = Options.builder().setUndirectedEdges(false).setXorEdges(false).build();
        private final boolean undirectedEdges;
        private final boolean xorEdges;
        private final boolean validate;
        private final S1Angle mergeDistance;
        private final boolean snapToCellCenters;
        private final double edgeSpliceFraction;

        private Options(Builder builder) {
            this.undirectedEdges = builder.undirectedEdges;
            this.xorEdges = builder.xorEdges;
            this.validate = builder.validate;
            this.mergeDistance = builder.mergeDistance;
            this.snapToCellCenters = builder.snapToCellCenters;
            this.edgeSpliceFraction = builder.edgeSpliceFraction;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return new Builder().setUndirectedEdges(this.undirectedEdges).setXorEdges(this.xorEdges).setValidate(this.validate).setMergeDistance(this.mergeDistance).setSnapToCellCenters(this.snapToCellCenters).setEdgeSpliceFraction(this.edgeSpliceFraction);
        }

        public boolean getUndirectedEdges() {
            return this.undirectedEdges;
        }

        public boolean getXorEdges() {
            return this.xorEdges;
        }

        public boolean getValidate() {
            return this.validate;
        }

        public S1Angle getMergeDistance() {
            return this.mergeDistance;
        }

        public boolean getSnapToCellCenters() {
            return this.snapToCellCenters;
        }

        public double getEdgeSpliceFraction() {
            return this.edgeSpliceFraction;
        }

        public S1Angle getRobustnessRadius() {
            return S1Angle.radians(this.mergeDistance.radians() * this.edgeSpliceFraction / 2.0);
        }

        public int getSnapLevel() {
            if (!this.getSnapToCellCenters()) {
                return -1;
            }
            S1Angle tolerance = this.getRobustnessRadius();
            int level = S2Projections.MAX_DIAG.getMinLevel(tolerance.radians() * 2.0);
            if (level == 30 && tolerance.radians() < S2Projections.MAX_DIAG.getValue(level) / 2.0) {
                return -1;
            }
            return level;
        }

        @JsType
        public static class Builder {
            private boolean undirectedEdges = false;
            private boolean xorEdges = true;
            private boolean validate = false;
            private S1Angle mergeDistance = S1Angle.radians(0.0);
            private boolean snapToCellCenters = false;
            private double edgeSpliceFraction = 0.866;

            public Options build() {
                return new Options(this);
            }

            @CanIgnoreReturnValue
            public Builder setUndirectedEdges(boolean undirectedEdges) {
                this.undirectedEdges = undirectedEdges;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setXorEdges(boolean xorEdges) {
                this.xorEdges = xorEdges;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setValidate(boolean validate) {
                this.validate = validate;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMergeDistance(S1Angle mergeDistance) {
                this.mergeDistance = mergeDistance;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setSnapToCellCenters(boolean snapToCellCenters) {
                this.snapToCellCenters = snapToCellCenters;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setEdgeSpliceFraction(double edgeSpliceFraction) {
                Preconditions.checkState((edgeSpliceFraction < Math.sqrt(3.0) / 2.0 ? 1 : 0) != 0, (Object)"Splice fraction must be at least sqrt(3)/2 to ensure termination of edge splicing algorithm.");
                this.edgeSpliceFraction = edgeSpliceFraction;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setRobustnessRadius(S1Angle robustnessRadius) {
                this.mergeDistance = S1Angle.radians(2.0 * robustnessRadius.radians() / this.edgeSpliceFraction);
                return this;
            }
        }
    }
}

