/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.geometry.S2Builder;
import com.google.common.geometry.S2BuilderGraph;
import com.google.common.geometry.S2BuilderShapesLayer;
import com.google.common.geometry.S2Error;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Polyline;
import com.google.common.geometry.primitives.IdSetLexicon;
import com.google.common.geometry.primitives.IntVector;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;

public class S2PolylineVectorLayer
implements S2BuilderShapesLayer {
    private final Options options;
    private List<S2Polyline> polylines = null;
    private final List<IntVector> labelSetIds;
    private final IdSetLexicon labelSetLexicon;
    private final S2BuilderGraph.PolylineBuilder polylineBuilder = new S2BuilderGraph.PolylineBuilder();
    private S2BuilderGraph.LabelFetcher fetcher = null;

    public S2PolylineVectorLayer() {
        this.options = new Options();
        this.labelSetIds = null;
        this.labelSetLexicon = null;
    }

    public S2PolylineVectorLayer(Options options) {
        this.options = options;
        this.labelSetIds = null;
        this.labelSetLexicon = null;
    }

    public S2PolylineVectorLayer(Options options, IdSetLexicon labelSetLexicon, List<IntVector> labelSetIds) {
        Preconditions.checkNotNull((Object)options);
        Preconditions.checkNotNull((Object)labelSetLexicon);
        Preconditions.checkNotNull(labelSetIds);
        this.options = options;
        this.labelSetIds = labelSetIds;
        this.labelSetLexicon = labelSetLexicon;
    }

    public String toString() {
        return "S2PolylineVectorLayer with Options " + this.options;
    }

    public List<S2Polyline> getPolylines() {
        Preconditions.checkNotNull(this.polylines, (Object)"Must call build() first.");
        return this.polylines;
    }

    public Iterable<S2Polyline> shapes() {
        return this.getPolylines();
    }

    @Override
    public S2Builder.GraphOptions graphOptions() {
        return new S2Builder.GraphOptions(this.options.edgeType(), S2Builder.GraphOptions.DegenerateEdges.DISCARD_EXCESS, this.options.duplicateEdges(), this.options.siblingPairs());
    }

    @Override
    public boolean build(S2BuilderGraph g, S2Error error) {
        this.polylineBuilder.init(g);
        List<int[]> edgePolylines = this.options.polylineType() == S2BuilderGraph.PolylineType.PATH ? this.polylineBuilder.buildPaths() : this.polylineBuilder.buildWalks();
        this.polylines = new ArrayList<S2Polyline>(edgePolylines.size());
        IntVector labels = null;
        if (this.labelSetIds != null) {
            if (this.fetcher == null) {
                this.fetcher = new S2BuilderGraph.LabelFetcher();
            }
            this.fetcher.init(g, this.options.edgeType());
            this.labelSetIds.clear();
            this.labelSetLexicon.clear();
            labels = new IntVector();
        }
        for (int[] edgePolyline : edgePolylines) {
            S2Point[] vertices = new S2Point[edgePolyline.length + 1];
            vertices[0] = g.vertex(g.edgeSrcId(edgePolyline[0]));
            int i = 1;
            for (int edgeId : edgePolyline) {
                vertices[i++] = g.vertex(g.edgeDstId(edgeId));
            }
            if (vertices.length == 2 && vertices[0].equalsPoint(vertices[1])) {
                vertices = new S2Point[]{vertices[0]};
            }
            S2Polyline polyline = new S2Polyline(vertices);
            if (this.options.validate() && polyline.findValidationError(error)) {
                return false;
            }
            this.polylines.add(polyline);
            if (this.labelSetIds == null) continue;
            IntVector polylineLabels = new IntVector();
            for (int edgeId : edgePolyline) {
                this.fetcher.fetch(edgeId, labels);
                polylineLabels.add(this.labelSetLexicon.add(labels));
            }
            this.labelSetIds.add(polylineLabels);
        }
        return true;
    }

    public static class Options {
        private S2Builder.EdgeType edgeType;
        private S2BuilderGraph.PolylineType polylineType;
        private S2Builder.GraphOptions.DuplicateEdges duplicateEdges;
        private S2Builder.GraphOptions.SiblingPairs siblingPairs;
        private boolean validate;

        public Options() {
            this.edgeType = S2Builder.EdgeType.DIRECTED;
            this.polylineType = S2BuilderGraph.PolylineType.PATH;
            this.duplicateEdges = S2Builder.GraphOptions.DuplicateEdges.KEEP;
            this.siblingPairs = S2Builder.GraphOptions.SiblingPairs.KEEP;
            this.validate = false;
        }

        public Options(S2Builder.EdgeType edgeType) {
            this.edgeType = edgeType;
            this.polylineType = S2BuilderGraph.PolylineType.PATH;
            this.duplicateEdges = S2Builder.GraphOptions.DuplicateEdges.KEEP;
            this.siblingPairs = S2Builder.GraphOptions.SiblingPairs.KEEP;
            this.validate = false;
        }

        public String toString() {
            return Strings.lenientFormat((String)"EdgeType %s, PolylineType %s, DuplicateEdges %s, SiblingPairs %s, Validate=%s", (Object[])new Object[]{this.edgeType, this.polylineType, this.duplicateEdges, this.siblingPairs, this.validate});
        }

        @CanIgnoreReturnValue
        public Options setEdgeType(S2Builder.EdgeType edgeType) {
            this.edgeType = edgeType;
            return this;
        }

        public S2Builder.EdgeType edgeType() {
            return this.edgeType;
        }

        @CanIgnoreReturnValue
        public Options setPolylineType(S2BuilderGraph.PolylineType polylineType) {
            this.polylineType = polylineType;
            return this;
        }

        public S2BuilderGraph.PolylineType polylineType() {
            return this.polylineType;
        }

        @CanIgnoreReturnValue
        public Options setDuplicateEdges(S2Builder.GraphOptions.DuplicateEdges duplicateEdges) {
            this.duplicateEdges = duplicateEdges;
            return this;
        }

        public S2Builder.GraphOptions.DuplicateEdges duplicateEdges() {
            return this.duplicateEdges;
        }

        @CanIgnoreReturnValue
        public Options setSiblingPairs(S2Builder.GraphOptions.SiblingPairs siblingPairs) {
            Preconditions.checkArgument((siblingPairs == S2Builder.GraphOptions.SiblingPairs.KEEP || siblingPairs == S2Builder.GraphOptions.SiblingPairs.DISCARD ? 1 : 0) != 0);
            this.siblingPairs = siblingPairs;
            return this;
        }

        public S2Builder.GraphOptions.SiblingPairs siblingPairs() {
            return this.siblingPairs;
        }

        @CanIgnoreReturnValue
        public Options setValidate(boolean validate) {
            this.validate = validate;
            return this;
        }

        public boolean validate() {
            return this.validate;
        }
    }
}

