/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.geometry.S2;
import com.google.common.geometry.S2Point;
import com.google.errorprone.annotations.InlineMe;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import jsinterop.annotations.JsConstructor;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;

@JsType
public interface S2Shape {
    public int numEdges();

    public void getEdge(int var1, MutableEdge var2);

    public boolean hasInterior();

    public boolean containsOrigin();

    public int numChains();

    public int getChainStart(int var1);

    public int getChainLength(int var1);

    public void getChainEdge(int var1, int var2, MutableEdge var3);

    public void getChainPosition(int var1, ChainPosition var2);

    public S2Point getChainVertex(int var1, int var2);

    default public int nextEdgeWrap(int edgeId) {
        if (!3.$assertionsDisabled && edgeId < 0) {
            throw new AssertionError();
        }
        if (!3.$assertionsDisabled && edgeId >= this.numEdges()) {
            throw new AssertionError();
        }
        ChainPosition chainPos = new ChainPosition();
        this.getChainPosition(edgeId, chainPos);
        int chainLength = this.getChainLength(chainPos.chainId);
        int offset = chainPos.offset;
        switch (this.dimension()) {
            case 2: {
                offset = (offset + 1) % chainLength;
                break;
            }
            case 1: {
                S2Point next;
                if (++offset != chainLength) break;
                S2Point curr = this.getChainVertex(chainPos.chainId, chainLength);
                if (curr.equalsPoint(next = this.getChainVertex(chainPos.chainId, 0))) {
                    offset = 0;
                    break;
                }
                return -1;
            }
            default: {
                return -1;
            }
        }
        return this.getChainStart(chainPos.chainId) + offset;
    }

    default public int prevEdgeWrap(int edgeId) {
        if (!3.$assertionsDisabled && edgeId < 0) {
            throw new AssertionError();
        }
        if (!3.$assertionsDisabled && edgeId >= this.numEdges()) {
            throw new AssertionError();
        }
        ChainPosition chainPos = new ChainPosition();
        this.getChainPosition(edgeId, chainPos);
        int chainLength = this.getChainLength(chainPos.chainId);
        int offset = chainPos.offset;
        switch (this.dimension()) {
            case 2: {
                if (--offset >= 0) break;
                offset += chainLength;
                break;
            }
            case 1: {
                if (--offset >= 0) break;
                S2Point curr = this.getChainVertex(chainPos.chainId, 0);
                S2Point prev = this.getChainVertex(chainPos.chainId, chainLength);
                if (prev.equalsPoint(curr)) {
                    offset += chainLength;
                    break;
                }
                return -1;
            }
            default: {
                return -1;
            }
        }
        return this.getChainStart(chainPos.chainId) + offset;
    }

    default public List<S2Point> chain(final int chain) {
        return new AbstractList<S2Point>(){
            int length;
            {
                this.length = S2Shape.this.getChainLength(chain) + (S2Shape.this.dimension() & 1);
            }

            @Override
            public int size() {
                return this.length;
            }

            @Override
            public S2Point get(int index) {
                return S2Shape.this.getChainVertex(chain, index);
            }
        };
    }

    default public List<List<S2Point>> chains() {
        return new AbstractList<List<S2Point>>(){

            @Override
            public int size() {
                return S2Shape.this.numChains();
            }

            @Override
            public List<S2Point> get(int index) {
                return S2Shape.this.chain(index);
            }
        };
    }

    public int dimension();

    default public boolean isEmpty() {
        return this.numEdges() == 0 && (this.dimension() < 2 || this.numChains() == 0);
    }

    default public boolean isFull() {
        return this.numEdges() == 0 && this.dimension() == 2 && this.numChains() > 0;
    }

    default public ReferencePoint getReferencePoint() {
        Preconditions.checkState((this.dimension() == 2 ? 1 : 0) != 0);
        return ReferencePoint.create(S2.origin(), this.containsOrigin());
    }

    static {
        if (3.$assertionsDisabled) {
            // empty if block
        }
    }

    @JsType
    public static abstract class ReferencePoint {
        private static final ReferencePoint ORIGIN_INSIDE = ReferencePoint.create(S2.origin(), true);
        private static final ReferencePoint ORIGIN_OUTSIDE = ReferencePoint.create(S2.origin(), false);
        private final S2Point point;

        @JsConstructor
        private ReferencePoint(S2Point p) {
            this.point = p;
        }

        public S2Point point() {
            return this.point;
        }

        public abstract boolean contained();

        public static ReferencePoint create(boolean contained) {
            return contained ? ORIGIN_INSIDE : ORIGIN_OUTSIDE;
        }

        @JsMethod(name="createfromPoint")
        public static ReferencePoint create(S2Point p, boolean contained) {
            if (contained) {
                return new ReferencePoint(p){

                    @Override
                    public boolean contained() {
                        return true;
                    }
                };
            }
            return new ReferencePoint(p){

                @Override
                public boolean contained() {
                    return false;
                }
            };
        }

        public boolean equalsPoint(S2Point p) {
            return this.point.equalsPoint(p);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ReferencePoint)) {
                return false;
            }
            ReferencePoint that = (ReferencePoint)o;
            return this.point.equalsPoint(that.point) && this.contained() == that.contained();
        }

        public int hashCode() {
            return Objects.hash(this.point, this.contained());
        }
    }

    @JsType
    public static final class ChainPosition {
        int chainId;
        int offset;

        public void set(int chainId, int offset) {
            this.chainId = chainId;
            this.offset = offset;
        }

        public int getChainId() {
            return this.chainId;
        }

        public int getOffset() {
            return this.offset;
        }

        public boolean isEqualTo(ChainPosition other) {
            return this.chainId == other.chainId && this.offset == other.offset;
        }
    }

    @JsType
    public static final class MutableEdge {
        public S2Point a = null;
        public S2Point b = null;

        public static MutableEdge of(S2Point a, S2Point b) {
            MutableEdge e = new MutableEdge();
            e.a = a;
            e.b = b;
            return e;
        }

        public S2Point getStart() {
            return this.a;
        }

        public S2Point getEnd() {
            return this.b;
        }

        public boolean isDegenerate() {
            return this.a.equalsPoint(this.b);
        }

        @Deprecated
        @InlineMe(replacement="this.hasEndpoint(point)")
        public boolean isEndpoint(S2Point point) {
            return this.hasEndpoint(point);
        }

        public boolean hasEndpoint(S2Point point) {
            return this.a.equalsPoint(point) || this.b.equalsPoint(point);
        }

        public boolean isEqualTo(MutableEdge other) {
            return this.a.equalsPoint(other.a) && this.b.equalsPoint(other.b);
        }

        public boolean isSiblingOf(MutableEdge other) {
            return this.a.equalsPoint(other.b) && this.b.equalsPoint(other.a);
        }

        public void set(S2Point start, S2Point end) {
            this.a = start;
            this.b = end;
        }

        public void reverse() {
            S2Point t = this.a;
            this.a = this.b;
            this.b = t;
        }

        public String toDegreesString() {
            return (this.a == null ? "null" : this.a.toDegreesString()) + "-" + (this.b == null ? "null" : this.b.toDegreesString());
        }

        public String toString() {
            return this.toDegreesString();
        }
    }
}

