/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S1ChordAngle;
import com.google.common.geometry.S2Cap;
import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2ClosestEdgeQuery;
import com.google.common.geometry.S2LatLngRect;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Projections;
import com.google.common.geometry.S2Region;
import com.google.common.geometry.S2ShapeIndex;
import com.google.common.geometry.S2ShapeIndexRegion;
import java.util.ArrayList;
import java.util.Collection;
import jsinterop.annotations.JsMethod;

public class S2ShapeIndexBufferedRegion
implements S2Region {
    private final S1ChordAngle radius;
    private final S2ClosestEdgeQuery<S1ChordAngle> query;
    private S2ShapeIndexRegion shapeIndexRegion = null;
    private final S1ChordAngle radiusSuccessor;

    public S2ShapeIndexBufferedRegion(S2ShapeIndex index, S1ChordAngle radius) {
        this.radius = radius;
        this.radiusSuccessor = radius.successor();
        this.query = S2ClosestEdgeQuery.builder().setIncludeInteriors(true).build(index);
    }

    public S2ShapeIndexBufferedRegion(S2ShapeIndex index, S1Angle radius) {
        this(index, S1ChordAngle.fromS1Angle(radius));
    }

    public S2ShapeIndex index() {
        return this.query.index();
    }

    public S1ChordAngle radius() {
        return this.radius;
    }

    private S2ShapeIndexRegion makeS2ShapeIndexRegion() {
        if (this.shapeIndexRegion == null) {
            this.shapeIndexRegion = new S2ShapeIndexRegion(this.index());
        }
        return this.shapeIndexRegion;
    }

    @Override
    public S2Cap getCapBound() {
        S2Cap origCap = this.makeS2ShapeIndexRegion().getCapBound();
        if (origCap.isEmpty()) {
            return origCap;
        }
        return S2Cap.fromAxisChord(origCap.axis(), S1ChordAngle.add(origCap.radius(), this.radius));
    }

    @Override
    public S2LatLngRect getRectBound() {
        S2LatLngRect origRect = this.makeS2ShapeIndexRegion().getRectBound();
        return origRect.expandedByDistance(this.radius.toAngle());
    }

    @Override
    public void getCellUnionBound(Collection<S2CellId> results) {
        double radians = this.radius.toAngle().radians();
        int maxLevel = S2Projections.MIN_WIDTH.getMaxLevel(radians) - 1;
        if (maxLevel < 0) {
            S2Cap.full().getCellUnionBound(results);
            return;
        }
        ArrayList<S2CellId> origCellIds = new ArrayList<S2CellId>(6);
        new S2ShapeIndexRegion(this.index()).getCellUnionBound(origCellIds);
        results.clear();
        for (S2CellId id : origCellIds) {
            if (id.isFace()) {
                S2Cap.full().getCellUnionBound(results);
                return;
            }
            id.getVertexNeighbors(Math.min(maxLevel, id.level() - 1), results);
        }
    }

    @Override
    @JsMethod(name="containsCell")
    public boolean contains(S2Cell cell) {
        if (this.radiusSuccessor.greaterThan(S1ChordAngle.STRAIGHT)) {
            return true;
        }
        if (this.makeS2ShapeIndexRegion().contains(cell)) {
            return true;
        }
        S2Cap cap = cell.getCapBound();
        if (this.radius.lessThan(cap.radius())) {
            return false;
        }
        S2ClosestEdgeQuery.PointTarget target = new S2ClosestEdgeQuery.PointTarget(cell.getCenter());
        return this.query.isDistanceLess(target, S1ChordAngle.sub(this.radiusSuccessor, cap.radius()));
    }

    @Override
    @JsMethod(name="containsPoint")
    public boolean contains(S2Point p) {
        return this.query.isDistanceLess(new S2ClosestEdgeQuery.PointTarget(p), this.radiusSuccessor);
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        return this.query.isDistanceLess(new S2ClosestEdgeQuery.CellTarget(cell), this.radiusSuccessor);
    }
}

