/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Shape;
import com.google.common.geometry.S2ShapeIndex;
import com.google.common.geometry.S2ShapeMeasures;

public final class S2ShapeIndexMeasures {
    private S2ShapeIndexMeasures() {
    }

    public static int dimension(S2ShapeIndex shapeIndex) {
        int dimension = -1;
        for (S2Shape shape : shapeIndex.getShapes()) {
            dimension = Math.max(dimension, shape.dimension());
        }
        return dimension;
    }

    public static S1Angle length(S2ShapeIndex shapeIndex) {
        S1Angle.Builder builder = new S1Angle.Builder();
        for (S2Shape shape : shapeIndex.getShapes()) {
            builder.add(S2ShapeMeasures.length(shape));
        }
        return builder.build();
    }

    public static S1Angle perimeter(S2ShapeIndex shapeIndex) {
        S1Angle.Builder builder = new S1Angle.Builder();
        for (S2Shape shape : shapeIndex.getShapes()) {
            builder.add(S2ShapeMeasures.perimeter(shape));
        }
        return builder.build();
    }

    public static double area(S2ShapeIndex shapeIndex) {
        double area = 0.0;
        for (S2Shape shape : shapeIndex.getShapes()) {
            area += S2ShapeMeasures.area(shape);
        }
        return area;
    }

    public static boolean areaIsGreaterThan(S2ShapeIndex shapeIndex, double threshold) {
        double area = 0.0;
        for (S2Shape shape : shapeIndex.getShapes()) {
            if (!((area += S2ShapeMeasures.area(shape)) > threshold)) continue;
            return true;
        }
        return area > threshold;
    }

    public static S2Point centroid(S2ShapeIndex shapeIndex) {
        int dimension = S2ShapeIndexMeasures.dimension(shapeIndex);
        S2Point.Builder builder = new S2Point.Builder();
        for (S2Shape shape : shapeIndex.getShapes()) {
            if (shape.dimension() != dimension) continue;
            builder.add(S2ShapeMeasures.centroid(shape));
        }
        return builder.build();
    }
}

