/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.geometry.R2Rect;
import com.google.common.geometry.R2Vector;
import com.google.common.geometry.S2Cap;
import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2CellUnion;
import com.google.common.geometry.S2ContainsPointQuery;
import com.google.common.geometry.S2EdgeUtil;
import com.google.common.geometry.S2Iterator;
import com.google.common.geometry.S2LatLngRect;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Region;
import com.google.common.geometry.S2Shape;
import com.google.common.geometry.S2ShapeIndex;
import com.google.common.geometry.primitives.IntVector;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;

public class S2ShapeIndexRegion
implements S2Region {
    private final S2ContainsPointQuery containsQuery;
    private final S2ShapeIndex index;
    private final S2Iterator<S2ShapeIndex.Cell> it;
    private final S2CellUnion union = new S2CellUnion();
    private final S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
    private final R2Rect bound = new R2Rect();
    private final R2Vector p0 = new R2Vector();
    private final R2Vector p1 = new R2Vector();
    private final IntVector ids = new IntVector();

    public S2ShapeIndexRegion(S2ShapeIndex index) {
        this(index, S2ContainsPointQuery.S2VertexModel.SEMI_OPEN);
    }

    public S2ShapeIndexRegion(S2ShapeIndex index, S2ContainsPointQuery.S2VertexModel model) {
        this.index = index;
        this.it = index.iterator();
        this.containsQuery = new S2ContainsPointQuery(index, new S2ContainsPointQuery.Options(model));
    }

    @Override
    public S2Cap getCapBound() {
        this.getCellUnionBound(this.union.cellIds());
        return this.union.getCapBound();
    }

    @Override
    public S2LatLngRect getRectBound() {
        this.getCellUnionBound(this.union.cellIds());
        return this.union.getRectBound();
    }

    @Override
    public void getCellUnionBound(Collection<S2CellId> cellIds) {
        cellIds.clear();
        this.it.finish();
        if (!this.it.prev()) {
            return;
        }
        S2CellId lastIndexId = this.it.id();
        this.it.restart();
        S2CellId currentIndexId = this.it.id();
        if (!currentIndexId.equals(lastIndexId)) {
            int level = currentIndexId.getCommonAncestorLevel(lastIndexId) + 1;
            S2CellId lastId = lastIndexId.parent(level);
            S2CellId id = currentIndexId.parent(level);
            while (!id.equals(lastId)) {
                S2CellId max = id.rangeMax();
                if (!max.lessThan(currentIndexId)) {
                    this.it.seek(max.next());
                    this.it.prev();
                    S2ShapeIndexRegion.coverRange(currentIndexId, this.it.id(), cellIds);
                    this.it.next();
                    currentIndexId = this.it.id();
                }
                id = id.next();
            }
        }
        S2ShapeIndexRegion.coverRange(currentIndexId, lastIndexId, cellIds);
    }

    private static void coverRange(S2CellId first, S2CellId last, Collection<S2CellId> cellIds) {
        if (first.equals(last)) {
            cellIds.add(first);
        } else {
            int level = first.getCommonAncestorLevel(last);
            Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (Object)"First and last must have a common ancestor.");
            cellIds.add(first.parent(level));
        }
    }

    @Override
    public boolean contains(S2Point p) {
        if (this.it.locate(p)) {
            S2Point center = this.it.center();
            S2ShapeIndex.Cell cell = this.it.entry();
            for (int s = 0; s < cell.numShapes(); ++s) {
                if (!this.containsQuery.shapeContains(center, cell.clipped(s), p)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(S2Cell target) {
        S2ShapeIndex.CellRelation relation = this.it.locate(target.id());
        if (relation != S2ShapeIndex.CellRelation.INDEXED) {
            return false;
        }
        S2ShapeIndex.Cell cell = this.it.entry();
        S2Point center = this.it.center();
        for (int s = 0; s < cell.numShapes(); ++s) {
            S2Shape shape;
            S2ShapeIndex.S2ClippedShape clipped = cell.clipped(s);
            if (!(this.it.id().equals(target.id()) ? clipped.numEdges() == 0 && clipped.containsCenter() : (shape = this.index.getShapes().get(clipped.shapeId())).hasInterior() && !this.anyEdgeIntersects(clipped, target) && this.containsQuery.shapeContains(center, clipped, target.getCenter()))) continue;
            return true;
        }
        return false;
    }

    @CanIgnoreReturnValue
    public boolean visitIntersectingShapes(S2Cell target, ShapeVisitor visitor) {
        S2ShapeIndex.CellRelation relation = this.it.locate(target.id());
        switch (relation) {
            case DISJOINT: {
                return true;
            }
            case SUBDIVIDED: {
                this.ids.clear();
                S2CellId max = target.id().rangeMax();
                while (!this.it.done() && this.it.id().lessOrEquals(max)) {
                    S2ShapeIndex.Cell cell = this.it.entry();
                    for (int s = 0; s < cell.numShapes(); ++s) {
                        S2ShapeIndex.S2ClippedShape clipped = cell.clipped(s);
                        boolean containsTarget = clipped.numEdges() == 0 && clipped.containsCenter();
                        this.ids.add(clipped.shapeId() << 1 | (containsTarget ? 1 : 0));
                    }
                    this.it.next();
                }
                this.ids.sort();
                this.ids.unique();
                int last = -1;
                for (int i = 0; i < this.ids.size(); ++i) {
                    int id = this.ids.get(i);
                    boolean contains = (id & 1) != 0;
                    int shapeId = id >>> 1;
                    if (last != shapeId && !visitor.test(shapeId, contains)) {
                        return false;
                    }
                    last = shapeId;
                }
                return true;
            }
            case INDEXED: {
                S2ShapeIndex.Cell cell = this.it.entry();
                for (int s = 0; s < cell.numShapes(); ++s) {
                    S2ShapeIndex.S2ClippedShape clipped = cell.clipped(s);
                    boolean contains = false;
                    if (cell.id() == target.id().id()) {
                        contains = clipped.numEdges() == 0 && clipped.containsCenter();
                    } else if (!this.anyEdgeIntersects(clipped, target)) {
                        if (!this.containsQuery.shapeContains(this.it.center(), clipped, target.getCenter())) continue;
                        contains = true;
                    }
                    if (visitor.test(clipped.shapeId(), contains)) continue;
                    return false;
                }
                return true;
            }
        }
        throw new IllegalStateException("Unknown S2ShapeIndex.CellRelation " + relation);
    }

    @Override
    public boolean mayIntersect(S2Cell target) {
        S2ShapeIndex.CellRelation relation = this.it.locate(target.id());
        if (relation == S2ShapeIndex.CellRelation.DISJOINT) {
            return false;
        }
        if (relation == S2ShapeIndex.CellRelation.SUBDIVIDED) {
            return true;
        }
        if (this.it.compareTo(target.id()) == 0) {
            return true;
        }
        S2ShapeIndex.Cell cell = this.it.entry();
        S2Point center = this.it.center();
        for (int s = 0; s < cell.numShapes(); ++s) {
            S2ShapeIndex.S2ClippedShape clipped = cell.clipped(s);
            if (!this.anyEdgeIntersects(clipped, target) && !this.containsQuery.shapeContains(center, clipped, target.getCenter())) continue;
            return true;
        }
        return false;
    }

    private boolean anyEdgeIntersects(S2ShapeIndex.S2ClippedShape clipped, S2Cell target) {
        target.setBoundUV(this.bound);
        this.bound.expand(S2EdgeUtil.MAX_CELL_EDGE_ERROR);
        int face = target.face();
        S2Shape shape = this.index.getShapes().get(clipped.shapeId());
        int numEdges = clipped.numEdges();
        for (int i = 0; i < numEdges; ++i) {
            shape.getEdge(clipped.edge(i), this.edge);
            if (!S2EdgeUtil.clipToPaddedFace(this.edge.a, this.edge.b, face, S2EdgeUtil.MAX_CELL_EDGE_ERROR, this.p0, this.p1) || !S2EdgeUtil.intersectsRect(this.p0, this.p1, this.bound)) continue;
            return true;
        }
        return false;
    }

    public static interface ShapeVisitor {
        public boolean test(int var1, boolean var2);
    }
}

