/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.geometry.Platform;
import com.google.common.geometry.S2BuilderGraph;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2CellUnion;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2LatLngRect;
import com.google.common.geometry.S2LaxPolygonShape;
import com.google.common.geometry.S2LaxPolylineShape;
import com.google.common.geometry.S2Loop;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Polygon;
import com.google.common.geometry.S2Polyline;
import com.google.common.geometry.S2Shape;
import com.google.common.geometry.S2ShapeIndex;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jspecify.annotations.Nullable;

public final class S2TextFormat {
    public static S2Point makePointOrDie(String str) throws IllegalArgumentException {
        S2Point point = S2TextFormat.makePoint(str);
        Preconditions.checkArgument((point != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return point;
    }

    public static @Nullable S2Point makePoint(String str) {
        List<S2Point> vertices = S2TextFormat.parsePoints(str);
        if (vertices == null || vertices.size() != 1) {
            return null;
        }
        return vertices.get(0);
    }

    public static List<S2LatLng> parseLatLngsOrDie(String str) throws IllegalArgumentException {
        List<S2LatLng> latlngs = S2TextFormat.parseLatLngs(str);
        Preconditions.checkArgument((latlngs != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return latlngs;
    }

    static @Nullable List<S2LatLng> parseLatLngs(String str) {
        ImmutableList<ParseEntry> ps = S2TextFormat.dictionaryParse(str);
        if (ps == null) {
            return null;
        }
        ArrayList<S2LatLng> latlngs = new ArrayList<S2LatLng>();
        for (ParseEntry p : ps) {
            Double lat = Double.parseDouble(p.key);
            if (lat == null) {
                return null;
            }
            Double lng = Double.parseDouble(p.value);
            if (lng == null) {
                return null;
            }
            latlngs.add(S2LatLng.fromDegrees(lat, lng));
        }
        return latlngs;
    }

    public static List<S2Point> makePointsOrDie(String str) {
        ArrayList<S2Point> result = new ArrayList<S2Point>();
        for (String lineStr : S2TextFormat.splitString(str, "\\|")) {
            result.add(S2TextFormat.makePointOrDie(lineStr));
        }
        return result;
    }

    public static List<S2Point> parsePointsOrDie(String str) throws IllegalArgumentException {
        List<S2Point> vertices = S2TextFormat.parsePoints(str);
        Preconditions.checkArgument((vertices != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return vertices;
    }

    public static @Nullable List<S2Point> parsePoints(String str) {
        return S2TextFormat.parsePoints(str, -1);
    }

    public static @Nullable List<S2Point> parsePoints(String str, int level) {
        List<S2LatLng> latlngs = S2TextFormat.parseLatLngs(str);
        if (latlngs == null) {
            return null;
        }
        ArrayList<S2Point> vertices = new ArrayList<S2Point>();
        for (S2LatLng latlng : latlngs) {
            S2Point vertex = latlng.toPoint();
            if (level >= 0) {
                vertex = S2TextFormat.snapPointToLevel(vertex, level);
            }
            vertices.add(vertex);
        }
        return vertices;
    }

    @CanIgnoreReturnValue
    public static S2LatLngRect parseVertices(String str, List<S2Point> vertices) {
        List<S2Point> points = S2TextFormat.parsePoints(str);
        S2LatLngRect.Builder builder = S2LatLngRect.Builder.empty();
        for (S2Point point : points) {
            vertices.add(point);
            builder.addPoint(point);
        }
        return builder.build();
    }

    public static S2Point snapPointToLevel(S2Point point, int level) {
        return S2CellId.fromPoint(point).parent(level).toPoint();
    }

    public static List<S2Point> snapPointsToLevel(List<S2Point> points, int level) {
        ArrayList<S2Point> snapped = new ArrayList<S2Point>(points.size());
        for (S2Point p : points) {
            snapped.add(S2TextFormat.snapPointToLevel(p, level));
        }
        return snapped;
    }

    public static S2LatLng makeLatLngOrDie(String str) throws IllegalArgumentException {
        S2LatLng latlng = S2TextFormat.makeLatLng(str);
        Preconditions.checkArgument((latlng != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return latlng;
    }

    public static @Nullable S2LatLng makeLatLng(String str) {
        List<S2LatLng> latlngs = S2TextFormat.parseLatLngs(str);
        if (latlngs == null || latlngs.size() != 1) {
            return null;
        }
        return latlngs.get(0);
    }

    public static S2LatLngRect makeLatLngRectOrDie(String str) throws IllegalArgumentException {
        S2LatLngRect rect = S2TextFormat.makeLatLngRect(str);
        Preconditions.checkArgument((rect != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return rect;
    }

    public static @Nullable S2LatLngRect makeLatLngRect(String str) {
        List<S2LatLng> latlngs = S2TextFormat.parseLatLngs(str);
        if (latlngs == null || latlngs.isEmpty()) {
            return null;
        }
        S2LatLngRect rect = S2LatLngRect.fromPoint(latlngs.get(0));
        for (int i = 1; i < latlngs.size(); ++i) {
            rect = rect.addPoint(latlngs.get(i));
        }
        return rect;
    }

    public static S2CellId makeCellIdOrDie(String str) throws IllegalArgumentException {
        S2CellId cellId = S2TextFormat.makeCellId(str);
        Preconditions.checkArgument((cellId != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return cellId;
    }

    public static @Nullable S2CellId makeCellId(String str) {
        S2CellId cellId = S2CellId.fromDebugString(str);
        if (cellId.equals(S2CellId.none())) {
            return null;
        }
        return cellId;
    }

    public static S2CellUnion makeCellUnionOrDie(String str) throws IllegalArgumentException {
        S2CellUnion cellUnion = S2TextFormat.makeCellUnion(str);
        Preconditions.checkArgument((cellUnion != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return cellUnion;
    }

    public static @Nullable S2CellUnion makeCellUnion(String str) {
        ArrayList<S2CellId> cellIds = new ArrayList<S2CellId>();
        for (String cellStr : S2TextFormat.splitString(str, ",")) {
            S2CellId cellId = S2TextFormat.makeCellId(cellStr = cellStr.trim());
            if (cellId == null) {
                return null;
            }
            cellIds.add(cellId);
        }
        return new S2CellUnion().initFromCellIds(cellIds);
    }

    public static S2Loop makeLoopOrDie(String str) throws IllegalArgumentException {
        return S2TextFormat.makeLoopOrDie(str, -1);
    }

    public static S2Loop makeLoopOrDie(String str, int level) throws IllegalArgumentException {
        S2Loop loop = S2TextFormat.makeLoop(str, level);
        Preconditions.checkArgument((loop != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return loop;
    }

    public static @Nullable S2Loop makeLoop(String str) {
        return S2TextFormat.makeLoop(str, -1);
    }

    public static @Nullable S2Loop makeLoop(String str, int level) {
        if ("empty".equalsIgnoreCase(str)) {
            return S2Loop.empty();
        }
        if ("full".equalsIgnoreCase(str)) {
            return S2Loop.full();
        }
        List<S2Point> vertices = S2TextFormat.parsePoints(str, level);
        if (vertices == null) {
            return null;
        }
        return new S2Loop(vertices);
    }

    public static S2Loop makeLoop(S2Point ... vertices) {
        return new S2Loop(vertices);
    }

    public static List<S2Polyline> makePolylinesOrDie(String str) {
        ArrayList<S2Polyline> result = new ArrayList<S2Polyline>();
        for (String lineStr : S2TextFormat.splitString(str, "\\|")) {
            result.add(S2TextFormat.makePolylineOrDie(lineStr));
        }
        return result;
    }

    public static S2Polyline makePolylineOrDie(String str) throws IllegalArgumentException {
        S2Polyline polyline = S2TextFormat.makePolyline(str);
        Preconditions.checkArgument((polyline != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return polyline;
    }

    public static @Nullable S2Polyline makePolyline(String str) {
        List<S2Point> vertices = S2TextFormat.parsePoints(str);
        if (vertices == null) {
            return null;
        }
        return new S2Polyline(vertices);
    }

    public static S2Polyline makePolylineWithEncodeDecodeRoundtrip(String str) {
        ArrayList vertices = Lists.newArrayList();
        S2TextFormat.parseVertices(str, vertices);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            new S2Polyline(vertices).encode(bos);
            return S2Polyline.decode(new ByteArrayInputStream(bos.toByteArray()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static S2LaxPolylineShape makeLaxPolylineOrDie(String str) throws IllegalArgumentException {
        S2LaxPolylineShape laxPolyline = S2TextFormat.makeLaxPolyline(str);
        Preconditions.checkArgument((laxPolyline != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return laxPolyline;
    }

    public static @Nullable S2LaxPolylineShape makeLaxPolyline(String str) {
        List<S2Point> vertices = S2TextFormat.parsePoints(str);
        if (vertices == null) {
            return null;
        }
        return S2LaxPolylineShape.create(vertices);
    }

    public static List<S2Polygon> makePolygonsOrDie(String str) {
        ArrayList<S2Polygon> result = new ArrayList<S2Polygon>();
        for (String polyStr : S2TextFormat.splitString(str, "\\|")) {
            result.add(S2TextFormat.makePolygonOrDie(polyStr));
        }
        return result;
    }

    public static S2Polygon makePolygonOrDie(String str) throws IllegalArgumentException {
        S2Polygon polygon = S2TextFormat.makePolygon(str);
        Preconditions.checkArgument((polygon != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return polygon;
    }

    public static S2Polygon makePolygonOrDie(String str, int level) throws IllegalArgumentException {
        S2Polygon polygon = S2TextFormat.makePolygon(str, level);
        Preconditions.checkArgument((polygon != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return polygon;
    }

    public static @Nullable S2Polygon makePolygon(String str) {
        return S2TextFormat.makePolygon(str, -1);
    }

    public static @Nullable S2Polygon makePolygon(String str, int level) {
        return S2TextFormat.internalMakePolygon(str, true, level);
    }

    public static S2LaxPolygonShape makeLaxPolygonOrDie(String str) throws IllegalArgumentException {
        S2LaxPolygonShape laxPolygon = S2TextFormat.makeLaxPolygon(str);
        Preconditions.checkArgument((laxPolygon != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return laxPolygon;
    }

    public static @Nullable S2LaxPolygonShape makeLaxPolygon(String str) {
        List<String> loopStrs = S2TextFormat.splitString(str, ";");
        ArrayList<List<Object>> loops = new ArrayList<List<Object>>();
        for (String loopStr : loopStrs) {
            if (loopStr.equals("full")) {
                loops.add(new ArrayList());
                continue;
            }
            if (loopStr.equals("empty")) continue;
            List<S2Point> points = S2TextFormat.parsePoints(loopStr);
            if (points == null) {
                return null;
            }
            loops.add(points);
        }
        return S2LaxPolygonShape.create(loops);
    }

    public static S2ShapeIndex makeIndexOrDie(String str) throws IllegalArgumentException {
        S2ShapeIndex index = S2TextFormat.makeIndex(str);
        Preconditions.checkArgument((index != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return index;
    }

    public static @Nullable S2ShapeIndex makeIndex(String str) {
        String[] strs = str.split("#", -1);
        if (strs.length != 3) {
            return null;
        }
        ArrayList<S2Point> points = new ArrayList<S2Point>();
        for (String pointStr : S2TextFormat.splitString(strs[0], "\\|")) {
            S2Point point = S2TextFormat.makePoint(pointStr);
            if (point == null) {
                return null;
            }
            points.add(point);
        }
        S2ShapeIndex index = new S2ShapeIndex();
        if (!points.isEmpty()) {
            index.add(S2Point.Shape.fromList(points));
        }
        for (String lineStr : S2TextFormat.splitString(strs[1], "\\|")) {
            S2LaxPolylineShape laxPolyline = S2TextFormat.makeLaxPolyline(lineStr);
            if (laxPolyline == null) {
                return null;
            }
            index.add(laxPolyline);
        }
        for (String polygonStr : S2TextFormat.splitString(strs[2], "\\|")) {
            S2LaxPolygonShape laxPolygon = S2TextFormat.makeLaxPolygon(polygonStr);
            if (laxPolygon == null) {
                return null;
            }
            index.add(laxPolygon);
        }
        return index;
    }

    public static S2ShapeIndex makeIndexWithLegacyShapes(String str) {
        S2ShapeIndex index = new S2ShapeIndex();
        ImmutableList strs = ImmutableList.copyOf((Iterable)Splitter.on((char)'#').split((CharSequence)str));
        Preconditions.checkArgument((strs.size() == 3 ? 1 : 0) != 0, (String)"Must contain two # characters: %s", (Object)str);
        ArrayList<S2Point> points = new ArrayList<S2Point>();
        for (String point : Splitter.on((char)'|').omitEmptyStrings().split((CharSequence)((String)strs.get(0)).trim())) {
            points.add(S2TextFormat.makePoint(point));
        }
        if (!points.isEmpty()) {
            index.add(S2Point.Shape.fromList(points));
        }
        for (String line : Splitter.on((char)'|').omitEmptyStrings().split((CharSequence)((String)strs.get(1)).trim())) {
            index.add(S2TextFormat.makePolyline(line));
        }
        for (String polygon : Splitter.on((char)'|').omitEmptyStrings().split((CharSequence)((String)strs.get(2)).trim())) {
            index.add(S2TextFormat.makePolygon(polygon).shape());
        }
        return index;
    }

    public static String toString(S2Point s2Point) {
        StringBuilder out = new StringBuilder();
        S2TextFormat.appendVertex(s2Point, out);
        return out.toString();
    }

    public static String toString(S2LatLng latlng) {
        StringBuilder out = new StringBuilder();
        S2TextFormat.appendVertex(latlng, out);
        return out.toString();
    }

    public static String toString(S2LatLngRect rect) {
        StringBuilder out = new StringBuilder();
        S2TextFormat.appendVertex(rect.lo(), out);
        out.append(", ");
        S2TextFormat.appendVertex(rect.hi(), out);
        return out.toString();
    }

    public static String toString(S2CellId cellId) {
        return cellId.toString();
    }

    public static String toString(S2CellUnion cellUnion) {
        StringBuilder out = new StringBuilder();
        for (S2CellId cellId : cellUnion) {
            if (out.length() > 0) {
                out.append(", ");
            }
            out.append(cellId.toString());
        }
        return out.toString();
    }

    public static String toString(S2Loop loop) {
        if (loop.isEmpty()) {
            return "empty";
        }
        if (loop.isFull()) {
            return "full";
        }
        StringBuilder out = new StringBuilder();
        if (loop.numVertices() > 0) {
            S2TextFormat.appendVertices(loop.vertices(), out);
        }
        return out.toString();
    }

    public static String toString(S2Polyline polyline) {
        StringBuilder out = new StringBuilder();
        if (polyline.numVertices() > 0) {
            S2TextFormat.appendVertices(polyline.vertices(), out);
        }
        return out.toString();
    }

    public static String toString(List<S2Point> linePoints) {
        StringBuilder out = new StringBuilder();
        if (!linePoints.isEmpty()) {
            S2TextFormat.appendVertices(linePoints, out);
        }
        return out.toString();
    }

    public static String toString(S2Polygon polygon) {
        return S2TextFormat.toString(polygon, ";\n");
    }

    public static String toString(S2Polygon polygon, String loopSeparator) {
        if (polygon.isEmpty()) {
            return "empty";
        }
        if (polygon.isFull()) {
            return "full";
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < polygon.numLoops(); ++i) {
            if (i > 0) {
                out.append(loopSeparator);
            }
            S2TextFormat.appendVertices(polygon.loop(i).vertices(), out);
        }
        return out.toString();
    }

    public static String toString(S2LaxPolylineShape polyline) {
        StringBuilder out = new StringBuilder();
        if (polyline.numVertices() > 0) {
            S2TextFormat.appendVertices(polyline.vertices(), out);
        }
        return out.toString();
    }

    public static String toString(S2LaxPolygonShape polygon) {
        return S2TextFormat.toString(polygon, ";\n");
    }

    public static String toString(S2LaxPolygonShape polygon, String loopSeparator) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < polygon.numChains(); ++i) {
            int chainLength;
            if (i > 0) {
                out.append(loopSeparator);
            }
            if ((chainLength = polygon.getChainLength(i)) == 0) {
                out.append("full");
                continue;
            }
            for (int edgeOffset = 0; edgeOffset < chainLength; ++edgeOffset) {
                S2TextFormat.appendVertex(polygon.getChainVertex(i, edgeOffset), out);
                if (edgeOffset >= chainLength - 1) continue;
                out.append(", ");
            }
        }
        return out.toString();
    }

    public static String toString(S2ShapeIndex index) {
        StringBuilder out = new StringBuilder();
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        for (int dim = 0; dim < 3; ++dim) {
            if (dim > 0) {
                out.append("#");
            }
            int count = 0;
            for (S2Shape shape : index.getShapes()) {
                if (shape == null || shape.dimension() != dim) continue;
                out.append(count > 0 ? " | " : (dim > 0 ? " " : ""));
                int i = 0;
                while (i < shape.numChains()) {
                    if (i > 0) {
                        out.append(dim == 2 ? "; " : " | ");
                    }
                    if (shape.getChainLength(i) == 0) {
                        out.append("full");
                    } else {
                        shape.getChainEdge(i, 0, edge);
                        S2TextFormat.appendVertex(edge.getStart(), out);
                    }
                    int limit = shape.getChainLength(i);
                    if (dim != 1) {
                        --limit;
                    }
                    for (int edgeOffset = 0; edgeOffset < limit; ++edgeOffset) {
                        out.append(", ");
                        shape.getChainEdge(i, edgeOffset, edge);
                        S2TextFormat.appendVertex(edge.getEnd(), out);
                    }
                    ++i;
                    ++count;
                }
            }
            if (dim != 1 && (dim != 0 || count <= 0)) continue;
            out.append(" ");
        }
        return out.toString();
    }

    public static String toString(S2BuilderGraph graph) {
        StringBuilder sb = new StringBuilder();
        sb.append("Vertices: \n");
        for (int vertexId = 0; vertexId < graph.numVertices(); ++vertexId) {
            sb.append("  VertexId ").append(vertexId).append(" is point ").append(graph.vertex(vertexId)).append("\n");
        }
        sb.append("Edges: \n");
        for (int edgeId = 0; edgeId < graph.numEdges(); ++edgeId) {
            int setId = graph.inputEdgeIdSetIds().get(edgeId);
            sb.append("  EdgeId ").append(edgeId).append(" is edge (").append(graph.edgeSrcId(edgeId)).append(" - ").append(graph.edgeDstId(edgeId)).append(")\n").append("      with input edge ids: ").append(graph.inputEdgeIdSetLexicon().idSet(setId)).append("\n");
        }
        return sb.toString();
    }

    public static String summarizeIndex(S2ShapeIndex index) {
        StringBuilder sb = new StringBuilder();
        sb.append("Index has").append(index.getShapes().size()).append(" shapes.\n");
        for (int shapeId = 0; shapeId < index.getShapes().size(); ++shapeId) {
            S2Shape shape = index.getShapes().get(shapeId);
            sb.append("  Shape #").append(shapeId).append(" has dimension ").append(shape.dimension()).append(", ").append(shape.numEdges()).append(" edges, and ").append(shape.numChains()).append(" chains.").append("\n");
            for (int c = 0; c < shape.numChains(); ++c) {
                sb.append("    Chain #").append(c).append(" starts at shape edge #").append(shape.getChainStart(c)).append(" and has length ").append(shape.getChainLength(c)).append("\n");
            }
        }
        return sb.toString();
    }

    public static String s2PointsToString(List<S2Point> points) {
        StringBuilder out = new StringBuilder();
        S2TextFormat.appendVertices(points, out);
        return out.toString();
    }

    public static String s2LatLngsToString(List<S2LatLng> latlngs) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < latlngs.size(); ++i) {
            if (i > 0) {
                out.append(", ");
            }
            S2TextFormat.appendVertex(latlngs.get(i), out);
        }
        return out.toString();
    }

    public static List<String> splitString(String str, String regexp) {
        String[] parts = str.split(regexp);
        ArrayList<String> result = new ArrayList<String>();
        for (String part : parts) {
            if (part.trim().isEmpty()) continue;
            result.add(part.trim());
        }
        return result;
    }

    private static @Nullable ImmutableList<ParseEntry> dictionaryParse(String str) {
        String[] entries;
        if (str == null || str.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder items = new ImmutableList.Builder();
        for (String entry : entries = str.split(",", -1)) {
            if (entry.trim().isEmpty()) continue;
            String[] fields = entry.split(":", -1);
            if (fields.length != 2) {
                return null;
            }
            items.add((Object)new ParseEntry(fields[0], fields[1]));
        }
        return items.build();
    }

    static @Nullable S2Polygon internalMakePolygon(String str, boolean normalizeLoops, int level) {
        if (str.equals("empty")) {
            return new S2Polygon();
        }
        List<String> loopStrs = S2TextFormat.splitString(str, ";");
        ArrayList<S2Loop> loops = new ArrayList<S2Loop>();
        for (String loopStr : loopStrs) {
            S2Loop loop = S2TextFormat.makeLoop(loopStr, level);
            if (loop == null) {
                return null;
            }
            if (normalizeLoops && !loop.isFull()) {
                loop.normalize();
            }
            loops.add(loop);
        }
        return new S2Polygon(loops);
    }

    private static void appendVertex(S2LatLng ll, StringBuilder out) {
        out.append(Platform.formatDouble(ll.latDegrees())).append(':').append(Platform.formatDouble(ll.lngDegrees()));
    }

    private static void appendVertex(S2Point p, StringBuilder out) {
        if (p == null) {
            out.append("null");
            return;
        }
        S2TextFormat.appendVertex(new S2LatLng(p), out);
    }

    private static void appendVertices(Iterable<S2Point> points, StringBuilder out) {
        Iterator<S2Point> i = points.iterator();
        while (i.hasNext()) {
            S2TextFormat.appendVertex(i.next(), out);
            if (!i.hasNext()) continue;
            out.append(", ");
        }
    }

    private S2TextFormat() {
    }

    private static class ParseEntry {
        public String key;
        public String value;

        public ParseEntry(String k, String v) {
            this.key = k;
            this.value = v;
        }
    }
}

