/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.R2Edge;
import com.google.common.geometry.R2EdgeClipper;
import com.google.common.geometry.R2Rect;
import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2EdgeUtil;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Projections;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

public class UVEdgeClipper {
    final R2EdgeClipper r2Clipper = new R2EdgeClipper();
    private int clipFace = 0;
    private byte lastFace = 0;
    private final R2Edge faceUvEdge = new R2Edge();
    private double uvError;
    private boolean missedFace;

    public UVEdgeClipper() {
    }

    public UVEdgeClipper(int face, R2Rect region) {
        this();
        this.init(face, region);
    }

    public UVEdgeClipper(S2Cell cell) {
        this();
        this.init(cell);
    }

    public void init(int face, R2Rect region) {
        this.clipFace = face;
        this.r2Clipper.init(region);
    }

    public void init(S2Cell cell) {
        this.init(cell.face(), cell.getBoundUV());
    }

    public int clipFace() {
        return this.clipFace;
    }

    public R2Rect clipRect() {
        return this.r2Clipper.clipRect();
    }

    @CanIgnoreReturnValue
    public boolean clipEdge(S2Point v0, S2Point v1, boolean connected) {
        byte face1;
        assert (!v0.equalsPoint(S2Point.ORIGIN) && !v1.equalsPoint(S2Point.ORIGIN));
        assert (v0.largestAbsComponent() <= 2);
        assert (v1.largestAbsComponent() <= 2);
        boolean needFaceClip = false;
        if (connected) {
            byte face0 = this.lastFace;
            face1 = (byte)S2Projections.xyzToFace(v1);
            if (face0 != face1 || face0 != this.clipFace) {
                needFaceClip = true;
            } else {
                this.faceUvEdge.v0.set(this.faceUvEdge.v1);
                S2Projections.validFaceXyzToUv(face1, v1, this.faceUvEdge.v1);
            }
        } else {
            byte face0 = (byte)S2Projections.xyzToFace(v0);
            if (face0 != (face1 = (byte)S2Projections.xyzToFace(v1)) || face0 != this.clipFace) {
                needFaceClip = true;
            } else {
                S2Projections.validFaceXyzToUv(face0, v0, this.faceUvEdge.v0);
                S2Projections.validFaceXyzToUv(face0, v1, this.faceUvEdge.v1);
            }
        }
        this.lastFace = face1;
        this.missedFace = false;
        if (needFaceClip && !S2EdgeUtil.clipToPaddedFace(v0, v1, this.clipFace, S2EdgeUtil.FACE_CLIP_ERROR_UV_COORD, this.faceUvEdge.v0, this.faceUvEdge.v1)) {
            this.missedFace = true;
            return false;
        }
        this.uvError = 1.110223E-16f;
        if (needFaceClip) {
            this.uvError += S2EdgeUtil.FACE_CLIP_ERROR_UV_COORD;
        }
        return this.r2Clipper.clipEdge(this.faceUvEdge, connected);
    }

    @CanIgnoreReturnValue
    public boolean clipEdge(S2Point v0, S2Point v1) {
        return this.clipEdge(v0, v1, false);
    }

    public boolean missedFace() {
        return this.missedFace;
    }

    public double uvError() {
        return this.uvError;
    }

    public double clipError() {
        return 2.0 * (this.uvError() + 9.992007221626409E-16);
    }

    public R2Edge faceUvEdge() {
        return this.faceUvEdge;
    }

    public R2Edge clippedUvEdge() {
        return this.r2Clipper.clippedEdge;
    }

    public byte outcode(int vertex) {
        if (vertex == 0) {
            return this.r2Clipper.outcode0;
        }
        if (vertex == 1) {
            return this.r2Clipper.outcode1;
        }
        throw new IllegalArgumentException("vertex must be 0 or 1");
    }
}

