/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry.primitives;

import com.google.common.base.Preconditions;
import com.google.common.geometry.primitives.IntVector;
import com.google.common.geometry.primitives.Ints;
import com.google.common.geometry.primitives.SequenceLexicon;
import java.util.Collection;
import java.util.NoSuchElementException;

public class IdSetLexicon {
    private final SequenceLexicon idSets;
    public static final int EMPTY_SET_ID = Integer.MIN_VALUE;

    public IdSetLexicon() {
        this.idSets = new SequenceLexicon();
    }

    public IdSetLexicon(IdSetLexicon other) {
        this.idSets = new SequenceLexicon(other.idSets);
    }

    public void clear() {
        this.idSets.clear();
    }

    public boolean isEqualTo(IdSetLexicon other) {
        return this.idSets.equals(other.idSets);
    }

    public int addSingleton(int id) {
        Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0);
        return id;
    }

    public int add(IntVector ids) {
        if (ids.isEmpty()) {
            return Integer.MIN_VALUE;
        }
        if (ids.size() == 1) {
            Preconditions.checkArgument((ids.get(0) >= 0 ? 1 : 0) != 0);
            return ids.get(0);
        }
        ids.sort();
        Preconditions.checkArgument((ids.get(0) >= 0 ? 1 : 0) != 0);
        ids.unique();
        if (ids.size() == 1) {
            return ids.get(0);
        }
        return ~this.idSets.add(ids);
    }

    public int add(Ints.IntSequence ids) {
        return this.add(IntVector.copyOf(ids));
    }

    public int add(Iterable<Integer> ids) {
        return this.add(IntVector.copyOf(ids));
    }

    public IdSet idSet(final int setId) {
        if (setId >= 0) {
            return new IdSet(){
                int singletonValue;
                {
                    this.singletonValue = setId;
                }

                @Override
                public Ints.OfInt intIterator() {
                    return new Ints.OfInt(){
                        int position = 0;

                        @Override
                        public int nextInt() {
                            if (this.position == 0) {
                                ++this.position;
                                return singletonValue;
                            }
                            throw new NoSuchElementException("nextInt() called on a singleton IdSet");
                        }

                        @Override
                        public boolean hasNext() {
                            return this.position == 0;
                        }

                        @Override
                        public void forEachRemaining(Ints.IntConsumer consumer) {
                            if (this.position == 0) {
                                consumer.accept(singletonValue);
                                ++this.position;
                            }
                        }
                    };
                }

                @Override
                public int first() {
                    return this.singletonValue;
                }

                @Override
                public int size() {
                    return 1;
                }

                @Override
                public boolean isEmpty() {
                    return false;
                }

                @Override
                public void forEach(Ints.IntConsumer consumer) {
                    consumer.accept(this.singletonValue);
                }

                @Override
                public void forEach(Ints.IntBiConsumer consumer) {
                    consumer.accept(0, this.singletonValue);
                }
            };
        }
        if (setId == Integer.MIN_VALUE) {
            return new IdSet(){

                @Override
                public Ints.OfInt intIterator() {
                    return new Ints.OfInt(){

                        @Override
                        public int nextInt() {
                            throw new NoSuchElementException("nextInt() called on an empty IdSet");
                        }

                        @Override
                        public boolean hasNext() {
                            return false;
                        }

                        @Override
                        public void forEachRemaining(Ints.IntConsumer consumer) {
                        }
                    };
                }

                @Override
                public int first() {
                    throw new NoSuchElementException("first() called on an empty IdSet");
                }

                @Override
                public int size() {
                    return 0;
                }

                @Override
                public boolean isEmpty() {
                    return true;
                }

                @Override
                public void forEach(Ints.IntConsumer consumer) {
                }

                @Override
                public void forEach(Ints.IntBiConsumer consumer) {
                }
            };
        }
        return new IdSet(){
            private final Ints.IntSequence sequence;
            {
                this.sequence = IdSetLexicon.this.idSets.sequence(~setId);
            }

            @Override
            public Ints.OfInt intIterator() {
                return this.sequence.intIterator();
            }

            @Override
            public int first() {
                return this.sequence.intIterator().nextInt();
            }

            @Override
            public int size() {
                return this.sequence.size();
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public void forEach(Ints.IntConsumer consumer) {
                this.sequence.forEach(consumer);
            }

            @Override
            public void forEach(Ints.IntBiConsumer consumer) {
                this.sequence.forEach(consumer);
            }
        };
    }

    public static class TestIdSet
    extends IdSet {
        private final IntVector elements;

        public TestIdSet() {
            this.elements = IntVector.empty();
        }

        public TestIdSet(Collection<Integer> ids) {
            this.elements = IntVector.copyOf(ids);
            this.elements.sort();
            this.elements.unique();
        }

        public TestIdSet(int ... ids) {
            this.elements = IntVector.copyOf(ids);
            this.elements.sort();
            this.elements.unique();
        }

        @Override
        public Ints.OfInt intIterator() {
            return this.elements.intIterator();
        }

        @Override
        public void forEach(Ints.IntConsumer action) {
            this.elements.forEach(action);
        }

        @Override
        public void forEach(Ints.IntBiConsumer action) {
            this.elements.forEach(action);
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        @Override
        public int first() {
            return this.elements.get(0);
        }
    }

    public static abstract class IdSet
    extends Ints.ImmutableIntSequence {
        public abstract int first();
    }
}

