/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry.primitives;

import com.google.common.geometry.primitives.Ints;

public final class IntSorter {
    private IntSorter() {
    }

    public static void sort(Ints.MutableIntList data) {
        IntSorter.sort(Ints.INTEGER_COMPARATOR, data, 0, data.size() - 1);
    }

    public static void sort(Ints.MutableIntList data, int left, int right) {
        IntSorter.sort(Ints.INTEGER_COMPARATOR, data, left, right);
    }

    public static void sort(Ints.IntComparator comparator, Ints.MutableIntList data) {
        IntSorter.sort(comparator, data, 0, data.size() - 1);
    }

    public static void sort(Ints.IntComparator comparator, Ints.MutableIntList data, int left, int right) {
        while (right - left >= 8) {
            int pivot = IntSorter.pickPivot(comparator, data, left, right);
            int pa = left;
            int pb = left;
            int pc = right;
            int pd = right;
            while (true) {
                if (pb <= pc && !IntSorter.less(comparator, data, pivot, pb)) {
                    if (!IntSorter.less(comparator, data, pb, pivot)) {
                        data.swap(pa, pb);
                        pivot = pa++;
                    }
                    ++pb;
                    continue;
                }
                while (pb <= pc && !IntSorter.less(comparator, data, pc, pivot)) {
                    if (!IntSorter.less(comparator, data, pivot, pc)) {
                        data.swap(pc, pd);
                        pivot = pd--;
                    }
                    --pc;
                }
                if (pb > pc) break;
                if (pb == pivot) {
                    pivot = pc;
                } else if (pc == pivot) {
                    pivot = pb;
                }
                data.swap(pb, pc);
                ++pb;
                --pc;
            }
            int s = Math.min(pa - left, pb - pa);
            IntSorter.swapRange(data, left, pb - s, s);
            s = Math.min(pd - pc, right - pd);
            IntSorter.swapRange(data, pb, right + 1 - s, s);
            int l1 = left;
            int r1 = left + (pb - pa) - 1;
            int l2 = right + 1 - (pd - pc);
            int r2 = right;
            if (r1 - l1 < r2 - l2) {
                left = l2;
                right = r2;
            } else {
                left = l1;
                right = r1;
                l1 = l2;
                r1 = r2;
            }
            if (l1 >= r1) continue;
            IntSorter.sort(comparator, data, l1, r1);
        }
        IntSorter.insertionSort(comparator, data, left, right);
    }

    private static boolean less(Ints.IntComparator comparator, Ints.MutableIntList data, int leftIndex, int rightIndex) {
        return comparator.compare(data.get(leftIndex), data.get(rightIndex)) < 0;
    }

    private static void insertionSort(Ints.IntComparator comparator, Ints.MutableIntList data, int left, int right) {
        for (int i = left; i <= right; ++i) {
            for (int j = i; j > left && IntSorter.less(comparator, data, j, j - 1); --j) {
                data.swap(j, j - 1);
            }
        }
    }

    private static int pickPivot(Ints.IntComparator comparator, Ints.MutableIntList data, int left, int right) {
        if (right - left + 1 > 100) {
            int d = (right - left) / 8;
            int a = IntSorter.median(comparator, data, left + 0 * d, left + 1 * d, left + 2 * d);
            int b = IntSorter.median(comparator, data, left + 3 * d, left + 4 * d, left + 5 * d);
            int c = IntSorter.median(comparator, data, left + 6 * d, left + 7 * d, left + 8 * d);
            return IntSorter.median(comparator, data, a, b, c);
        }
        return IntSorter.median(comparator, data, left, (left + right) / 2, right);
    }

    private static int median(Ints.IntComparator comparator, Ints.MutableIntList data, int a, int b, int c) {
        return IntSorter.less(comparator, data, a, b) ? (IntSorter.less(comparator, data, b, c) ? b : (IntSorter.less(comparator, data, a, c) ? c : a)) : (IntSorter.less(comparator, data, c, b) ? b : (IntSorter.less(comparator, data, c, a) ? c : a));
    }

    private static void swapRange(Ints.MutableIntList data, int p1, int p2, int n) {
        for (int i = 0; i < n; ++i) {
            data.swap(p1 + i, p2 + i);
        }
    }
}

