/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry.primitives;

import com.google.common.geometry.primitives.Ints;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;

public class IntVector
implements Ints.MutableIntList {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private int[] data;
    private int numElements = 0;

    public IntVector() {
        this.data = new int[16];
    }

    public IntVector(IntVector other) {
        this.data = new int[other.data.length];
        System.arraycopy(other.data, 0, this.data, 0, other.numElements);
        this.numElements = other.numElements;
    }

    private IntVector(int initialSize) {
        int powerOfTwo = Integer.highestOneBit(initialSize);
        powerOfTwo = powerOfTwo == initialSize ? powerOfTwo : powerOfTwo << 1;
        this.data = new int[Math.max(16, powerOfTwo)];
        this.numElements = initialSize;
    }

    public static IntVector empty() {
        return new IntVector();
    }

    public static IntVector ofSize(int size) {
        return new IntVector(size);
    }

    public static IntVector ofCapacity(int capacity) {
        IntVector vec = new IntVector();
        vec.ensureCapacity(capacity);
        return vec;
    }

    public static IntVector of(int ... ints) {
        return IntVector.copyOf(ints);
    }

    public static IntVector copyOf(int[] values) {
        IntVector vec = new IntVector();
        vec.resize(values.length);
        System.arraycopy(values, 0, vec.data, 0, values.length);
        return vec;
    }

    public static IntVector copyOf(double ... values) {
        IntVector vec = IntVector.ofCapacity(values.length);
        Arrays.stream(values).mapToInt(d -> (int)d).forEach(vec::push);
        return vec;
    }

    public static IntVector copyOf(Ints.IntSequence values) {
        IntVector vec = new IntVector();
        vec.ensureCapacity(values.size());
        values.forEach(vec::push);
        return vec;
    }

    public static IntVector copyOf(Iterable<Integer> values) {
        IntVector vec = new IntVector();
        for (Integer value : values) {
            vec.push(value);
        }
        return vec;
    }

    public void copy(Ints.IntSequence sequence) {
        this.clear();
        this.addAll(sequence);
    }

    public String toString() {
        return this.debugString();
    }

    @Override
    public void clear() {
        this.numElements = 0;
    }

    @Override
    public void fill(int value) {
        Arrays.fill(this.data, value);
    }

    public void reverse() {
        Ints.reverse((int[])this.data, (int)0, (int)this.numElements);
    }

    public void reverse(int fromIndex, int toIndex) {
        this.validateFromAndToIndex(fromIndex, toIndex);
        Ints.reverse((int[])this.data, (int)fromIndex, (int)toIndex);
    }

    @Override
    public void fillConsecutive() {
        int value = 0;
        for (int i = 0; i < this.numElements; ++i) {
            this.data[i] = value++;
        }
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public boolean isEmpty() {
        return this.numElements == 0;
    }

    public int capacity() {
        return this.data.length;
    }

    public void shrink() {
        int powerOfTwo = Integer.highestOneBit(this.numElements);
        powerOfTwo = powerOfTwo == this.numElements ? powerOfTwo : powerOfTwo << 1;
        int newDataLength = Math.max(16, powerOfTwo);
        if (newDataLength == this.data.length) {
            return;
        }
        this.data = Arrays.copyOf(this.data, newDataLength);
    }

    @CanIgnoreReturnValue
    public boolean ensureCapacity(int newCapacity) {
        int minSize = Math.max(newCapacity, this.numElements);
        int powerOfTwo = Integer.highestOneBit(minSize);
        powerOfTwo = powerOfTwo == newCapacity ? powerOfTwo : powerOfTwo << 1;
        int newDataLength = Math.max(16, powerOfTwo);
        if (newDataLength <= this.data.length) {
            return false;
        }
        this.data = Arrays.copyOf(this.data, newDataLength);
        return true;
    }

    private void validateFromAndToIndex(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex >= this.numElements) {
            throw new IndexOutOfBoundsException("fromIndex " + fromIndex + " out of bounds on vector of size " + this.numElements);
        }
        if (toIndex > this.numElements) {
            throw new IndexOutOfBoundsException("toIndex " + toIndex + " out of bounds on vector of size " + this.numElements);
        }
        int size = toIndex - fromIndex;
        if (size < 0) {
            throw new IllegalArgumentException("toIndex less than fromIndex");
        }
    }

    @Override
    public Ints.IntList subList(final int fromIndex, final int toIndex) {
        this.validateFromAndToIndex(fromIndex, toIndex);
        return new Ints.IntList(){
            final int lo;
            final int hi;
            {
                this.lo = fromIndex;
                this.hi = toIndex;
            }

            @Override
            public int get(int index) {
                return IntVector.this.data[index + this.lo];
            }

            @Override
            public Ints.OfInt intIterator() {
                return new Ints.OfInt(){
                    int index;
                    {
                        this.index = lo;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < hi;
                    }

                    @Override
                    public int nextInt() {
                        if (!this.hasNext()) {
                            throw new IndexOutOfBoundsException();
                        }
                        return IntVector.this.data[this.index++];
                    }
                };
            }

            @Override
            public void forEach(Ints.IntConsumer action) {
                for (int i = this.lo; i < this.hi; ++i) {
                    action.accept(IntVector.this.data[i]);
                }
            }

            @Override
            public void forEach(Ints.IntBiConsumer action) {
                for (int i = this.lo; i < this.hi; ++i) {
                    action.accept(i - this.lo, IntVector.this.data[i]);
                }
            }

            @Override
            public int size() {
                return this.hi - this.lo;
            }
        };
    }

    @Override
    public AbstractList<Integer> asList() {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                if (index > IntVector.this.numElements) {
                    throw new NoSuchElementException("Index out of bounds: " + index);
                }
                return IntVector.this.data[index];
            }

            @Override
            public Integer set(int index, Integer value) {
                if (index > IntVector.this.numElements) {
                    throw new NoSuchElementException("Index out of bounds: " + index);
                }
                int p = IntVector.this.data[index];
                IntVector.this.data[index] = value;
                return p;
            }

            @Override
            public int size() {
                return IntVector.this.numElements;
            }
        };
    }

    public int[] asArray() {
        return this.data;
    }

    @Override
    public int[] toArray() {
        return Arrays.copyOf(this.data, this.numElements);
    }

    @Override
    public void resize(int newSize) {
        if (newSize < this.numElements) {
            this.truncate(newSize);
        }
        if (newSize > this.numElements) {
            this.enlarge(newSize);
        }
    }

    @Override
    public void truncate(int newSize) {
        if (newSize >= this.numElements) {
            return;
        }
        this.numElements = newSize;
    }

    public void enlarge(int newSize) {
        if (newSize < this.numElements) {
            return;
        }
        if (!this.ensureCapacity(newSize)) {
            Arrays.fill(this.data, this.numElements, newSize, 0);
        }
        this.numElements = newSize;
    }

    @Override
    public void add(int value) {
        if (this.numElements == this.data.length) {
            this.ensureCapacity(this.numElements + 1);
        }
        this.data[this.numElements] = value;
        ++this.numElements;
    }

    @Override
    public void push(int value) {
        this.add(value);
    }

    @Override
    @CanIgnoreReturnValue
    public int pop() {
        int head = this.data[this.numElements - 1];
        --this.numElements;
        return head;
    }

    @Override
    public int peek() {
        return this.data[this.numElements - 1];
    }

    public int back() {
        return this.data[this.numElements - 1];
    }

    @Override
    @CanIgnoreReturnValue
    public int incrementAt(int index) {
        if (index < 0 || index >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("incrementAt index " + index + " out of bounds on vector of size " + this.numElements);
        }
        this.data[index] = this.data[index] + 1;
        return this.data[index];
    }

    @Override
    @CanIgnoreReturnValue
    public int incrementAt(int index, int amount) {
        if (index < 0 || index >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("incrementAt index " + index + " out of bounds on vector of size " + this.numElements);
        }
        int n = index;
        this.data[n] = this.data[n] + amount;
        return this.data[index];
    }

    @Override
    @CanIgnoreReturnValue
    public int decrementAt(int index) {
        if (index < 0 || index >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("decrementAt index " + index + " out of bounds on vector of size " + this.numElements);
        }
        this.data[index] = this.data[index] - 1;
        return this.data[index];
    }

    @Override
    @CanIgnoreReturnValue
    public int decrementAt(int index, int amount) {
        if (index < 0 || index >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("decrementAt index " + index + " out of bounds on vector of size " + this.numElements);
        }
        int n = index;
        this.data[n] = this.data[n] - amount;
        return this.data[index];
    }

    @Override
    public int get(int index) {
        if (index < 0 || index >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("get at index " + index + " out of bounds on vector of size " + this.numElements);
        }
        return this.data[index];
    }

    @Override
    public void set(int index, int value) {
        if (index < 0 || index >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("set at index " + index + " out of bounds on vector of size " + this.numElements);
        }
        this.data[index] = value;
    }

    @Override
    public void sort() {
        Arrays.sort(this.data, 0, this.size());
    }

    public void sort(Ints.IntComparator comparator) {
        Collections.sort(this.asList(), comparator);
    }

    public boolean isSorted() {
        if (this.numElements <= 1) {
            return true;
        }
        for (int i = 1; i < this.numElements; ++i) {
            if (this.data[i - 1] <= this.data[i]) continue;
            return false;
        }
        return true;
    }

    public void shuffle(Random random) {
        for (int i = 0; i < this.size(); ++i) {
            this.swap(i, random.nextInt(this.size()));
        }
    }

    public int firstIndexOf(int value) {
        for (int i = 0; i < this.numElements; ++i) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void unique() {
        if (this.numElements <= 1) {
            return;
        }
        int dst = 0;
        for (int src = 1; src < this.numElements; ++src) {
            if (this.data[src] == this.data[dst]) continue;
            this.data[++dst] = this.data[src];
        }
        this.numElements = dst + 1;
    }

    public int lowerBound(int key) {
        return IntVector.lowerBound(0, this.numElements, index -> Integer.compare(key, this.data[index]) > 0);
    }

    public int lowerBound(int key, Ints.IntComparator comparator) {
        return IntVector.lowerBound(0, this.numElements, index -> comparator.compare(key, this.data[index]) > 0);
    }

    public int lowerBound(int key, int low, int high) {
        return IntVector.lowerBound(low, high, index -> key > this.data[index]);
    }

    public int lowerBound(int key, int low, int high, Ints.IntComparator comparator) {
        return IntVector.lowerBound(low, high, index -> comparator.compare(key, this.data[index]) > 0);
    }

    public static int lowerBound(int low, int high, Ints.IntPredicate targetIsGreater) {
        while (low < high) {
            int middle = low + (high - low) / 2;
            if (targetIsGreater.test(middle)) {
                low = middle + 1;
                continue;
            }
            high = middle;
        }
        return low;
    }

    public int upperBound(int key) {
        return IntVector.upperBound(0, this.numElements, index -> key < this.data[index]);
    }

    public int upperBound(int key, Ints.IntComparator comparator) {
        return IntVector.upperBound(0, this.numElements, index -> comparator.compare(key, this.data[index]) < 0);
    }

    public int upperBound(int key, int low, int high) {
        return IntVector.upperBound(low, high, index -> Integer.compare(key, this.data[index]) < 0);
    }

    public int upperBound(int key, int low, int high, Ints.IntComparator comparator) {
        return IntVector.upperBound(low, high, index -> comparator.compare(key, this.data[index]) < 0);
    }

    public static int upperBound(int low, int high, Ints.IntPredicate targetIsSmaller) {
        while (low < high) {
            int middle = low + (high - low) / 2;
            if (targetIsSmaller.test(middle)) {
                high = middle;
                continue;
            }
            low = middle + 1;
        }
        return low;
    }

    public void rotate(int distance) {
        if (this.numElements < 2 || distance == 0) {
            return;
        }
        Ints.rotate((int[])this.data, (int)distance, (int)0, (int)this.numElements);
    }

    public void swap(IntVector other) {
        int[] tmpData = this.data;
        int tmpNumElements = this.numElements;
        this.data = other.data;
        this.numElements = other.numElements;
        other.data = tmpData;
        other.numElements = tmpNumElements;
    }

    @Override
    public boolean less(int leftIndex, int rightIndex) {
        return this.data[leftIndex] < this.data[rightIndex];
    }

    @Override
    public void swap(int indexA, int indexB) {
        int tmp = this.data[indexA];
        this.data[indexA] = this.data[indexB];
        this.data[indexB] = tmp;
    }

    @Override
    public void forEach(Ints.IntConsumer action) {
        for (int i = 0; i < this.numElements; ++i) {
            action.accept(this.data[i]);
        }
    }

    @Override
    public void forEach(Ints.IntBiConsumer action) {
        for (int i = 0; i < this.numElements; ++i) {
            action.accept(i, this.data[i]);
        }
    }

    @Override
    public void addAll(Ints.IntSequence values) {
        values.forEach(this::add);
    }

    @Override
    public void addAll(List<Integer> values) {
        for (Integer value : values) {
            this.add(value);
        }
    }

    public void insert(int pos, int value) {
        int newSize = this.numElements + 1;
        this.ensureCapacity(newSize);
        System.arraycopy(this.data, pos, this.data, pos + 1, this.numElements - pos);
        this.data[pos] = value;
        this.numElements = newSize;
    }

    public void insert(int start, Ints.IntSequence values) {
        int newSize = this.numElements + values.size();
        this.ensureCapacity(newSize);
        System.arraycopy(this.data, start, this.data, start + values.size(), this.numElements - start);
        this.numElements = start;
        values.forEach(this::add);
        this.numElements = newSize;
    }

    @Override
    public Ints.OfInt intIterator() {
        return new Ints.OfInt(){
            int position = 0;

            @Override
            public boolean hasNext() {
                return this.position < IntVector.this.numElements;
            }

            @Override
            public int nextInt() {
                return IntVector.this.data[this.position++];
            }
        };
    }
}

