/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry.primitives;

import com.google.common.geometry.primitives.Sorter;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.IntStream;

public final class Ints {
    static final int DEBUG_STRING_MAX_ELEMENTS = 16;
    public static final MixingHasher MIXING_HASHER = new MixingHasher();
    public static final IntComparator INTEGER_COMPARATOR = new IntComparator(){

        @Override
        public int compare(int a, int b) {
            return Integer.compare(a, b);
        }
    };

    private Ints() {
    }

    public static IntConsumer arraySink(final int[] intArray) {
        return new IntConsumer(){
            int index = 0;

            @Override
            public void accept(int element) {
                intArray[this.index++] = element;
            }
        };
    }

    public static interface MutableIntList
    extends IntList,
    Sorter.SortableCollection {
        public void add(int var1);

        public void addAll(IntSequence var1);

        public void addAll(List<Integer> var1);

        public void clear();

        public void fill(int var1);

        public void fillConsecutive();

        @Override
        public void truncate(int var1);

        public void resize(int var1);

        public void set(int var1, int var2);

        @Override
        public void swap(int var1, int var2);

        public IntSequence subList(int var1, int var2);

        @CanIgnoreReturnValue
        public int incrementAt(int var1);

        @CanIgnoreReturnValue
        public int incrementAt(int var1, int var2);

        @CanIgnoreReturnValue
        public int decrementAt(int var1);

        @CanIgnoreReturnValue
        public int decrementAt(int var1, int var2);

        public void push(int var1);

        public int pop();

        public int peek();

        default public AbstractList<Integer> asList() {
            final MutableIntList ints = this;
            return new AbstractList<Integer>(){

                @Override
                public Integer get(int index) {
                    return ints.get(index);
                }

                @Override
                public Integer set(int index, Integer value) {
                    int p = ints.get(index);
                    ints.set(index, value);
                    return p;
                }

                @Override
                public int size() {
                    return ints.size();
                }
            };
        }
    }

    public static interface IntList
    extends IntSequence {
        public int get(int var1);

        default public void rangeCheck(int fromIndex, int toIndex) {
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex " + fromIndex + " greater than toIndex " + toIndex);
            }
            if (fromIndex < 0) {
                throw new ArrayIndexOutOfBoundsException("fromIndex " + fromIndex + " out of bounds.");
            }
            if (toIndex >= this.size()) {
                throw new ArrayIndexOutOfBoundsException("toIndex " + toIndex + " out of bounds on IntList of size " + this.size());
            }
        }

        default public boolean isEqualTo(IntList other) {
            if (this.size() != other.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) == other.get(i)) continue;
                return false;
            }
            return true;
        }
    }

    public static interface IntPairComparator {
        public int comparePair(int var1, int var2, int var3, int var4);
    }

    public static interface IntComparator
    extends Comparator<Integer> {
        @Override
        public int compare(int var1, int var2);

        @Override
        default public int compare(Integer a, Integer b) {
            return this.compare((int)a, (int)b);
        }
    }

    public static class MixingHasher
    implements IntSequenceHasher {
        private static final long MUL = -2576418205158650733L;
        private long hash;

        private void reset() {
            this.hash = 84L;
        }

        private void mix(long val) {
            this.hash *= -2576418205158650733L;
            this.hash = (this.hash << 19 | this.hash >>> 45) + val;
        }

        @Override
        public int hashCode(IntSequence intIter) {
            this.reset();
            intIter.forEach(this::mix);
            return (int)this.hash;
        }

        @Override
        public boolean equals(IntSequence a, IntSequence b) {
            if (a.size() != b.size()) {
                return false;
            }
            OfInt aIter = a.intIterator();
            OfInt bIter = b.intIterator();
            while (aIter.hasNext()) {
                if (!bIter.hasNext()) {
                    return false;
                }
                if (aIter.nextInt() == bIter.nextInt()) continue;
                return false;
            }
            return !bIter.hasNext();
        }
    }

    public static interface IntSequenceHasher {
        public int hashCode(IntSequence var1);

        public boolean equals(IntSequence var1, IntSequence var2);
    }

    public static abstract class ImmutableIntSequence
    implements IntSequence {
        public static final ImmutableIntSequence EMPTY = new ImmutableIntSequence(){

            @Override
            public OfInt intIterator() {
                return IntIterators.EMPTY;
            }

            @Override
            public void forEach(IntConsumer action) {
            }

            @Override
            public void forEach(IntBiConsumer action) {
            }

            @Override
            public int size() {
                return 0;
            }
        };

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof IntSequence) {
                return MIXING_HASHER.equals(this, (IntSequence)obj);
            }
            return false;
        }

        public int hashCode() {
            return MIXING_HASHER.hashCode(this);
        }

        public String toString() {
            return this.debugString();
        }

        public static ImmutableIntSequence of(final int value) {
            return new ImmutableIntSequence(){

                @Override
                public OfInt intIterator() {
                    return IntIterators.of(value);
                }

                @Override
                public void forEach(IntConsumer action) {
                    action.accept(value);
                }

                @Override
                public void forEach(IntBiConsumer action) {
                    action.accept(0, value);
                }

                @Override
                public int size() {
                    return 1;
                }
            };
        }

        public static ImmutableIntSequence of(final int ... ints) {
            return new ImmutableIntSequence(){

                @Override
                public OfInt intIterator() {
                    return IntIterators.of(ints);
                }

                @Override
                public void forEach(IntConsumer action) {
                    for (int i : ints) {
                        action.accept(i);
                    }
                }

                @Override
                public void forEach(IntBiConsumer action) {
                    for (int i = 0; i < ints.length; ++i) {
                        action.accept(i, ints[i]);
                    }
                }

                @Override
                public int size() {
                    return ints.length;
                }
            };
        }

        public static ImmutableIntSequence of(final List<Integer> ints) {
            return new ImmutableIntSequence(){

                @Override
                public OfInt intIterator() {
                    return IntIterators.of(ints);
                }

                @Override
                public void forEach(IntConsumer action) {
                    Iterator iterator = ints.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        action.accept(i);
                    }
                }

                @Override
                public void forEach(IntBiConsumer action) {
                    for (int i = 0; i < ints.size(); ++i) {
                        action.accept(i, (Integer)ints.get(i));
                    }
                }

                @Override
                public int size() {
                    return ints.size();
                }
            };
        }

        public static ImmutableIntSequence viewOf(final IntSequence ints) {
            return new ImmutableIntSequence(){

                @Override
                public OfInt intIterator() {
                    return ints.intIterator();
                }

                @Override
                public void forEach(IntConsumer action) {
                    ints.forEach(action);
                }

                @Override
                public void forEach(IntBiConsumer action) {
                    ints.forEach(action);
                }

                @Override
                public int size() {
                    return ints.size();
                }
            };
        }
    }

    public static interface IntSequence {
        public OfInt intIterator();

        public void forEach(IntConsumer var1);

        public void forEach(IntBiConsumer var1);

        public int size();

        default public boolean isEmpty() {
            return this.size() == 0;
        }

        default public boolean contains(int value) {
            OfInt iter = this.intIterator();
            while (iter.hasNext()) {
                if (iter.nextInt() != value) continue;
                return true;
            }
            return false;
        }

        default public IntStream stream() {
            return IntStream.generate(this.intIterator()::nextInt).limit(this.size());
        }

        default public int[] toArray() {
            int[] result = new int[this.size()];
            this.forEach(Ints.arraySink(result));
            return result;
        }

        public static IntSequence of(final List<Integer> ints) {
            return new IntSequence(){

                @Override
                public OfInt intIterator() {
                    return IntIterators.of(ints);
                }

                @Override
                public void forEach(IntConsumer action) {
                    Iterator iterator = ints.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        action.accept(i);
                    }
                }

                @Override
                public void forEach(IntBiConsumer action) {
                    for (int i = 0; i < ints.size(); ++i) {
                        action.accept(i, (Integer)ints.get(i));
                    }
                }

                @Override
                public int size() {
                    return ints.size();
                }

                public String toString() {
                    return this.debugString();
                }
            };
        }

        default public String debugString() {
            StringBuilder sb = new StringBuilder();
            sb.append("IntSequence of ").append(this.size()).append(" elements");
            if (this.isEmpty()) {
                sb.append(".");
                return sb.toString();
            }
            OfInt iter = this.intIterator();
            sb.append(": [").append(iter.nextInt());
            int count = 1;
            while (iter.hasNext() && count++ < 16) {
                sb.append(", ").append(iter.nextInt());
            }
            if (this.size() > 16) {
                sb.append("...");
            }
            sb.append("]");
            return sb.toString();
        }
    }

    public static final class IntIterators {
        public static final OfInt EMPTY = new OfInt(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public int nextInt() {
                throw new NoSuchElementException("nextInt() called on IntIterator.EMPTY");
            }

            @Override
            public void forEachRemaining(IntConsumer action) {
            }
        };

        private IntIterators() {
        }

        public static OfInt of(final int value) {
            return new OfInt(){
                boolean hasNext = true;

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public int nextInt() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return value;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void forEachRemaining(IntConsumer action) {
                    if (this.hasNext) {
                        this.hasNext = false;
                        action.accept(value);
                    }
                }
            };
        }

        public static OfInt of(final int ... ints) {
            return new OfInt(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < ints.length;
                }

                @Override
                public int nextInt() {
                    return ints[this.i++];
                }

                @Override
                public void forEachRemaining(IntConsumer action) {
                    while (this.i < ints.length) {
                        action.accept(this.i++);
                    }
                }
            };
        }

        public static OfInt of(final Iterable<Integer> ints) {
            return new OfInt(){
                Iterator<Integer> iter;
                {
                    this.iter = ints.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public int nextInt() {
                    return this.iter.next();
                }

                @Override
                public void forEachRemaining(IntConsumer action) {
                    while (this.iter.hasNext()) {
                        action.accept(this.iter.next());
                    }
                }
            };
        }
    }

    public static interface IntPredicate {
        public boolean test(int var1);
    }

    public static interface OfInt {
        public int nextInt();

        public boolean hasNext();

        default public void forEachRemaining(IntConsumer action) {
            while (this.hasNext()) {
                action.accept(this.nextInt());
            }
        }
    }

    public static interface IntBiConsumer {
        public void accept(int var1, int var2);
    }

    public static interface IntConsumer {
        public void accept(int var1);
    }
}

