/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry.primitives;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public final class PooledList<T>
implements Iterable<T> {
    private final List<T> elements = new ArrayList<T>();
    private final Supplier<T> supplier;
    private int size = 0;

    public PooledList(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public List<T> asList() {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return PooledList.this.get(index);
            }

            @Override
            public int size() {
                return PooledList.this.size();
            }
        };
    }

    public T get(int index) {
        this.rangeCheck(index);
        return this.elements.get(index);
    }

    public T back() {
        return this.get(this.size() - 1);
    }

    public T front() {
        return this.get(0);
    }

    public T add() {
        if (this.size == this.elements.size()) {
            T element = this.supplier.get();
            this.elements.add(element);
            ++this.size;
            return element;
        }
        return this.elements.get(this.size++);
    }

    public void removeLast() {
        --this.size;
    }

    public void remove(int index) {
        this.rangeCheck(index);
        T element = this.elements.remove(index);
        this.elements.add(element);
        --this.size;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    public void resize(int size) {
        while (size > this.size) {
            T t = this.add();
        }
        if (size < this.size) {
            this.size = size;
        }
    }

    public void sort(Comparator<T> comparator) {
        Collections.sort(this.elements.subList(0, this.size), comparator);
    }

    public void rangeCheck(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    public void swap(int leftIndex, int rightIndex) {
        this.rangeCheck(leftIndex);
        this.rangeCheck(rightIndex);
        Collections.swap(this.elements, leftIndex, rightIndex);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < PooledList.this.size;
            }

            @Override
            public T next() {
                if (this.index >= PooledList.this.size) {
                    throw new NoSuchElementException();
                }
                return PooledList.this.elements.get(this.index++);
            }
        };
    }
}

