/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry.primitives;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.geometry.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;

public class SequenceLexicon {
    private int[][] data;
    private int numElements;
    private int numBlocks;
    private int[][] begins;
    private int numSequences;
    private int numBeginsBlocks;
    private static final int DEFAULT_NUM_SEQUENCES = 128;
    private static final int DEFAULT_NUM_BLOCKS = 32;
    private static final int BLOCK_SIZE = 2048;
    private static final int BLOCK_MASK = 2047;
    private static final int BLOCK_SHIFT = 31 - Integer.numberOfLeadingZeros(2048);
    private final Int2ObjectMap<IntSet> hashCodeToSequenceIds;
    private final Ints.IntSequenceHasher hasher;
    private final boolean throwOnCollision;

    public SequenceLexicon() {
        this.hashCodeToSequenceIds = new Int2ObjectOpenHashMap();
        this.hasher = new Ints.MixingHasher();
        this.throwOnCollision = false;
        this.clear();
    }

    public SequenceLexicon(SequenceLexicon other) {
        int i;
        this.data = new int[other.data.length][];
        for (i = 0; i < other.numBlocks; ++i) {
            this.data[i] = new int[other.data[i].length];
            System.arraycopy(other.data[i], 0, this.data[i], 0, other.data[i].length);
        }
        this.numElements = other.numElements;
        this.numBlocks = other.numBlocks;
        this.begins = new int[other.begins.length][];
        for (i = 0; i < other.numBeginsBlocks; ++i) {
            this.begins[i] = new int[other.begins[i].length];
            System.arraycopy(other.begins[i], 0, this.begins[i], 0, other.begins[i].length);
        }
        this.numSequences = other.numSequences;
        this.numBeginsBlocks = other.numBeginsBlocks;
        this.hashCodeToSequenceIds = new Int2ObjectOpenHashMap();
        for (Int2ObjectMap.Entry entry : other.hashCodeToSequenceIds.int2ObjectEntrySet()) {
            IntArraySet copy = new IntArraySet();
            copy.addAll((IntCollection)entry.getValue());
            this.hashCodeToSequenceIds.put(entry.getIntKey(), (Object)copy);
        }
        this.hasher = other.hasher;
        this.throwOnCollision = other.throwOnCollision;
    }

    @VisibleForTesting
    SequenceLexicon(Ints.IntSequenceHasher testHasher, boolean throwOnCollision) {
        this.hashCodeToSequenceIds = new Int2ObjectOpenHashMap(128);
        this.hasher = testHasher;
        this.throwOnCollision = throwOnCollision;
        this.clear();
    }

    public void clear() {
        this.data = new int[32][];
        this.numElements = 0;
        this.numBlocks = 0;
        this.begins = new int[32][];
        this.begins[0] = new int[2048];
        this.begins[0][0] = 0;
        this.numSequences = 0;
        this.numBeginsBlocks = 1;
        this.hashCodeToSequenceIds.clear();
    }

    public boolean isEqualTo(SequenceLexicon other) {
        if (this.numElements != other.numElements || this.numSequences != other.numSequences) {
            return false;
        }
        for (int i = 0; i < this.numSequences; ++i) {
            if (this.hasher.equals(this.sequence(i), other.sequence(i))) continue;
            return false;
        }
        return true;
    }

    @CanIgnoreReturnValue
    public int add(Ints.IntSequence newSequence) {
        int hashCode = this.hasher.hashCode(newSequence);
        IntSet existingSequences = (IntSet)this.hashCodeToSequenceIds.get(hashCode);
        if (existingSequences != null) {
            IntIterator existingSequencesIter = existingSequences.iterator();
            while (existingSequencesIter.hasNext()) {
                int existingId = existingSequencesIter.nextInt();
                Ints.ImmutableIntSequence existingSequence = this.sequence(existingId);
                if (this.hasher.equals(existingSequence, newSequence)) {
                    return existingId;
                }
                if (!this.throwOnCollision) continue;
                throw new IllegalStateException("IntSequenceHasher collision: adding new sequence:\n" + newSequence.debugString() + "Collided with existing sequence:\n" + existingSequence.debugString());
            }
        } else {
            existingSequences = new IntArraySet();
            this.hashCodeToSequenceIds.put(hashCode, (Object)existingSequences);
        }
        int newId = this.numSequences;
        existingSequences.add(newId);
        newSequence.forEach(this::addElement);
        this.addNextBegin(this.numElements);
        return newId;
    }

    @CanIgnoreReturnValue
    public int add(List<Integer> values) {
        return this.add(Ints.ImmutableIntSequence.of(values));
    }

    private void addElement(int element) {
        int blockNum = this.numElements >>> BLOCK_SHIFT;
        if (this.numBlocks == blockNum) {
            if (this.data.length == blockNum) {
                this.reallocateData(this.data.length + 32);
            }
            this.data[this.numBlocks++] = new int[2048];
        }
        this.data[blockNum][this.numElements & 0x7FF] = element;
        ++this.numElements;
    }

    private void addNextBegin(int index) {
        ++this.numSequences;
        int blockNum = this.numSequences >>> BLOCK_SHIFT;
        if (blockNum == this.numBeginsBlocks) {
            if (this.begins.length == blockNum) {
                this.reallocateBegins(this.data.length + 32);
            }
            this.begins[this.numBeginsBlocks++] = new int[2048];
        }
        this.begins[blockNum][this.numSequences & 0x7FF] = index;
    }

    public int size() {
        return this.numSequences;
    }

    @VisibleForTesting
    int blockSize() {
        return 2048;
    }

    @VisibleForTesting
    int numBeginsBlocks() {
        return this.numBeginsBlocks;
    }

    @VisibleForTesting
    int beginsLength() {
        return this.begins.length;
    }

    @VisibleForTesting
    int numElements() {
        return this.numElements;
    }

    @VisibleForTesting
    int numBlocks() {
        return this.numBlocks;
    }

    @VisibleForTesting
    int dataLength() {
        return this.data.length;
    }

    private int getBegin(int sequenceId) {
        return this.begins[sequenceId >> BLOCK_SHIFT][sequenceId & 0x7FF];
    }

    private int getElement(int index) {
        return this.data[index >> BLOCK_SHIFT][index & 0x7FF];
    }

    private void reallocateData(int blocks) {
        int[][] newData = new int[blocks][];
        System.arraycopy(this.data, 0, newData, 0, this.numBlocks);
        this.data = newData;
    }

    private void reallocateBegins(int blocks) {
        int[][] newBegins = new int[blocks][];
        System.arraycopy(this.begins, 0, newBegins, 0, this.numBeginsBlocks);
        this.begins = newBegins;
    }

    public Ints.ImmutableIntSequence sequence(final int sequenceId) {
        Preconditions.checkArgument((sequenceId < this.numSequences && sequenceId >= 0 ? 1 : 0) != 0);
        return new Ints.ImmutableIntSequence(){
            private final int begin;
            private final int end;
            {
                this.begin = SequenceLexicon.this.getBegin(sequenceId);
                this.end = SequenceLexicon.this.getBegin(sequenceId + 1);
            }

            @Override
            public int size() {
                return this.end - this.begin;
            }

            @Override
            public void forEach(Ints.IntConsumer action) {
                for (int i = this.begin; i < this.end; ++i) {
                    action.accept(SequenceLexicon.this.getElement(i));
                }
            }

            @Override
            public void forEach(Ints.IntBiConsumer action) {
                for (int i = this.begin; i < this.end; ++i) {
                    action.accept(i - this.begin, SequenceLexicon.this.getElement(i));
                }
            }

            @Override
            public Ints.OfInt intIterator() {
                return new Ints.OfInt(){
                    int position;
                    {
                        this.position = begin;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.position < end;
                    }

                    @Override
                    public int nextInt() {
                        Preconditions.checkState((this.position < end ? 1 : 0) != 0);
                        return SequenceLexicon.this.getElement(this.position++);
                    }

                    @Override
                    public void forEachRemaining(Ints.IntConsumer action) {
                        while (this.position < end) {
                            action.accept(SequenceLexicon.this.getElement(this.position++));
                        }
                    }
                };
            }
        };
    }
}

