/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.cleaner.RecoveryUtilizationTracker;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LNFileReader;
import com.sleepycat.je.recovery.RecoveryManager;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.txn.RollbackEnd;
import com.sleepycat.je.txn.RollbackStart;
import com.sleepycat.je.txn.TxnChain;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.txn.UndoReader;
import com.sleepycat.je.utilint.DbLsn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RollbackTracker {
    private final EnvironmentImpl envImpl;
    private long checkpointStart;
    private boolean firstUndoPass;
    private final Set<Long> recoveryFilesToSync;
    private List<Long> singlePassInvisibleLsns;
    private RollbackPeriod underConstructionPeriod;
    private final List<RollbackPeriod> periodList;

    RollbackTracker(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
        this.periodList = new ArrayList<RollbackPeriod>();
        this.checkpointStart = -1L;
        this.recoveryFilesToSync = new HashSet<Long>();
        this.singlePassInvisibleLsns = new ArrayList<Long>();
    }

    void register(RollbackEnd rollbackEnd, long rollbackEndLSN) {
        this.assertFirstPass(rollbackEndLSN);
        if (this.underConstructionPeriod != null && this.underConstructionPeriod.makeNestedPeriod(rollbackEnd, rollbackEndLSN)) {
            return;
        }
        this.underConstructionPeriod = new RollbackPeriod(this, rollbackEnd, rollbackEndLSN);
        this.periodList.add(this.underConstructionPeriod);
    }

    void register(RollbackStart rollbackStart, long rollbackStartLSN) {
        this.assertFirstPass(rollbackStartLSN);
        if (this.underConstructionPeriod != null && this.underConstructionPeriod.makeNestedPeriod(rollbackStart, rollbackStartLSN)) {
            return;
        }
        this.underConstructionPeriod = new RollbackPeriod(this, rollbackStart, rollbackStartLSN);
        this.periodList.add(this.underConstructionPeriod);
    }

    void checkCommit(long commitLSN, long txnId) {
        this.assertFirstPass(commitLSN);
        if (!TxnManager.isReplicatedTxn(txnId)) {
            return;
        }
        if (this.underConstructionPeriod == null) {
            return;
        }
        if (this.underConstructionPeriod.contains(commitLSN)) {
            this.underConstructionPeriod.fail("Commit at " + DbLsn.getNoFormatString(commitLSN) + " is within rollback period.");
        }
    }

    void setCheckpointStart(long lsn) {
        this.checkpointStart = lsn;
    }

    long getCheckpointStart() {
        return this.checkpointStart;
    }

    EnvironmentImpl getEnvImpl() {
        return this.envImpl;
    }

    List<RollbackPeriod> getPeriodList() {
        return this.periodList;
    }

    void setFirstPass(boolean firstUndoPass) {
        this.firstUndoPass = firstUndoPass;
    }

    Scanner getScanner() {
        if (this.firstUndoPass) {
            return new UnderConstructionScanner();
        }
        return new BackwardScanner();
    }

    private static void setInvisible(EnvironmentImpl envImpl, List<Long> rollbackLsns, Set<Long> filesToFsync) {
        if (rollbackLsns.size() == 0) {
            return;
        }
        FileManager fileManager = envImpl.getFileManager();
        Collections.sort(rollbackLsns);
        ArrayList<Long> perFileLsns = new ArrayList<Long>();
        long currentFileNum = -1L;
        for (Long lsn : rollbackLsns) {
            if (DbLsn.getFileNumber(lsn) != currentFileNum) {
                fileManager.makeInvisible(currentFileNum, perFileLsns);
                currentFileNum = DbLsn.getFileNumber(lsn);
                filesToFsync.add(currentFileNum);
                perFileLsns = new ArrayList();
            }
            perFileLsns.add(lsn);
        }
        if (perFileLsns != null) {
            fileManager.makeInvisible(currentFileNum, perFileLsns);
        }
    }

    public static void makeInvisible(EnvironmentImpl targetEnvImpl, List<Long> rollbackLsns) {
        HashSet<Long> fsyncFiles = new HashSet<Long>();
        RollbackTracker.setInvisible(targetEnvImpl, rollbackLsns, fsyncFiles);
        targetEnvImpl.getFileManager().force(fsyncFiles);
    }

    void singlePassSetInvisible() {
        if (this.envImpl.isReadOnly()) {
            return;
        }
        RollbackTracker.setInvisible(this.envImpl, this.singlePassInvisibleLsns, this.recoveryFilesToSync);
        this.singlePassInvisibleLsns = new ArrayList<Long>();
    }

    void recoveryEndFsyncInvisible() {
        if (this.envImpl.isReadOnly()) {
            return;
        }
        this.envImpl.getFileManager().force(this.recoveryFilesToSync);
    }

    private void countObsolete(long undoLsn, UndoReader undo, RecoveryUtilizationTracker tracker) {
        tracker.countObsoleteUnconditional(undoLsn, null, undo.ln.getLastLoggedSize(), undo.db.getId(), false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (RollbackPeriod period : this.periodList) {
            sb.append(period).append("\n");
        }
        return sb.toString();
    }

    private void assertFirstPass(long logLSN) {
        if (!this.firstUndoPass) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.UNEXPECTED_STATE, "Saw entry at " + DbLsn.getNoFormatString(logLSN) + "Should only be building the tracker on the first pass");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RollbackPeriod {
        private final RollbackTracker tracker;
        private final long matchpointLSN;
        private final long rollbackStartLSN;
        private final long rollbackEndLSN;
        private final boolean beforeCheckpointStart;
        private Set<Long> activeTxnIds;
        private final Map<Long, TxnChain> txnChainMap;
        private final List<RollbackPeriod> children;
        private RollbackPeriod currentChild = null;
        private Iterator<RollbackPeriod> childIter;

        RollbackPeriod(RollbackTracker tracker, RollbackEnd rollbackEnd, long rollbackEndLSN) {
            this(tracker, rollbackEnd.getMatchpoint(), rollbackEnd.getRollbackStart(), rollbackEndLSN, tracker.getCheckpointStart(), null);
        }

        RollbackPeriod(RollbackTracker tracker, RollbackStart rollbackStart, long rollbackStartLSN) {
            this(tracker, rollbackStart.getMatchpoint(), rollbackStartLSN, -1L, tracker.getCheckpointStart(), rollbackStart.getActiveTxnIds());
        }

        RollbackPeriod(long matchpointLSN, long rollbackStartLSN, long rollbackEndLSN, long checkpointStart) {
            this(null, matchpointLSN, rollbackStartLSN, rollbackEndLSN, checkpointStart, null);
        }

        private RollbackPeriod(RollbackTracker tracker, long matchpointLSN, long rollbackStartLSN, long rollbackEndLSN, long checkpointStart, Set<Long> activeTxnIds) {
            this.tracker = tracker;
            this.matchpointLSN = matchpointLSN;
            this.rollbackStartLSN = rollbackStartLSN;
            this.rollbackEndLSN = rollbackEndLSN;
            this.beforeCheckpointStart = this.calcBeforeCheckpoint(checkpointStart);
            this.txnChainMap = new HashMap<Long, TxnChain>();
            this.children = new ArrayList<RollbackPeriod>();
            this.activeTxnIds = activeTxnIds;
        }

        private boolean calcBeforeCheckpoint(long checkpointStart) {
            return checkpointStart != -1L && this.rollbackEndLSN != -1L && DbLsn.compareTo(this.rollbackEndLSN, checkpointStart) < 0;
        }

        boolean makeNestedPeriod(RollbackEnd foundRBEnd, long foundLSN) {
            RollbackPeriod target = this.getNewPeriodTarget(foundRBEnd, foundLSN);
            if (target != null) {
                target.makeChild(foundRBEnd, foundLSN);
                return true;
            }
            return false;
        }

        boolean makeNestedPeriod(RollbackStart foundRBStart, long foundLSN) {
            RollbackPeriod target = this.getNewPeriodTarget(foundRBStart, foundLSN);
            if (target != null) {
                if (target.isMatchingRollbackStart(foundLSN)) {
                    assert (target.activeTxnIds == null);
                    target.activeTxnIds = foundRBStart.getActiveTxnIds();
                } else {
                    target.makeChild(foundRBStart, foundLSN);
                }
                return true;
            }
            return false;
        }

        private boolean contained(RollbackEnd foundRBEnd, long foundLSN) {
            if (DbLsn.compareTo(foundLSN, this.matchpointLSN) < 0) {
                return false;
            }
            if (DbLsn.compareTo(foundLSN, this.rollbackStartLSN) >= 0) {
                this.fail("Should not be two RollbackEnds in a row. New RollbackEnd at " + DbLsn.getNoFormatString(foundLSN) + " " + foundRBEnd);
            }
            if (DbLsn.compareTo(foundRBEnd.getMatchpoint(), this.matchpointLSN) < 0 || DbLsn.compareTo(foundRBEnd.getRollbackStart(), this.rollbackStartLSN) >= 0) {
                this.fail("RollbackEnd intersects current rollback period " + foundRBEnd + " at " + DbLsn.getNoFormatString(foundLSN));
            }
            return true;
        }

        private boolean contained(RollbackStart foundRBStart, long foundLSN) {
            if (DbLsn.compareTo(foundLSN, this.matchpointLSN) < 0) {
                return false;
            }
            if (this.isMatchingRollbackStart(foundLSN)) {
                return true;
            }
            if (DbLsn.compareTo(foundRBStart.getMatchpoint(), this.matchpointLSN) < 0 || DbLsn.compareTo(foundLSN, this.rollbackStartLSN) >= 0) {
                this.fail("RollbackStart intersects current rollback period " + foundRBStart + " at " + DbLsn.getNoFormatString(foundLSN));
            }
            return true;
        }

        private boolean isMatchingRollbackStart(long foundLSN) {
            return DbLsn.compareTo(foundLSN, this.rollbackStartLSN) == 0;
        }

        private void makeChild(RollbackEnd foundRBEnd, long foundLSN) {
            this.currentChild = new RollbackPeriod(this.tracker, foundRBEnd, foundLSN);
            this.children.add(this.currentChild);
        }

        private void makeChild(RollbackStart foundRBStart, long foundLSN) {
            this.currentChild = new RollbackPeriod(this.tracker, foundRBStart, foundLSN);
            this.children.add(this.currentChild);
        }

        RollbackPeriod getNewPeriodTarget(RollbackEnd foundRBEnd, long foundLSN) {
            RollbackPeriod target;
            if (this.currentChild != null && (target = this.currentChild.getNewPeriodTarget(foundRBEnd, foundLSN)) != null) {
                return target;
            }
            if (this.contained(foundRBEnd, foundLSN)) {
                return this;
            }
            return null;
        }

        RollbackPeriod getNewPeriodTarget(RollbackStart foundRBStart, long foundLSN) {
            RollbackPeriod target;
            if (this.currentChild != null && (target = this.currentChild.getNewPeriodTarget(foundRBStart, foundLSN)) != null) {
                return target;
            }
            if (this.contained(foundRBStart, foundLSN)) {
                return this;
            }
            return null;
        }

        RollbackPeriod getScannerTarget(long lsn) {
            RollbackPeriod target;
            if (this.currentChild != null && (target = this.currentChild.getScannerTarget(lsn)) != null) {
                return target;
            }
            if (DbLsn.compareTo(lsn, this.matchpointLSN) > 0) {
                return this;
            }
            return null;
        }

        void initChildIter() {
            this.childIter = this.children.iterator();
            if (this.childIter.hasNext()) {
                this.currentChild = this.childIter.next();
                this.currentChild.initChildIter();
            } else {
                this.currentChild = null;
            }
        }

        void fail(String errorMessage) {
            throw new EnvironmentFailureException(this.tracker.getEnvImpl(), EnvironmentFailureReason.LOG_INTEGRITY, errorMessage + "\ntracker contents=" + this.tracker);
        }

        boolean contains(long lsn) {
            return DbLsn.compareTo(this.matchpointLSN, lsn) < 0 && DbLsn.compareTo(this.rollbackStartLSN, lsn) > 0;
        }

        boolean containsLN(long lsn, long txnId) {
            return this.contains(lsn) && this.activeTxnIds.contains(txnId);
        }

        void positionChildren(long lsn) {
            if (this.currentChild == null) {
                return;
            }
            if (this.currentChild.follows(lsn)) {
                if (this.childIter.hasNext()) {
                    this.currentChild = this.childIter.next();
                    this.currentChild.initChildIter();
                } else {
                    this.currentChild = null;
                    return;
                }
            }
            this.currentChild.positionChildren(lsn);
        }

        RollbackPeriod findTarget(long lsn, long txnId) {
            RollbackPeriod candidate;
            if (this.currentChild != null && (candidate = this.currentChild.findTarget(lsn, txnId)) != null) {
                return candidate;
            }
            if (this.containsLN(lsn, txnId)) {
                return this;
            }
            return null;
        }

        boolean notInRollbackStartAndEnd(long lsn, long txnId) {
            if (!TxnManager.isReplicatedTxn(txnId)) {
                return true;
            }
            if (this.rollbackEndLSN == -1L) {
                return true;
            }
            return DbLsn.compareTo(this.rollbackStartLSN, lsn) >= 0 || DbLsn.compareTo(this.rollbackEndLSN, lsn) <= 0;
        }

        String bracketFailure(long lsn) {
            return lsn + " [" + DbLsn.getNoFormatString(lsn) + "] should not be within rollbackStart " + this.rollbackStartLSN + " [" + DbLsn.getNoFormatString(this.rollbackStartLSN) + "] and rollbackEnd " + this.rollbackEndLSN + " [" + DbLsn.getNoFormatString(this.rollbackEndLSN) + "]";
        }

        boolean follows(long lsn) {
            return DbLsn.compareTo(this.matchpointLSN, lsn) > 0;
        }

        boolean precedes(long lsn) {
            return DbLsn.compareTo(this.rollbackStartLSN, lsn) < 0;
        }

        TxnChain getChain(long txnId, long undoLsn, EnvironmentImpl envImpl) {
            TxnChain chain = this.txnChainMap.get(txnId);
            if (chain == null) {
                chain = new TxnChain(undoLsn, txnId, this.matchpointLSN, envImpl);
                this.txnChainMap.put(txnId, chain);
            }
            return chain;
        }

        boolean hasRollbackEnd() {
            return this.rollbackEndLSN != -1L;
        }

        public String toString() {
            return "matchpoint=" + this.matchpointLSN + " [" + DbLsn.getNoFormatString(this.matchpointLSN) + "] rollbackStart=" + this.rollbackStartLSN + " [" + DbLsn.getNoFormatString(this.rollbackStartLSN) + "] rollbackEnd=" + this.rollbackEndLSN + " [" + DbLsn.getNoFormatString(this.rollbackEndLSN) + "]";
        }

        public boolean equals(Object other) {
            if (!(other instanceof RollbackPeriod)) {
                return false;
            }
            RollbackPeriod otherPeriod = (RollbackPeriod)other;
            return this.matchpointLSN == otherPeriod.matchpointLSN && this.rollbackStartLSN == otherPeriod.rollbackStartLSN && this.rollbackEndLSN == otherPeriod.rollbackEndLSN;
        }

        boolean beforeCheckpointStart() {
            return this.beforeCheckpointStart;
        }
    }

    class BackwardScanner
    extends Scanner {
        private final Iterator<RollbackPeriod> iter;
        private RollbackPeriod currentPeriod;

        BackwardScanner() {
            this.iter = RollbackTracker.this.periodList.iterator();
            if (this.iter.hasNext()) {
                this.currentPeriod = this.iter.next();
                this.currentPeriod.initChildIter();
            } else {
                this.currentPeriod = null;
            }
        }

        public boolean positionAndCheck(long lsn, long txnId) {
            if (this.currentPeriod == null) {
                return false;
            }
            if (this.currentPeriod.follows(lsn)) {
                if (this.iter.hasNext()) {
                    this.currentPeriod = this.iter.next();
                    this.currentPeriod.initChildIter();
                } else {
                    this.currentPeriod = null;
                    return false;
                }
            }
            assert (this.currentPeriod.notInRollbackStartAndEnd(lsn, txnId)) : this.currentPeriod.bracketFailure(lsn);
            if (this.currentPeriod.contains(lsn)) {
                this.currentPeriod.positionChildren(lsn);
                this.target = this.currentPeriod.findTarget(lsn, txnId);
                return this.target != null;
            }
            return false;
        }
    }

    class UnderConstructionScanner
    extends Scanner {
        UnderConstructionScanner() {
        }

        public boolean positionAndCheck(long lsn, long txnId) {
            if (RollbackTracker.this.underConstructionPeriod == null) {
                return false;
            }
            assert (RollbackTracker.this.underConstructionPeriod.notInRollbackStartAndEnd(lsn, txnId)) : RollbackTracker.access$300(RollbackTracker.this).bracketFailure(lsn);
            this.target = RollbackTracker.this.underConstructionPeriod.getScannerTarget(lsn);
            return this.target != null && this.target.containsLN(lsn, txnId);
        }
    }

    abstract class Scanner {
        RollbackPeriod target;

        Scanner() {
        }

        abstract boolean positionAndCheck(long var1, long var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback(Long txnId, LNFileReader reader, RecoveryUtilizationTracker tracker) {
            if (this.target.beforeCheckpointStart()) {
                return;
            }
            long undoLsn = reader.getLastLsn();
            TreeLocation location = new TreeLocation();
            TxnChain chain = this.target.getChain(txnId, undoLsn, RollbackTracker.this.envImpl);
            UndoReader undo = new UndoReader(reader, RollbackTracker.this.envImpl.getDbTree());
            try {
                TxnChain.RevertInfo revertTo = chain.pop();
                RecoveryManager.rollbackUndo(RollbackTracker.this.envImpl.getLogger(), Level.FINER, undo, revertTo, location, undoLsn);
                if (!this.target.hasRollbackEnd() && !reader.isInvisible()) {
                    RollbackTracker.this.singlePassInvisibleLsns.add(undoLsn);
                }
                Object var11_9 = null;
                undo.releaseDb();
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                undo.releaseDb();
                throw throwable;
            }
            RollbackTracker.this.countObsolete(undoLsn, undo, tracker);
        }

        boolean needsRollback() {
            if (this.target == null) {
                return false;
            }
            return !this.target.beforeCheckpointStart();
        }
    }
}

