/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.ClientIO;
import dods.dap.DataReadException;
import dods.dap.PrimitiveVector;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;

public class BaseTypePrimitiveVector
extends PrimitiveVector
implements Cloneable {
    private BaseType[] vals;

    public BaseTypePrimitiveVector(BaseType var) {
        super(var);
    }

    public Object clone() {
        BaseTypePrimitiveVector v = (BaseTypePrimitiveVector)super.clone();
        if (this.vals != null) {
            v.vals = new BaseType[this.vals.length];
            System.arraycopy(this.vals, 0, v.vals, 0, this.vals.length);
        }
        return v;
    }

    public int getLength() {
        return this.vals.length;
    }

    public void setLength(int len) {
        this.vals = new BaseType[len];
    }

    public final BaseType getValue(int i) {
        return this.vals[i];
    }

    public final void setValue(int i, BaseType newVal) {
        this.vals[i] = newVal;
    }

    public void printVal(PrintWriter os, String space) {
        int len = this.vals.length;
        for (int i = 0; i < len - 1; ++i) {
            this.vals[i].printVal(os, "", false);
            os.print(", ");
        }
        if (len > 0) {
            this.vals[len - 1].printVal(os, "", false);
        }
    }

    public void printSingleVal(PrintWriter os, int index) {
        this.vals[index].printVal(os, "", false);
    }

    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = (BaseType)this.getTemplate().clone();
            ((ClientIO)((Object)this.vals[i])).deserialize(source, sv, statusUI);
            if (statusUI == null || !statusUI.userCancelled()) continue;
            throw new DataReadException("User cancelled");
        }
    }

    public void externalize(DataOutputStream sink) throws IOException {
        for (int i = 0; i < this.vals.length; ++i) {
            ((ClientIO)((Object)this.vals[i])).externalize(sink);
        }
    }

    public void externalize(DataOutputStream sink, int start, int stop, int stride) throws IOException {
        for (int i = start; i <= stop; i += stride) {
            ((ClientIO)((Object)this.vals[i])).externalize(sink);
        }
    }

    public Object getInternalStorage() {
        return this.vals;
    }

    public void setInternalStorage(Object o) {
        this.vals = (BaseType[])o;
    }

    public PrimitiveVector subset(int start, int stop, int stride) {
        BaseTypePrimitiveVector n = new BaseTypePrimitiveVector(this.getTemplate());
        stride = Math.max(stride, 1);
        stop = Math.max(start, stop);
        int length = 1 + (stop - start) / stride;
        n.setLength(length);
        int count = 0;
        for (int i = start; i <= stop; i += stride) {
            n.setValue(count, this.vals[i]);
            ++count;
        }
        return n;
    }
}

